/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.xmlutil;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlEncodingDetector {
    private static final String UTF_8 = "UTF-8";
    private static final String UTF_16BE = "UTF-16BE";
    private static final String UTF_16LE = "UTF-16LE";
    private static final String UTF_16 = "UTF-16";
    private static final Pattern ENCODING_PATTERN = Pattern.compile("^<\\?xml.*encoding=\"(.*)\".*\\?>");
    private static final MessageFormat RAW_EX_1 = new MessageFormat("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch");
    private static final MessageFormat RAW_EX_2 = new MessageFormat("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] unknown BOM");

    public static String detectEncoding(byte[] data) {
        String bomEnc = XmlEncodingDetector.getBOMEncoding(data);
        String xmlGuessEnc = XmlEncodingDetector.getXMLGuessEncoding(data);
        String xmlEnc = XmlEncodingDetector.getXMLPrologEncoding(data, xmlGuessEnc);
        String encoding = XmlEncodingDetector.calculateRawEncoding(bomEnc, xmlGuessEnc, xmlEnc);
        return encoding;
    }

    private static String getBOMEncoding(byte[] bytes) {
        String encoding = null;
        if (bytes[0] == 254 && bytes[1] == 255) {
            encoding = UTF_16BE;
        } else if (bytes[0] == 255 && bytes[1] == 254) {
            encoding = UTF_16LE;
        } else if (bytes[0] == 239 && bytes[1] == 187 && bytes[2] == 191) {
            encoding = UTF_8;
        }
        return encoding;
    }

    private static String getXMLGuessEncoding(byte[] bytes) {
        String encoding = null;
        if (bytes[0] == 0 && bytes[1] == 60 && bytes[2] == 0 && bytes[3] == 63) {
            encoding = UTF_16BE;
        } else if (bytes[0] == 60 && bytes[1] == 0 && bytes[2] == 63 && bytes[3] == 0) {
            encoding = UTF_16LE;
        } else if (bytes[0] == 60 && bytes[1] == 63 && bytes[2] == 120 && bytes[3] == 109) {
            encoding = UTF_8;
        }
        return encoding;
    }

    private static String getXMLPrologEncoding(byte[] data, String guessedEnc) {
        String encoding = null;
        if (guessedEnc != null && data.length > -1) {
            int endFirstLinePos = Math.min(data.length, 1024);
            for (int i = 0; i < 1024 && i < data.length; ++i) {
                if (data[i] != 10 && data[i] != 13) continue;
                endFirstLinePos = i;
                break;
            }
            String prolog = null;
            try {
                prolog = new String(data, 0, endFirstLinePos, guessedEnc);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            Matcher m = ENCODING_PATTERN.matcher(prolog);
            encoding = m.find() ? m.group(1).toUpperCase() : null;
        }
        return encoding;
    }

    /*
     * WARNING - void declaration
     */
    private static String calculateRawEncoding(String bomEnc, String xmlGuessEnc, String xmlEnc) {
        void var3_3;
        String encoding;
        if (bomEnc == null) {
            encoding = xmlGuessEnc == null || xmlEnc == null ? UTF_8 : (xmlEnc.equals(UTF_16) && (xmlGuessEnc.equals(UTF_16BE) || xmlGuessEnc.equals(UTF_16LE)) ? xmlGuessEnc : xmlEnc);
        } else if (bomEnc.equals(UTF_8)) {
            if (xmlGuessEnc != null && !xmlGuessEnc.equals(UTF_8)) {
                throw new RuntimeException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}));
            }
            if (xmlEnc != null && !xmlEnc.equals(UTF_8)) {
                throw new RuntimeException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}));
            }
            encoding = UTF_8;
        } else if (bomEnc.equals(UTF_16BE) || bomEnc.equals(UTF_16LE)) {
            if (xmlGuessEnc != null && !xmlGuessEnc.equals(bomEnc)) {
                throw new RuntimeException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}));
            }
            if (xmlEnc != null && !xmlEnc.equals(UTF_16) && !xmlEnc.equals(bomEnc)) {
                throw new RuntimeException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}));
            }
            encoding = bomEnc;
        } else {
            throw new RuntimeException(RAW_EX_2.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}));
        }
        return var3_3;
    }
}

