/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.xmlutil;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class HtmlBodyRemovalHandler
implements ContentHandler {
    private int nestingLevel = 0;
    private boolean inHtml = false;
    private boolean inBody = false;
    private ContentHandler consumer;

    public HtmlBodyRemovalHandler(ContentHandler consumer) {
        this.consumer = consumer;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        ++this.nestingLevel;
        if (this.inBody) {
            this.consumer.startElement(namespaceURI, localName, qName, atts);
        } else if (this.nestingLevel == 1 && localName.equals("html") && namespaceURI.equals("")) {
            this.inHtml = true;
        } else if (this.inHtml && this.nestingLevel == 2 && localName.equals("body") && namespaceURI.equals("")) {
            this.inBody = true;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.inBody && this.nestingLevel == 2 && localName.equals("body") && namespaceURI.equals("")) {
            this.inBody = false;
        } else if (this.inBody) {
            this.consumer.endElement(namespaceURI, localName, qName);
        }
        --this.nestingLevel;
    }

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inBody) {
            this.consumer.characters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.inBody) {
            this.consumer.ignorableWhitespace(ch, start, length);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.inBody) {
            this.consumer.skippedEntity(name);
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.inBody) {
            this.consumer.setDocumentLocator(locator);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.inBody) {
            this.consumer.processingInstruction(target, data);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.consumer.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.consumer.endPrefixMapping(prefix);
    }
}

