/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.jdbcutil;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class DriverLoader {
    public static void loadDatabaseDriver(String classpath, String driverClass) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(classpath, ",");
        while (tokenizer.hasMoreTokens()) {
            String filename = tokenizer.nextToken().trim();
            try {
                URL url = new File(filename).toURL();
                urls.add(url);
            }
            catch (MalformedURLException e) {
                throw new Exception("Invalid filename in driver path.", e);
            }
        }
        URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
        Driver driver = (Driver)Class.forName(driverClass, true, classLoader).newInstance();
        DriverManager.registerDriver(new DriverShim(driver));
    }

    private static final class DriverShim
    implements Driver {
        private Driver driver;

        DriverShim(Driver d) {
            this.driver = d;
        }

        public final boolean acceptsURL(String u) throws SQLException {
            return this.driver.acceptsURL(u);
        }

        public final Connection connect(String u, Properties p) throws SQLException {
            return this.driver.connect(u, p);
        }

        public final int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        public final int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        public final DriverPropertyInfo[] getPropertyInfo(String u, Properties p) throws SQLException {
            return this.driver.getPropertyInfo(u, p);
        }

        public final boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }
    }
}

