/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.view.MotionEvent;
import org.osmdroid.library.R;
import org.osmdroid.views.MapView;

public class CustomZoomButtonsDisplay {
    private final MapView mMapView;
    private final Point mUnrotatedPoint = new Point();
    private Bitmap mZoomInBitmapEnabled;
    private Bitmap mZoomOutBitmapEnabled;
    private Bitmap mZoomInBitmapDisabled;
    private Bitmap mZoomOutBitmapDisabled;
    private Paint mAlphaPaint;
    private int mBitmapSize;
    private HorizontalPosition mHorizontalPosition;
    private VerticalPosition mVerticalPosition;
    private boolean mHorizontalOrVertical;
    private float mMargin;
    private float mPadding;
    private float mAdditionalPixelMarginLeft;
    private float mAdditionalPixelMarginTop;
    private float mAdditionalPixelMarginRight;
    private float mAdditionalPixelMarginBottom;
    private float mPixelMarginLeft;
    private float mPixelMarginTop;
    private float mPixelMarginRight;
    private float mPixelMarginBottom;

    public CustomZoomButtonsDisplay(MapView pMapView) {
        this.mMapView = pMapView;
        this.setPositions(true, HorizontalPosition.CENTER, VerticalPosition.BOTTOM);
        this.setMarginPadding(0.5f, 0.5f);
    }

    public void setPositions(boolean pHorizontalOrVertical, HorizontalPosition pHorizontalPosition, VerticalPosition pVerticalPosition) {
        this.mHorizontalOrVertical = pHorizontalOrVertical;
        this.mHorizontalPosition = pHorizontalPosition;
        this.mVerticalPosition = pVerticalPosition;
    }

    public void setMarginPadding(float pMargin, float pPadding) {
        this.mMargin = pMargin;
        this.mPadding = pPadding;
        this.refreshPixelMargins();
    }

    public void setAdditionalPixelMargins(float pLeft, float pTop, float pRight, float pBottom) {
        this.mAdditionalPixelMarginLeft = pLeft;
        this.mAdditionalPixelMarginTop = pTop;
        this.mAdditionalPixelMarginRight = pRight;
        this.mAdditionalPixelMarginBottom = pBottom;
        this.refreshPixelMargins();
    }

    private void refreshPixelMargins() {
        float bitmapFractionMarginInPixels = this.mMargin * (float)this.mBitmapSize;
        this.mPixelMarginLeft = bitmapFractionMarginInPixels + this.mAdditionalPixelMarginLeft;
        this.mPixelMarginTop = bitmapFractionMarginInPixels + this.mAdditionalPixelMarginTop;
        this.mPixelMarginRight = bitmapFractionMarginInPixels + this.mAdditionalPixelMarginRight;
        this.mPixelMarginBottom = bitmapFractionMarginInPixels + this.mAdditionalPixelMarginBottom;
    }

    public void setBitmaps(Bitmap pInEnabled, Bitmap pInDisabled, Bitmap pOutEnabled, Bitmap pOutDisabled) {
        this.mZoomInBitmapEnabled = pInEnabled;
        this.mZoomInBitmapDisabled = pInDisabled;
        this.mZoomOutBitmapEnabled = pOutEnabled;
        this.mZoomOutBitmapDisabled = pOutDisabled;
        this.mBitmapSize = this.mZoomInBitmapEnabled.getWidth();
        this.refreshPixelMargins();
    }

    protected Bitmap getZoomBitmap(boolean pInOrOut, boolean pEnabled) {
        Bitmap icon = this.getIcon(pInOrOut);
        this.mBitmapSize = icon.getWidth();
        this.refreshPixelMargins();
        Bitmap bitmap = Bitmap.createBitmap((int)this.mBitmapSize, (int)this.mBitmapSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(pEnabled ? -1 : -3355444);
        backgroundPaint.setStyle(Paint.Style.FILL);
        canvas.drawRect(0.0f, 0.0f, (float)(this.mBitmapSize - 1), (float)(this.mBitmapSize - 1), backgroundPaint);
        canvas.drawBitmap(icon, 0.0f, 0.0f, null);
        return bitmap;
    }

    protected Bitmap getIcon(boolean pInOrOut) {
        int resourceId = pInOrOut ? R.drawable.sharp_add_black_36 : R.drawable.sharp_remove_black_36;
        return ((BitmapDrawable)this.mMapView.getResources().getDrawable(resourceId)).getBitmap();
    }

    public void draw(Canvas pCanvas, float pAlpha01, boolean pZoomInEnabled, boolean pZoomOutEnabled) {
        Paint paint;
        if (pAlpha01 == 0.0f) {
            return;
        }
        if (pAlpha01 == 1.0f) {
            paint = null;
        } else {
            if (this.mAlphaPaint == null) {
                this.mAlphaPaint = new Paint();
            }
            this.mAlphaPaint.setAlpha((int)(pAlpha01 * 255.0f));
            paint = this.mAlphaPaint;
        }
        pCanvas.drawBitmap(this.getBitmap(true, pZoomInEnabled), this.getTopLeft(true, true), this.getTopLeft(true, false), paint);
        pCanvas.drawBitmap(this.getBitmap(false, pZoomOutEnabled), this.getTopLeft(false, true), this.getTopLeft(false, false), paint);
    }

    private float getTopLeft(boolean pInOrOut, boolean pXOrY) {
        if (pXOrY) {
            float topLeft = this.getFirstLeft(this.mMapView.getWidth());
            if (!this.mHorizontalOrVertical) {
                return topLeft;
            }
            if (!pInOrOut) {
                return topLeft;
            }
            return topLeft + (float)this.mBitmapSize + this.mPadding * (float)this.mBitmapSize;
        }
        float topLeft = this.getFirstTop(this.mMapView.getHeight());
        if (this.mHorizontalOrVertical) {
            return topLeft;
        }
        if (pInOrOut) {
            return topLeft;
        }
        return topLeft + (float)this.mBitmapSize + this.mPadding * (float)this.mBitmapSize;
    }

    private float getFirstLeft(int pMapViewWidth) {
        switch (this.mHorizontalPosition) {
            case LEFT: {
                return this.mPixelMarginLeft;
            }
            case RIGHT: {
                return (float)pMapViewWidth - this.mPixelMarginRight - (float)this.mBitmapSize - (this.mHorizontalOrVertical ? this.mPadding * (float)this.mBitmapSize + (float)this.mBitmapSize : 0.0f);
            }
            case CENTER: {
                return (float)pMapViewWidth / 2.0f - (this.mHorizontalOrVertical ? this.mPadding * (float)this.mBitmapSize / 2.0f + (float)this.mBitmapSize : (float)this.mBitmapSize / 2.0f);
            }
        }
        throw new IllegalArgumentException();
    }

    private float getFirstTop(int pMapViewHeight) {
        switch (this.mVerticalPosition) {
            case TOP: {
                return this.mPixelMarginTop;
            }
            case BOTTOM: {
                return (float)pMapViewHeight - this.mPixelMarginBottom - (float)this.mBitmapSize - (this.mHorizontalOrVertical ? 0.0f : this.mPadding * (float)this.mBitmapSize + (float)this.mBitmapSize);
            }
            case CENTER: {
                return (float)pMapViewHeight / 2.0f - (this.mHorizontalOrVertical ? (float)this.mBitmapSize / 2.0f : this.mPadding * (float)this.mBitmapSize / 2.0f + (float)this.mBitmapSize);
            }
        }
        throw new IllegalArgumentException();
    }

    private Bitmap getBitmap(boolean pInOrOut, boolean pEnabled) {
        if (this.mZoomInBitmapEnabled == null) {
            this.setBitmaps(this.getZoomBitmap(true, true), this.getZoomBitmap(true, false), this.getZoomBitmap(false, true), this.getZoomBitmap(false, false));
        }
        if (pInOrOut) {
            return pEnabled ? this.mZoomInBitmapEnabled : this.mZoomInBitmapDisabled;
        }
        return pEnabled ? this.mZoomOutBitmapEnabled : this.mZoomOutBitmapDisabled;
    }

    @Deprecated
    public boolean isTouchedRotated(MotionEvent pMotionEvent, boolean pInOrOut) {
        if (this.mMapView.getMapOrientation() == 0.0f) {
            this.mUnrotatedPoint.set((int)pMotionEvent.getX(), (int)pMotionEvent.getY());
        } else {
            this.mMapView.getProjection().rotateAndScalePoint((int)pMotionEvent.getX(), (int)pMotionEvent.getY(), this.mUnrotatedPoint);
        }
        return this.isTouched(this.mUnrotatedPoint.x, this.mUnrotatedPoint.y, pInOrOut);
    }

    public boolean isTouched(MotionEvent pMotionEvent, boolean pInOrOut) {
        int action = pMotionEvent.getAction();
        if (action == 0 || action == 1) {
            return this.isTouched((int)pMotionEvent.getX(), (int)pMotionEvent.getY(), pInOrOut);
        }
        return false;
    }

    private boolean isTouched(int pEventX, int pEventY, boolean pInOrOut) {
        return this.isTouched(pInOrOut, true, pEventX) && this.isTouched(pInOrOut, false, pEventY);
    }

    private boolean isTouched(boolean pInOrOut, boolean pXOrY, float pEvent) {
        float topLeft = this.getTopLeft(pInOrOut, pXOrY);
        return pEvent >= topLeft && pEvent <= topLeft + (float)this.mBitmapSize;
    }

    public static enum VerticalPosition {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum HorizontalPosition {
        LEFT,
        CENTER,
        RIGHT;

    }
}

