/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.advancedpolyline;

import org.osmdroid.views.overlay.advancedpolyline.ColorHelper;
import org.osmdroid.views.overlay.advancedpolyline.ColorMappingForScalar;

public abstract class ColorMappingVariation
extends ColorMappingForScalar {
    private float mStart;
    private float mEnd;
    private float mScalarStart;
    private float mScalarEnd;
    private float mSlope;

    protected void init(float scalarStart, float scalarEnd, float start, float end) {
        this.mScalarStart = scalarStart;
        this.mScalarEnd = scalarEnd;
        this.mStart = start;
        this.mEnd = end;
        this.mSlope = (this.mEnd - this.mStart) / (this.mScalarEnd - this.mScalarStart);
    }

    @Override
    protected int computeColor(float pScalar) {
        return ColorHelper.HSLToColor(this.getHue(pScalar), this.getSaturation(pScalar), this.getLuminance(pScalar));
    }

    protected abstract float getHue(float var1);

    protected abstract float getSaturation(float var1);

    protected abstract float getLuminance(float var1);

    protected float mapScalar(float scalar) {
        if (scalar >= this.mScalarEnd) {
            return this.mEnd;
        }
        if (scalar <= this.mScalarStart) {
            return this.mStart;
        }
        return scalar * this.mSlope + this.mStart;
    }
}

