/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.drawable.Drawable;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.modules.SqlTileWriter;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.StreamUtils;
import org.osmdroid.util.MapTileIndex;

public class SqliteArchiveTileWriter
implements IFilesystemCache {
    final File db_file;
    final SQLiteDatabase mDatabase;
    final int questimate = 8000;
    static boolean hasInited = false;
    private static final String[] queryColumns = new String[]{"tile"};

    public SqliteArchiveTileWriter(String outputFile) throws Exception {
        this.db_file = new File(outputFile);
        try {
            this.mDatabase = SQLiteDatabase.openOrCreateDatabase((String)this.db_file.getAbsolutePath(), null);
        }
        catch (Exception ex) {
            throw new Exception("Trouble creating database file at " + outputFile, ex);
        }
        try {
            this.mDatabase.execSQL("CREATE TABLE IF NOT EXISTS tiles (key INTEGER , provider TEXT, tile BLOB, PRIMARY KEY (key, provider));");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Log.d((String)"OsmDroid", (String)"error setting db schema, it probably exists already", (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveFile(ITileSource pTileSourceInfo, long pMapTileIndex, InputStream pStream, Long pExpirationTime) {
        if (this.mDatabase == null || !this.mDatabase.isOpen()) {
            Log.d((String)"OsmDroid", (String)"Skipping SqlArchiveTileWriter saveFile, database is closed");
            return false;
        }
        boolean returnValue = false;
        ByteArrayOutputStream bos = null;
        try {
            int l;
            ContentValues cv = new ContentValues();
            long index = SqlTileWriter.getIndex(pMapTileIndex);
            cv.put("provider", pTileSourceInfo.name());
            byte[] buffer = new byte[512];
            bos = new ByteArrayOutputStream();
            while ((l = pStream.read(buffer)) != -1) {
                bos.write(buffer, 0, l);
            }
            byte[] bits = bos.toByteArray();
            cv.put("key", Long.valueOf(index));
            cv.put("tile", bits);
            this.mDatabase.insert("tiles", null, cv);
            returnValue = true;
            if (Configuration.getInstance().isDebugMode()) {
                Log.d((String)"OsmDroid", (String)("tile inserted " + pTileSourceInfo.name() + MapTileIndex.toString(pMapTileIndex)));
            }
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSourceInfo.name() + " " + MapTileIndex.toString(pMapTileIndex)), (Throwable)ex);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException cv) {}
        }
        return returnValue;
    }

    @Override
    public boolean exists(ITileSource pTileSource, long pMapTileIndex) {
        try {
            long index = SqlTileWriter.getIndex(pMapTileIndex);
            Cursor cur = this.getTileCursor(SqlTileWriter.getPrimaryKeyParameters(index, pTileSource));
            boolean result = cur.getCount() != 0;
            cur.close();
            return result;
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSource.name() + " " + MapTileIndex.toString(pMapTileIndex)), (Throwable)ex);
            return false;
        }
    }

    @Override
    public void onDetach() {
        if (this.mDatabase != null) {
            this.mDatabase.close();
        }
    }

    @Override
    public boolean remove(ITileSource tileSource, long pMapTileIndex) {
        return false;
    }

    @Override
    public Long getExpirationTimestamp(ITileSource pTileSource, long pMapTileIndex) {
        return null;
    }

    public Cursor getTileCursor(String[] pPrimaryKeyParameters) {
        if (this.mDatabase == null || !this.mDatabase.isOpen()) {
            Log.w((String)"OsmDroid", (String)"Skipping SqlArchiveTileWriter getTileCursor, database is closed");
            return null;
        }
        return this.mDatabase.query("tiles", queryColumns, SqlTileWriter.getPrimaryKey(), pPrimaryKeyParameters, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Drawable loadTile(ITileSource pTileSource, long pMapTileIndex) throws Exception {
        Drawable drawable;
        block12: {
            byte[] bits;
            ByteArrayInputStream inputStream;
            block10: {
                Drawable drawable2;
                block11: {
                    Cursor cur;
                    block8: {
                        Drawable drawable3;
                        block9: {
                            if (this.mDatabase == null || !this.mDatabase.isOpen()) {
                                Log.w((String)"OsmDroid", (String)"Skipping SqlArchiveTileWriter loadTile, database is closed");
                                return null;
                            }
                            inputStream = null;
                            try {
                                long index = SqlTileWriter.getIndex(pMapTileIndex);
                                cur = this.getTileCursor(SqlTileWriter.getPrimaryKeyParameters(index, pTileSource));
                                if (cur != null) break block8;
                                drawable3 = null;
                                if (inputStream == null) break block9;
                            }
                            catch (Throwable throwable) {
                                if (inputStream != null) {
                                    StreamUtils.closeStream(inputStream);
                                }
                                throw throwable;
                            }
                            StreamUtils.closeStream(inputStream);
                        }
                        return drawable3;
                    }
                    bits = null;
                    if (cur.moveToFirst()) {
                        bits = cur.getBlob(cur.getColumnIndex("tile"));
                    }
                    cur.close();
                    if (bits != null) break block10;
                    if (Configuration.getInstance().isDebugMode()) {
                        Log.d((String)"OsmDroid", (String)("SqlCache - Tile doesn't exist: " + pTileSource.name() + MapTileIndex.toString(pMapTileIndex)));
                    }
                    drawable2 = null;
                    if (inputStream == null) break block11;
                    StreamUtils.closeStream(inputStream);
                }
                return drawable2;
            }
            inputStream = new ByteArrayInputStream(bits);
            drawable = pTileSource.getDrawable(inputStream);
            if (inputStream == null) break block12;
            StreamUtils.closeStream(inputStream);
        }
        return drawable;
    }
}

