/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import android.graphics.Rect;
import org.osmdroid.util.MapTileIndex;
import org.osmdroid.util.MyMath;
import org.osmdroid.util.RectL;
import org.osmdroid.util.TileSystem;

public abstract class TileLooper {
    protected final Rect mTiles = new Rect();
    protected int mTileZoomLevel;
    private boolean horizontalWrapEnabled = true;
    private boolean verticalWrapEnabled = true;

    public TileLooper() {
        this(false, false);
    }

    public TileLooper(boolean horizontalWrapEnabled, boolean verticalWrapEnabled) {
        this.horizontalWrapEnabled = horizontalWrapEnabled;
        this.verticalWrapEnabled = verticalWrapEnabled;
    }

    protected void loop(double pZoomLevel, RectL pMercatorViewPort) {
        TileSystem.getTileFromMercator(pMercatorViewPort, TileSystem.getTileSize(pZoomLevel), this.mTiles);
        this.mTileZoomLevel = TileSystem.getInputTileZoomLevel(pZoomLevel);
        this.initialiseLoop();
        int mapTileUpperBound = 1 << this.mTileZoomLevel;
        for (int i = this.mTiles.left; i <= this.mTiles.right; ++i) {
            for (int j = this.mTiles.top; j <= this.mTiles.bottom; ++j) {
                if (!this.horizontalWrapEnabled && (i < 0 || i >= mapTileUpperBound) || !this.verticalWrapEnabled && (j < 0 || j >= mapTileUpperBound)) continue;
                int tileX = MyMath.mod(i, mapTileUpperBound);
                int tileY = MyMath.mod(j, mapTileUpperBound);
                long tile = MapTileIndex.getTileIndex(this.mTileZoomLevel, tileX, tileY);
                this.handleTile(tile, i, j);
            }
        }
        this.finaliseLoop();
    }

    public void initialiseLoop() {
    }

    public abstract void handleTile(long var1, int var3, int var4);

    public void finaliseLoop() {
    }

    public boolean isHorizontalWrapEnabled() {
        return this.horizontalWrapEnabled;
    }

    public void setHorizontalWrapEnabled(boolean horizontalWrapEnabled) {
        this.horizontalWrapEnabled = horizontalWrapEnabled;
    }

    public boolean isVerticalWrapEnabled() {
        return this.verticalWrapEnabled;
    }

    public void setVerticalWrapEnabled(boolean verticalWrapEnabled) {
        this.verticalWrapEnabled = verticalWrapEnabled;
    }
}

