/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.util.Log;
import java.util.concurrent.atomic.AtomicReference;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.modules.CantContinueException;
import org.osmdroid.tileprovider.modules.MapTileFileStorageProviderBase;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.modules.TileWriter;
import org.osmdroid.tileprovider.tilesource.BitmapTileSourceBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.TileSourceFactory;
import org.osmdroid.tileprovider.util.Counters;
import org.osmdroid.util.MapTileIndex;
import org.osmdroid.util.TileSystem;

public class MapTileFilesystemProvider
extends MapTileFileStorageProviderBase {
    private final TileWriter mWriter = new TileWriter();
    private final AtomicReference<ITileSource> mTileSource = new AtomicReference();

    public MapTileFilesystemProvider(IRegisterReceiver pRegisterReceiver) {
        this(pRegisterReceiver, TileSourceFactory.DEFAULT_TILE_SOURCE);
    }

    public MapTileFilesystemProvider(IRegisterReceiver pRegisterReceiver, ITileSource aTileSource) {
        this(pRegisterReceiver, aTileSource, Configuration.getInstance().getExpirationExtendedDuration() + 604800000L);
    }

    public MapTileFilesystemProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource, long pMaximumCachedFileAge) {
        this(pRegisterReceiver, pTileSource, pMaximumCachedFileAge, Configuration.getInstance().getTileFileSystemThreads(), Configuration.getInstance().getTileFileSystemMaxQueueSize());
    }

    public MapTileFilesystemProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource, long pMaximumCachedFileAge, int pThreadPoolSize, int pPendingQueueSize) {
        super(pRegisterReceiver, pThreadPoolSize, pPendingQueueSize);
        this.setTileSource(pTileSource);
        this.mWriter.setMaximumCachedFileAge(pMaximumCachedFileAge);
    }

    @Override
    public boolean getUsesDataConnection() {
        return false;
    }

    @Override
    protected String getName() {
        return "File System Cache Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "filesystem";
    }

    @Override
    public TileLoader getTileLoader() {
        return new TileLoader();
    }

    @Override
    public int getMinimumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMinimumZoomLevel() : 0;
    }

    @Override
    public int getMaximumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMaximumZoomLevel() : TileSystem.getMaximumZoomLevel();
    }

    @Override
    public void setTileSource(ITileSource pTileSource) {
        this.mTileSource.set(pTileSource);
    }

    protected class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        protected TileLoader() {
            super(MapTileFilesystemProvider.this);
        }

        @Override
        public Drawable loadTile(long pMapTileIndex) throws CantContinueException {
            ITileSource tileSource = (ITileSource)MapTileFilesystemProvider.this.mTileSource.get();
            if (tileSource == null) {
                return null;
            }
            try {
                Drawable result = MapTileFilesystemProvider.this.mWriter.loadTile(tileSource, pMapTileIndex);
                if (result == null) {
                    ++Counters.fileCacheMiss;
                } else {
                    ++Counters.fileCacheHit;
                }
                return result;
            }
            catch (BitmapTileSourceBase.LowMemoryException e) {
                Log.w((String)"OsmDroid", (String)("LowMemoryException downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                ++Counters.fileCacheOOM;
                throw new CantContinueException(e);
            }
            catch (Throwable e) {
                Log.e((String)"OsmDroid", (String)"Error loading tile", (Throwable)e);
                return null;
            }
        }
    }
}

