/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Paint;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.LinearRing;
import org.osmdroid.views.overlay.PolyOverlayWithIW;

public class Polygon
extends PolyOverlayWithIW {
    protected OnClickListener mOnClickListener;

    public Polygon() {
        this((MapView)null);
    }

    public Polygon(MapView mapView) {
        super(mapView, true, true);
        this.mFillPaint = new Paint();
        this.mFillPaint.setColor(0);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mOutlinePaint.setColor(-16777216);
        this.mOutlinePaint.setStrokeWidth(10.0f);
        this.mOutlinePaint.setStyle(Paint.Style.STROKE);
        this.mOutlinePaint.setAntiAlias(true);
    }

    @Deprecated
    public int getFillColor() {
        return this.mFillPaint.getColor();
    }

    @Deprecated
    public int getStrokeColor() {
        return this.mOutlinePaint.getColor();
    }

    @Deprecated
    public float getStrokeWidth() {
        return this.mOutlinePaint.getStrokeWidth();
    }

    @Override
    public Paint getFillPaint() {
        return super.getFillPaint();
    }

    @Deprecated
    public List<GeoPoint> getPoints() {
        return this.getActualPoints();
    }

    @Deprecated
    public void setFillColor(int fillColor) {
        this.mFillPaint.setColor(fillColor);
    }

    @Deprecated
    public void setStrokeColor(int color) {
        this.mOutlinePaint.setColor(color);
    }

    @Deprecated
    public void setStrokeWidth(float width) {
        this.mOutlinePaint.setStrokeWidth(width);
    }

    public void setHoles(List<? extends List<GeoPoint>> holes) {
        this.mHoles = new ArrayList(holes.size());
        for (List<GeoPoint> list : holes) {
            LinearRing newHole = new LinearRing(this.mPath);
            newHole.setGeodesic(this.mOutline.isGeodesic());
            newHole.setPoints(list);
            this.mHoles.add(newHole);
        }
    }

    public List<List<GeoPoint>> getHoles() {
        ArrayList<List<GeoPoint>> result = new ArrayList<List<GeoPoint>>(this.mHoles.size());
        for (LinearRing hole : this.mHoles) {
            result.add(hole.getPoints());
        }
        return result;
    }

    public static ArrayList<GeoPoint> pointsAsCircle(GeoPoint center, double radiusInMeters) {
        ArrayList<GeoPoint> circlePoints = new ArrayList<GeoPoint>(60);
        for (int f = 0; f < 360; f += 6) {
            GeoPoint onCircle = center.destinationPoint(radiusInMeters, f);
            circlePoints.add(onCircle);
        }
        return circlePoints;
    }

    public static ArrayList<IGeoPoint> pointsAsRect(BoundingBox rectangle) {
        ArrayList<IGeoPoint> points = new ArrayList<IGeoPoint>(4);
        points.add(new GeoPoint(rectangle.getLatNorth(), rectangle.getLonWest()));
        points.add(new GeoPoint(rectangle.getLatNorth(), rectangle.getLonEast()));
        points.add(new GeoPoint(rectangle.getLatSouth(), rectangle.getLonEast()));
        points.add(new GeoPoint(rectangle.getLatSouth(), rectangle.getLonWest()));
        return points;
    }

    public static ArrayList<IGeoPoint> pointsAsRect(GeoPoint center, double lengthInMeters, double widthInMeters) {
        ArrayList<IGeoPoint> points = new ArrayList<IGeoPoint>(4);
        GeoPoint east = center.destinationPoint(lengthInMeters * 0.5, 90.0);
        GeoPoint south = center.destinationPoint(widthInMeters * 0.5, 180.0);
        double westLon = center.getLongitude() * 2.0 - east.getLongitude();
        double northLat = center.getLatitude() * 2.0 - south.getLatitude();
        points.add(new GeoPoint(south.getLatitude(), east.getLongitude()));
        points.add(new GeoPoint(south.getLatitude(), westLon));
        points.add(new GeoPoint(northLat, westLon));
        points.add(new GeoPoint(northLat, east.getLongitude()));
        return points;
    }

    @Override
    public void onDetach(MapView mapView) {
        super.onDetach(mapView);
        this.mOnClickListener = null;
    }

    public boolean onClickDefault(Polygon polygon, MapView mapView, GeoPoint eventPos) {
        polygon.setInfoWindowLocation(eventPos);
        polygon.showInfoWindow();
        return true;
    }

    public void setOnClickListener(OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    @Override
    protected boolean click(MapView pMapView, GeoPoint pEventPos) {
        if (this.mOnClickListener == null) {
            return this.onClickDefault(this, pMapView, pEventPos);
        }
        return this.mOnClickListener.onClick(this, pMapView, pEventPos);
    }

    public static interface OnClickListener {
        public boolean onClick(Polygon var1, MapView var2, GeoPoint var3);
    }
}

