/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.Counters;
import org.osmdroid.tileprovider.util.StreamUtils;
import org.osmdroid.util.GarbageCollector;
import org.osmdroid.util.MapTileIndex;
import org.osmdroid.util.SplashScreenable;

public class SqlTileWriter
implements IFilesystemCache,
SplashScreenable {
    public static final String DATABASE_FILENAME = "cache.db";
    public static final String COLUMN_EXPIRES = "expires";
    public static final String COLUMN_EXPIRES_INDEX = "expires_index";
    private static boolean cleanOnStartup = true;
    private static final Object mLock = new Object();
    protected static File db_file;
    protected static SQLiteDatabase mDb;
    protected long lastSizeCheck = 0L;
    private final GarbageCollector garbageCollector = new GarbageCollector(new Runnable(){

        @Override
        public void run() {
            SqlTileWriter.this.runCleanupOperation();
        }
    });
    static boolean hasInited;
    private static final String primaryKey = "key=? and provider=?";
    private static final String[] queryColumns;
    private static final String[] expireQueryColumn;

    public static void setCleanupOnStart(boolean value) {
        cleanOnStartup = value;
    }

    public SqlTileWriter() {
        this.getDb();
        if (!hasInited) {
            hasInited = true;
            if (cleanOnStartup) {
                this.garbageCollector.gc();
            }
        }
    }

    public void runCleanupOperation() {
        SQLiteDatabase db = this.getDb();
        if (db == null || !db.isOpen()) {
            if (Configuration.getInstance().isDebugMode()) {
                Log.d((String)"OsmDroid", (String)"Finished init thread, aborted due to null database reference");
            }
            return;
        }
        this.createIndex(db);
        long dbLength = db_file.length();
        if (dbLength <= Configuration.getInstance().getTileFileSystemCacheMaxBytes()) {
            return;
        }
        this.runCleanupOperation(dbLength - Configuration.getInstance().getTileFileSystemCacheTrimBytes(), Configuration.getInstance().getTileGCBulkSize(), Configuration.getInstance().getTileGCBulkPauseInMillis(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveFile(ITileSource pTileSourceInfo, long pMapTileIndex, InputStream pStream, Long pExpirationTime) {
        SQLiteDatabase db = this.getDb();
        if (db == null || !db.isOpen()) {
            Log.d((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSourceInfo.name() + " " + MapTileIndex.toString(pMapTileIndex) + ", database not available."));
            ++Counters.fileCacheSaveErrors;
            return false;
        }
        ByteArrayOutputStream bos = null;
        try {
            int l;
            ContentValues cv = new ContentValues();
            long index = SqlTileWriter.getIndex(pMapTileIndex);
            cv.put("provider", pTileSourceInfo.name());
            byte[] buffer = new byte[512];
            bos = new ByteArrayOutputStream();
            while ((l = pStream.read(buffer)) != -1) {
                bos.write(buffer, 0, l);
            }
            byte[] bits = bos.toByteArray();
            cv.put("key", Long.valueOf(index));
            cv.put("tile", bits);
            if (pExpirationTime != null) {
                cv.put(COLUMN_EXPIRES, pExpirationTime);
            }
            db.replaceOrThrow("tiles", null, cv);
            if (Configuration.getInstance().isDebugMode()) {
                Log.d((String)"OsmDroid", (String)("tile inserted " + pTileSourceInfo.name() + MapTileIndex.toString(pMapTileIndex)));
            }
            if (System.currentTimeMillis() > this.lastSizeCheck + Configuration.getInstance().getTileGCFrequencyInMillis()) {
                this.lastSizeCheck = System.currentTimeMillis();
                this.garbageCollector.gc();
            }
        }
        catch (SQLiteFullException ex) {
            Log.e((String)"OsmDroid", (String)"SQLiteFullException while saving tile.", (Throwable)ex);
            this.garbageCollector.gc();
            this.catchException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSourceInfo.name() + " " + MapTileIndex.toString(pMapTileIndex) + " db is " + (db == null ? "null" : "not null")), (Throwable)ex);
            ++Counters.fileCacheSaveErrors;
            this.catchException(ex);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException ex) {}
        }
        return false;
    }

    public boolean exists(String pTileSource, long pMapTileIndex) {
        return 1L == this.getRowCount(primaryKey, SqlTileWriter.getPrimaryKeyParameters(SqlTileWriter.getIndex(pMapTileIndex), pTileSource));
    }

    @Override
    public boolean exists(ITileSource pTileSource, long pMapTileIndex) {
        return this.exists(pTileSource.name(), pMapTileIndex);
    }

    @Override
    public void onDetach() {
    }

    public boolean purgeCache() {
        SQLiteDatabase db = this.getDb();
        if (db != null && db.isOpen()) {
            try {
                db.delete("tiles", null, null);
                return true;
            }
            catch (Exception e) {
                Log.w((String)"OsmDroid", (String)"Error purging the db", (Throwable)e);
                this.catchException(e);
            }
        }
        return false;
    }

    public boolean purgeCache(String mTileSourceName) {
        SQLiteDatabase db = this.getDb();
        if (db != null && db.isOpen()) {
            try {
                db.delete("tiles", "provider = ?", new String[]{mTileSourceName});
                return true;
            }
            catch (Exception e) {
                Log.w((String)"OsmDroid", (String)"Error purging the db", (Throwable)e);
                this.catchException(e);
            }
        }
        return false;
    }

    public int[] importFromFileCache(boolean removeFromFileSystem) {
        File[] tileSources;
        SQLiteDatabase db = this.getDb();
        int[] ret = new int[]{0, 0, 0, 0};
        File tilePathBase = Configuration.getInstance().getOsmdroidTileCache();
        if (tilePathBase.exists() && (tileSources = tilePathBase.listFiles()) != null) {
            for (int i = 0; i < tileSources.length; ++i) {
                if (!tileSources[i].isDirectory() || tileSources[i].isHidden()) continue;
                File[] z = tileSources[i].listFiles();
                if (z != null) {
                    for (int zz = 0; zz < z.length; ++zz) {
                        File[] x;
                        if (z[zz].isDirectory() && !z[zz].isHidden() && (x = z[zz].listFiles()) != null) {
                            for (int xx = 0; xx < x.length; ++xx) {
                                if (x[xx].isDirectory() && !x[xx].isHidden()) {
                                    File[] y = x[xx].listFiles();
                                    if (x != null) {
                                        for (int yy = 0; yy < y.length; ++yy) {
                                            if (y[yy].isHidden() || y[yy].isDirectory()) continue;
                                            try {
                                                ContentValues cv = new ContentValues();
                                                long x1 = Long.parseLong(x[xx].getName());
                                                long y1 = Long.parseLong(y[yy].getName().substring(0, y[yy].getName().indexOf(".")));
                                                long z1 = Long.parseLong(z[zz].getName());
                                                long index = SqlTileWriter.getIndex(x1, y1, z1);
                                                cv.put("provider", tileSources[i].getName());
                                                if (this.exists(tileSources[i].getName(), MapTileIndex.getTileIndex((int)z1, (int)x1, (int)y1))) continue;
                                                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(y[yy]));
                                                ArrayList<Byte> list = new ArrayList<Byte>();
                                                int current = 0;
                                                while ((current = bis.read()) != -1) {
                                                    list.add((byte)current);
                                                }
                                                byte[] bits = new byte[list.size()];
                                                for (int bi = 0; bi < list.size(); ++bi) {
                                                    bits[bi] = (Byte)list.get(bi);
                                                }
                                                cv.put("key", Long.valueOf(index));
                                                cv.put("tile", bits);
                                                long insert = db.insert("tiles", null, cv);
                                                if (insert > 0L) {
                                                    if (Configuration.getInstance().isDebugMode()) {
                                                        Log.d((String)"OsmDroid", (String)("tile inserted " + tileSources[i].getName() + "/" + z1 + "/" + x1 + "/" + y1));
                                                    }
                                                    ret[0] = ret[0] + 1;
                                                    if (!removeFromFileSystem) continue;
                                                    try {
                                                        y[yy].delete();
                                                        ret[2] = ret[2] + 1;
                                                    }
                                                    catch (Exception ex) {
                                                        ret[3] = ret[3] + 1;
                                                    }
                                                    continue;
                                                }
                                                Log.w((String)"OsmDroid", (String)("tile NOT inserted " + tileSources[i].getName() + "/" + z1 + "/" + x1 + "/" + y1));
                                                continue;
                                            }
                                            catch (Exception ex) {
                                                Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + tileSources[i].getName() + " db is " + (db == null ? "null" : "not null")), (Throwable)ex);
                                                ret[1] = ret[1] + 1;
                                                this.catchException(ex);
                                            }
                                        }
                                    }
                                }
                                if (!removeFromFileSystem) continue;
                                try {
                                    x[xx].delete();
                                    continue;
                                }
                                catch (Exception ex) {
                                    Log.e((String)"OsmDroid", (String)("Unable to delete directory from " + x[xx].getAbsolutePath()), (Throwable)ex);
                                    ret[3] = ret[3] + 1;
                                }
                            }
                        }
                        if (!removeFromFileSystem) continue;
                        try {
                            z[zz].delete();
                            continue;
                        }
                        catch (Exception ex) {
                            Log.e((String)"OsmDroid", (String)("Unable to delete directory from " + z[zz].getAbsolutePath()), (Throwable)ex);
                            ret[3] = ret[3] + 1;
                        }
                    }
                }
                if (!removeFromFileSystem) continue;
                try {
                    tileSources[i].delete();
                    continue;
                }
                catch (Exception ex) {
                    Log.e((String)"OsmDroid", (String)("Unable to delete directory from " + tileSources[i].getAbsolutePath()), (Throwable)ex);
                    ret[3] = ret[3] + 1;
                }
            }
        }
        return ret;
    }

    @Override
    public boolean remove(ITileSource pTileSourceInfo, long pMapTileIndex) {
        SQLiteDatabase db = this.getDb();
        if (db == null || !db.isOpen()) {
            Log.d((String)"OsmDroid", (String)("Unable to delete cached tile from " + pTileSourceInfo.name() + " " + MapTileIndex.toString(pMapTileIndex) + ", database not available."));
            ++Counters.fileCacheSaveErrors;
            return false;
        }
        try {
            long index = SqlTileWriter.getIndex(pMapTileIndex);
            db.delete("tiles", primaryKey, SqlTileWriter.getPrimaryKeyParameters(index, pTileSourceInfo));
            return true;
        }
        catch (Exception ex) {
            Log.e((String)"OsmDroid", (String)("Unable to delete cached tile from " + pTileSourceInfo.name() + " " + MapTileIndex.toString(pMapTileIndex) + " db is " + (db == null ? "null" : "not null")), (Throwable)ex);
            ++Counters.fileCacheSaveErrors;
            this.catchException(ex);
            return false;
        }
    }

    public long getRowCount(String tileSourceName) {
        if (tileSourceName == null) {
            return this.getRowCount(null, null);
        }
        return this.getRowCount("provider=?", new String[]{tileSourceName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getRowCount(String pWhereClause, String[] pWhereClauseArgs) {
        try (Cursor cursor = null;){
            SQLiteDatabase db = this.getDb();
            if (db == null || !db.isOpen()) {
                long l = -1L;
                return l;
            }
            cursor = db.rawQuery("select count(*) from tiles" + (pWhereClause == null ? "" : " where " + pWhereClause), pWhereClauseArgs);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
        }
        return -1L;
    }

    public long getRowCount(String pTileSourceName, int pZoom, Collection<Rect> pInclude, Collection<Rect> pExclude) {
        String[] stringArray;
        String string2 = this.getWhereClause(pZoom, pInclude, pExclude) + (pTileSourceName != null ? " and provider=?" : "");
        if (pTileSourceName != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = pTileSourceName;
        } else {
            stringArray = null;
        }
        return this.getRowCount(string2, stringArray);
    }

    public long getSize() {
        return db_file.length();
    }

    public long getFirstExpiry() {
        SQLiteDatabase db = this.getDb();
        if (db == null || !db.isOpen()) {
            return 0L;
        }
        try {
            Cursor cursor = db.rawQuery("select min(expires) from tiles", null);
            cursor.moveToFirst();
            long time = cursor.getLong(0);
            cursor.close();
            return time;
        }
        catch (Exception ex) {
            Log.e((String)"OsmDroid", (String)"Unable to query for oldest tile", (Throwable)ex);
            this.catchException(ex);
            return 0L;
        }
    }

    public static long getIndex(long pX, long pY, long pZ) {
        return ((pZ << (int)pZ) + pX << (int)pZ) + pY;
    }

    protected static String extractXFromKeyInSQL(int pZoom) {
        return "((key>>" + pZoom + ")%" + (1 << pZoom) + ")";
    }

    protected static String extractYFromKeyInSQL(int pZoom) {
        return "(key%" + (1 << pZoom) + ")";
    }

    public static long getIndex(long pMapTileIndex) {
        return SqlTileWriter.getIndex(MapTileIndex.getX(pMapTileIndex), MapTileIndex.getY(pMapTileIndex), MapTileIndex.getZoom(pMapTileIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getExpirationTimestamp(ITileSource pTileSource, long pMapTileIndex) {
        try (Cursor cursor = null;){
            cursor = this.getTileCursor(SqlTileWriter.getPrimaryKeyParameters(SqlTileWriter.getIndex(pMapTileIndex), pTileSource), expireQueryColumn);
            if (cursor.moveToNext()) {
                Long l = cursor.getLong(0);
                return l;
            }
        }
        return null;
    }

    public static String getPrimaryKey() {
        return primaryKey;
    }

    public static String[] getPrimaryKeyParameters(long pIndex, ITileSource pTileSourceInfo) {
        return SqlTileWriter.getPrimaryKeyParameters(pIndex, pTileSourceInfo.name());
    }

    public static String[] getPrimaryKeyParameters(long pIndex, String pTileSourceInfo) {
        return new String[]{String.valueOf(pIndex), pTileSourceInfo};
    }

    public Cursor getTileCursor(String[] pPrimaryKeyParameters, String[] pColumns) {
        SQLiteDatabase db = this.getDb();
        return db.query("tiles", pColumns, primaryKey, pPrimaryKeyParameters, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Drawable loadTile(ITileSource pTileSource, long pMapTileIndex) throws Exception {
        byte[] bits = null;
        long expirationTimestamp = 0L;
        try (Cursor cur = null;){
            long index = SqlTileWriter.getIndex(pMapTileIndex);
            cur = this.getTileCursor(SqlTileWriter.getPrimaryKeyParameters(index, pTileSource), queryColumns);
            if (cur.moveToFirst()) {
                bits = cur.getBlob(0);
                expirationTimestamp = cur.getLong(1);
            }
            if (bits == null) {
                if (Configuration.getInstance().isDebugMode()) {
                    Log.d((String)"OsmDroid", (String)("SqlCache - Tile doesn't exist: " + pTileSource.name() + MapTileIndex.toString(pMapTileIndex)));
                }
                Drawable drawable = null;
                return drawable;
            }
        }
        ByteArrayInputStream inputStream = null;
        try {
            boolean fileExpired;
            inputStream = new ByteArrayInputStream(bits);
            Drawable drawable = pTileSource.getDrawable(inputStream);
            long now = System.currentTimeMillis();
            boolean bl = fileExpired = expirationTimestamp < now;
            if (fileExpired && drawable != null) {
                if (Configuration.getInstance().isDebugMode()) {
                    Log.d((String)"OsmDroid", (String)("Tile expired: " + pTileSource.name() + MapTileIndex.toString(pMapTileIndex)));
                }
                ExpirableBitmapDrawable.setState(drawable, -2);
            }
            Drawable drawable2 = drawable;
            return drawable2;
        }
        finally {
            if (inputStream != null) {
                StreamUtils.closeStream(inputStream);
            }
        }
    }

    public void runCleanupOperation(long pToBeDeleted, int pBulkSize, long pPauseMillis, boolean pIncludeUnexpired) {
        long diff = pToBeDeleted;
        StringBuilder where = new StringBuilder();
        boolean first = true;
        SQLiteDatabase db = this.getDb();
        while (diff > 0L) {
            Cursor cur;
            if (first) {
                first = false;
            } else if (pPauseMillis > 0L) {
                try {
                    Thread.sleep(pPauseMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            long now = System.currentTimeMillis();
            try {
                cur = db.rawQuery("SELECT key,LENGTH(HEX(tile))/2 FROM tiles WHERE expires IS NOT NULL " + (pIncludeUnexpired ? "" : "AND expires < " + now + " ") + "ORDER BY " + COLUMN_EXPIRES + " ASC LIMIT " + pBulkSize, null);
            }
            catch (Exception e) {
                this.catchException(e);
                return;
            }
            cur.moveToFirst();
            where.setLength(0);
            where.append("key in (");
            String sep = "";
            while (!cur.isAfterLast()) {
                long key = cur.getLong(0);
                long size = cur.getLong(1);
                cur.moveToNext();
                where.append(sep).append(key);
                sep = ",";
                if ((diff -= size) > 0L) continue;
                break;
            }
            cur.close();
            if ("".equals(sep)) {
                return;
            }
            where.append(')');
            try {
                db.delete("tiles", where.toString(), null);
            }
            catch (SQLiteFullException e) {
                Log.e((String)"OsmDroid", (String)"SQLiteFullException while cleanup.", (Throwable)e);
                this.catchException((Exception)((Object)e));
            }
            catch (Exception e) {
                this.catchException(e);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SQLiteDatabase getDb() {
        if (mDb != null) {
            return mDb;
        }
        Object object = mLock;
        synchronized (object) {
            Configuration.getInstance().getOsmdroidTileCache().mkdirs();
            db_file = new File(Configuration.getInstance().getOsmdroidTileCache().getAbsolutePath() + File.separator + DATABASE_FILENAME);
            if (mDb == null) {
                try {
                    mDb = SQLiteDatabase.openOrCreateDatabase((File)db_file, null);
                    mDb.execSQL("CREATE TABLE IF NOT EXISTS tiles (key INTEGER , provider TEXT, tile BLOB, expires INTEGER, PRIMARY KEY (key, provider));");
                }
                catch (Exception ex) {
                    Log.e((String)"OsmDroid", (String)"Unable to start the sqlite tile writer. Check external storage availability.", (Throwable)ex);
                    this.catchException(ex);
                    return null;
                }
            }
        }
        return mDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDb() {
        Object object = mLock;
        synchronized (object) {
            if (mDb != null) {
                mDb.close();
                mDb = null;
            }
        }
    }

    protected void catchException(Exception pException) {
        if (pException instanceof SQLiteException && !SqlTileWriter.isFunctionalException((SQLiteException)pException)) {
            this.refreshDb();
        }
    }

    public static boolean isFunctionalException(SQLiteException pSQLiteException) {
        switch (pSQLiteException.getClass().getSimpleName()) {
            case "SQLiteBindOrColumnIndexOutOfRangeException": 
            case "SQLiteBlobTooBigException": 
            case "SQLiteConstraintException": 
            case "SQLiteDatatypeMismatchException": 
            case "SQLiteFullException": 
            case "SQLiteMisuseException": 
            case "SQLiteTableLockedException": {
                return true;
            }
            case "SQLiteAbortException": 
            case "SQLiteAccessPermException": 
            case "SQLiteCantOpenDatabaseException": 
            case "SQLiteDatabaseCorruptException": 
            case "SQLiteDatabaseLockedException": 
            case "SQLiteDiskIOException": 
            case "SQLiteDoneException": 
            case "SQLiteOutOfMemoryException": 
            case "SQLiteReadOnlyDatabaseException": {
                return false;
            }
        }
        return false;
    }

    private void createIndex(SQLiteDatabase pDb) {
        pDb.execSQL("CREATE INDEX IF NOT EXISTS expires_index ON tiles (expires);");
    }

    @Override
    public void runDuringSplashScreen() {
        SQLiteDatabase db = this.getDb();
        this.createIndex(db);
    }

    protected StringBuilder getWhereClause(int pZoom, Rect pRect) {
        long maxValueForZoom = -1 + (1 << pZoom + 1);
        long firstIndexForZoom = SqlTileWriter.getIndex(0L, 0L, pZoom);
        long lastIndexForZoom = SqlTileWriter.getIndex(maxValueForZoom, maxValueForZoom, pZoom);
        String xForZoom = SqlTileWriter.extractXFromKeyInSQL(pZoom);
        String yForZoom = SqlTileWriter.extractYFromKeyInSQL(pZoom);
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        buffer.append("key").append(" between ").append(firstIndexForZoom).append(" and ").append(lastIndexForZoom);
        if (pRect != null) {
            buffer.append(" and ");
            if (pRect.left == pRect.right) {
                buffer.append(xForZoom).append("=").append(pRect.left);
            } else {
                buffer.append("(").append(xForZoom).append(">=").append(pRect.left).append(pRect.left < pRect.right ? " and " : " or ").append(xForZoom).append("<=").append(pRect.right).append(")");
            }
            buffer.append(" and ");
            if (pRect.top == pRect.bottom) {
                buffer.append(yForZoom).append("=").append(pRect.top);
            } else {
                buffer.append("(").append(yForZoom).append(">=").append(pRect.top).append(pRect.top < pRect.bottom ? " and " : " or ").append(yForZoom).append("<=").append(pRect.bottom).append(")");
            }
        }
        buffer.append(')');
        return buffer;
    }

    protected StringBuilder getWhereClause(int pZoom, Collection<Rect> pInclude, Collection<Rect> pExclude) {
        String coordinator;
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        buffer.append((CharSequence)this.getWhereClause(pZoom, null));
        if (pInclude != null && pInclude.size() > 0) {
            buffer.append(" and (");
            coordinator = "";
            for (Rect rect : pInclude) {
                buffer.append(coordinator).append('(').append((CharSequence)this.getWhereClause(pZoom, rect)).append(')');
                coordinator = " or ";
            }
            buffer.append(")");
        }
        if (pExclude != null && pExclude.size() > 0) {
            buffer.append(" and not(");
            coordinator = "";
            for (Rect rect : pExclude) {
                buffer.append(coordinator).append('(').append((CharSequence)this.getWhereClause(pZoom, rect)).append(')');
                coordinator = " or ";
            }
            buffer.append(")");
        }
        buffer.append(')');
        return buffer;
    }

    public long delete(String pTileSourceName, int pZoom, Collection<Rect> pInclude, Collection<Rect> pExclude) {
        try {
            String[] stringArray;
            SQLiteDatabase db = this.getDb();
            if (db == null || !db.isOpen()) {
                return -1L;
            }
            String string2 = this.getWhereClause(pZoom, pInclude, pExclude) + (pTileSourceName != null ? " and provider=?" : "");
            if (pTileSourceName != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = pTileSourceName;
            } else {
                stringArray = null;
            }
            return db.delete("tiles", string2, stringArray);
        }
        catch (Exception ex) {
            this.catchException(ex);
            return 0L;
        }
    }

    static {
        hasInited = false;
        queryColumns = new String[]{"tile", COLUMN_EXPIRES};
        expireQueryColumn = new String[]{COLUMN_EXPIRES};
    }
}

