/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import java.util.List;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.config.Configuration;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.MyMath;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;

public class BoundingBox
implements Parcelable,
Serializable {
    static final long serialVersionUID = 2L;
    private double mLatNorth;
    private double mLatSouth;
    private double mLonEast;
    private double mLonWest;
    public static final Parcelable.Creator<BoundingBox> CREATOR = new Parcelable.Creator<BoundingBox>(){

        public BoundingBox createFromParcel(Parcel in) {
            return BoundingBox.readFromParcel(in);
        }

        public BoundingBox[] newArray(int size) {
            return new BoundingBox[size];
        }
    };

    public BoundingBox(double north, double east, double south, double west) {
        this.set(north, east, south, west);
    }

    public BoundingBox() {
    }

    public void set(double north, double east, double south, double west) {
        this.mLatNorth = north;
        this.mLonEast = east;
        this.mLatSouth = south;
        this.mLonWest = west;
        if (Configuration.getInstance().isEnforceTileSystemBounds()) {
            TileSystem tileSystem = MapView.getTileSystem();
            if (!tileSystem.isValidLatitude(north)) {
                throw new IllegalArgumentException("north must be in " + tileSystem.toStringLatitudeSpan());
            }
            if (!tileSystem.isValidLatitude(south)) {
                throw new IllegalArgumentException("south must be in " + tileSystem.toStringLatitudeSpan());
            }
            if (!tileSystem.isValidLongitude(west)) {
                throw new IllegalArgumentException("west must be in " + tileSystem.toStringLongitudeSpan());
            }
            if (!tileSystem.isValidLongitude(east)) {
                throw new IllegalArgumentException("east must be in " + tileSystem.toStringLongitudeSpan());
            }
        }
    }

    public BoundingBox clone() {
        return new BoundingBox(this.mLatNorth, this.mLonEast, this.mLatSouth, this.mLonWest);
    }

    public BoundingBox concat(BoundingBox bb2) {
        return new BoundingBox(Math.max(this.mLatNorth, bb2.getLatNorth()), Math.max(this.mLonEast, bb2.getLonEast()), Math.min(this.mLatSouth, bb2.getLatSouth()), Math.min(this.mLonWest, bb2.getLonWest()));
    }

    @Deprecated
    public GeoPoint getCenter() {
        return new GeoPoint((this.mLatNorth + this.mLatSouth) / 2.0, (this.mLonEast + this.mLonWest) / 2.0);
    }

    public GeoPoint getCenterWithDateLine() {
        return new GeoPoint(this.getCenterLatitude(), this.getCenterLongitude());
    }

    public double getDiagonalLengthInMeters() {
        return new GeoPoint(this.mLatNorth, this.mLonWest).distanceToAsDouble(new GeoPoint(this.mLatSouth, this.mLonEast));
    }

    public double getLatNorth() {
        return this.mLatNorth;
    }

    public double getLatSouth() {
        return this.mLatSouth;
    }

    public double getCenterLatitude() {
        return (this.mLatNorth + this.mLatSouth) / 2.0;
    }

    public double getCenterLongitude() {
        return BoundingBox.getCenterLongitude(this.mLonWest, this.mLonEast);
    }

    public static double getCenterLongitude(double pWest, double pEast) {
        double longitude = (pEast + pWest) / 2.0;
        if (pEast < pWest) {
            longitude += 180.0;
        }
        return MapView.getTileSystem().cleanLongitude(longitude);
    }

    public double getActualNorth() {
        return Math.max(this.mLatNorth, this.mLatSouth);
    }

    public double getActualSouth() {
        return Math.min(this.mLatNorth, this.mLatSouth);
    }

    public double getLonEast() {
        return this.mLonEast;
    }

    public double getLonWest() {
        return this.mLonWest;
    }

    public double getLatitudeSpan() {
        return Math.abs(this.mLatNorth - this.mLatSouth);
    }

    @Deprecated
    public double getLongitudeSpan() {
        return Math.abs(this.mLonEast - this.mLonWest);
    }

    public void setLatNorth(double mLatNorth) {
        this.mLatNorth = mLatNorth;
    }

    public void setLatSouth(double mLatSouth) {
        this.mLatSouth = mLatSouth;
    }

    public void setLonEast(double mLonEast) {
        this.mLonEast = mLonEast;
    }

    public void setLonWest(double mLonWest) {
        this.mLonWest = mLonWest;
    }

    public double getLongitudeSpanWithDateLine() {
        if (this.mLonEast > this.mLonWest) {
            return this.mLonEast - this.mLonWest;
        }
        return this.mLonEast - this.mLonWest + 360.0;
    }

    public PointF getRelativePositionOfGeoPointInBoundingBoxWithLinearInterpolation(double aLatitude, double aLongitude, PointF reuse) {
        PointF out = reuse != null ? reuse : new PointF();
        float y = (float)((this.mLatNorth - aLatitude) / this.getLatitudeSpan());
        float x = 1.0f - (float)((this.mLonEast - aLongitude) / this.getLongitudeSpan());
        out.set(x, y);
        return out;
    }

    public PointF getRelativePositionOfGeoPointInBoundingBoxWithExactGudermannInterpolation(double aLatitude, double aLongitude, PointF reuse) {
        PointF out = reuse != null ? reuse : new PointF();
        float y = (float)((MyMath.gudermannInverse(this.mLatNorth) - MyMath.gudermannInverse(aLatitude)) / (MyMath.gudermannInverse(this.mLatNorth) - MyMath.gudermannInverse(this.mLatSouth)));
        float x = 1.0f - (float)((this.mLonEast - aLongitude) / this.getLongitudeSpan());
        out.set(x, y);
        return out;
    }

    public GeoPoint getGeoPointOfRelativePositionWithLinearInterpolation(float relX, float relY) {
        TileSystem tileSystem = MapView.getTileSystem();
        double lat = this.mLatNorth - this.getLatitudeSpan() * (double)relY;
        double lon = this.mLonWest + this.getLongitudeSpan() * (double)relX;
        return new GeoPoint(tileSystem.cleanLatitude(lat), tileSystem.cleanLongitude(lon));
    }

    public GeoPoint getGeoPointOfRelativePositionWithExactGudermannInterpolation(float relX, float relY) {
        TileSystem tileSystem = MapView.getTileSystem();
        double gudNorth = MyMath.gudermannInverse(this.mLatNorth);
        double gudSouth = MyMath.gudermannInverse(this.mLatSouth);
        double lat = MyMath.gudermann(gudSouth + (double)(1.0f - relY) * (gudNorth - gudSouth));
        double lon = this.mLonWest + this.getLongitudeSpan() * (double)relX;
        return new GeoPoint(tileSystem.cleanLatitude(lat), tileSystem.cleanLongitude(lon));
    }

    public BoundingBox increaseByScale(float pBoundingboxPaddingRelativeScale) {
        if (pBoundingboxPaddingRelativeScale <= 0.0f) {
            throw new IllegalArgumentException("pBoundingboxPaddingRelativeScale must be positive");
        }
        TileSystem tileSystem = MapView.getTileSystem();
        double latCenter = this.getCenterLatitude();
        double latSpanHalf = this.getLatitudeSpan() / 2.0 * (double)pBoundingboxPaddingRelativeScale;
        double latNorth = tileSystem.cleanLatitude(latCenter + latSpanHalf);
        double latSouth = tileSystem.cleanLatitude(latCenter - latSpanHalf);
        double lonCenter = this.getCenterLongitude();
        double lonSpanHalf = this.getLongitudeSpanWithDateLine() / 2.0 * (double)pBoundingboxPaddingRelativeScale;
        double latEast = tileSystem.cleanLongitude(lonCenter + lonSpanHalf);
        double latWest = tileSystem.cleanLongitude(lonCenter - lonSpanHalf);
        return new BoundingBox(latNorth, latEast, latSouth, latWest);
    }

    public String toString() {
        return new StringBuffer().append("N:").append(this.mLatNorth).append("; E:").append(this.mLonEast).append("; S:").append(this.mLatSouth).append("; W:").append(this.mLonWest).toString();
    }

    public GeoPoint bringToBoundingBox(double aLatitude, double aLongitude) {
        return new GeoPoint(Math.max(this.mLatSouth, Math.min(this.mLatNorth, aLatitude)), Math.max(this.mLonWest, Math.min(this.mLonEast, aLongitude)));
    }

    public static BoundingBox fromGeoPoints(List<? extends IGeoPoint> partialPolyLine) {
        double minLat = Double.MAX_VALUE;
        double minLon = Double.MAX_VALUE;
        double maxLat = -1.7976931348623157E308;
        double maxLon = -1.7976931348623157E308;
        for (IGeoPoint iGeoPoint : partialPolyLine) {
            double latitude = iGeoPoint.getLatitude();
            double longitude = iGeoPoint.getLongitude();
            minLat = Math.min(minLat, latitude);
            minLon = Math.min(minLon, longitude);
            maxLat = Math.max(maxLat, latitude);
            maxLon = Math.max(maxLon, longitude);
        }
        return new BoundingBox(maxLat, maxLon, minLat, minLon);
    }

    public boolean contains(IGeoPoint pGeoPoint) {
        return this.contains(pGeoPoint.getLatitude(), pGeoPoint.getLongitude());
    }

    public boolean contains(double aLatitude, double aLongitude) {
        boolean latMatch = false;
        boolean lonMatch = false;
        if (this.mLatNorth < this.mLatSouth) {
            latMatch = true;
        } else {
            boolean bl = latMatch = aLatitude < this.mLatNorth && aLatitude > this.mLatSouth;
        }
        lonMatch = this.mLonEast < this.mLonWest ? aLongitude <= this.mLonEast && aLongitude >= this.mLonWest : aLongitude < this.mLonEast && aLongitude > this.mLonWest;
        return latMatch && lonMatch;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int arg1) {
        out.writeDouble(this.mLatNorth);
        out.writeDouble(this.mLonEast);
        out.writeDouble(this.mLatSouth);
        out.writeDouble(this.mLonWest);
    }

    private static BoundingBox readFromParcel(Parcel in) {
        double latNorth = in.readDouble();
        double lonEast = in.readDouble();
        double latSouth = in.readDouble();
        double lonWest = in.readDouble();
        return new BoundingBox(latNorth, lonEast, latSouth, lonWest);
    }

    @Deprecated
    public int getLatitudeSpanE6() {
        return (int)(this.getLatitudeSpan() * 1000000.0);
    }

    @Deprecated
    public int getLongitudeSpanE6() {
        return (int)(this.getLongitudeSpan() * 1000000.0);
    }

    public boolean overlaps(BoundingBox pBoundingBox, double pZoom) {
        if (pZoom < 3.0) {
            return true;
        }
        boolean latMatch = false;
        boolean lonMatch = false;
        if (pBoundingBox.mLatSouth <= this.mLatNorth && pBoundingBox.mLatSouth >= this.mLatSouth) {
            latMatch = true;
        }
        if (this.mLonWest >= pBoundingBox.mLonWest && this.mLonWest <= pBoundingBox.mLonEast) {
            lonMatch = true;
        }
        if (this.mLonEast >= pBoundingBox.mLonWest && this.mLonWest <= pBoundingBox.mLonEast) {
            lonMatch = true;
        }
        if (this.mLonWest <= pBoundingBox.mLonWest && this.mLonEast >= pBoundingBox.mLonEast && this.mLatNorth >= pBoundingBox.mLatNorth && this.mLatSouth <= pBoundingBox.mLatSouth) {
            return true;
        }
        if (this.mLatNorth >= pBoundingBox.mLatSouth && this.mLatNorth <= this.mLatSouth) {
            latMatch = true;
        }
        if (this.mLatSouth >= pBoundingBox.mLatSouth && this.mLatSouth <= this.mLatSouth) {
            latMatch = true;
        }
        if (this.mLonWest > this.mLonEast) {
            if (this.mLonEast <= pBoundingBox.mLonEast && pBoundingBox.mLonWest >= this.mLonWest) {
                lonMatch = true;
            }
            if (this.mLonWest >= pBoundingBox.mLonEast && this.mLonEast <= pBoundingBox.mLonEast) {
                lonMatch = true;
                if (pBoundingBox.mLonEast < this.mLonWest && pBoundingBox.mLonWest < this.mLonWest) {
                    lonMatch = false;
                }
                if (pBoundingBox.mLonEast > this.mLonEast && pBoundingBox.mLonWest > this.mLonEast) {
                    lonMatch = false;
                }
            }
            if (this.mLonWest >= pBoundingBox.mLonEast && this.mLonEast >= pBoundingBox.mLonEast) {
                lonMatch = true;
            }
        }
        return latMatch && lonMatch;
    }

    public static BoundingBox fromGeoPointsSafe(List<GeoPoint> points) {
        try {
            return BoundingBox.fromGeoPoints(points);
        }
        catch (IllegalArgumentException e) {
            TileSystem tileSystem = MapView.getTileSystem();
            return new BoundingBox(tileSystem.getMaxLatitude(), tileSystem.getMaxLongitude(), tileSystem.getMinLatitude(), tileSystem.getMinLongitude());
        }
    }
}

