/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.mylocation;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.drawable.BitmapDrawable;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import java.util.LinkedList;
import org.osmdroid.api.IMapController;
import org.osmdroid.api.IMapView;
import org.osmdroid.config.Configuration;
import org.osmdroid.library.R;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.IOverlayMenuProvider;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.mylocation.GpsMyLocationProvider;
import org.osmdroid.views.overlay.mylocation.IMyLocationConsumer;
import org.osmdroid.views.overlay.mylocation.IMyLocationProvider;

public class MyLocationNewOverlay
extends Overlay
implements IMyLocationConsumer,
IOverlayMenuProvider,
Overlay.Snappable {
    protected Paint mPaint = new Paint();
    protected Paint mCirclePaint = new Paint();
    protected Bitmap mPersonBitmap;
    protected Bitmap mDirectionArrowBitmap;
    protected MapView mMapView;
    private IMapController mMapController;
    public IMyLocationProvider mMyLocationProvider;
    private final LinkedList<Runnable> mRunOnFirstFix = new LinkedList();
    private final Point mDrawPixel = new Point();
    private final Point mSnapPixel = new Point();
    private Handler mHandler;
    private Object mHandlerToken = new Object();
    protected boolean enableAutoStop = true;
    private Location mLocation;
    private final GeoPoint mGeoPoint = new GeoPoint(0, 0);
    private boolean mIsLocationEnabled = false;
    protected boolean mIsFollowing = false;
    protected boolean mDrawAccuracyEnabled = true;
    protected final PointF mPersonHotspot;
    protected float mDirectionArrowCenterX;
    protected float mDirectionArrowCenterY;
    public static final int MENU_MY_LOCATION = MyLocationNewOverlay.getSafeMenuId();
    private boolean mOptionsMenuEnabled = true;
    private boolean wasEnabledOnPause = false;

    public MyLocationNewOverlay(MapView mapView) {
        this(new GpsMyLocationProvider(mapView.getContext()), mapView);
    }

    public MyLocationNewOverlay(IMyLocationProvider myLocationProvider, MapView mapView) {
        this.mMapView = mapView;
        this.mMapController = mapView.getController();
        this.mCirclePaint.setARGB(0, 100, 100, 255);
        this.mCirclePaint.setAntiAlias(true);
        this.mPaint.setFilterBitmap(true);
        this.setPersonIcon(((BitmapDrawable)mapView.getContext().getResources().getDrawable(R.drawable.person)).getBitmap());
        this.setDirectionIcon(((BitmapDrawable)mapView.getContext().getResources().getDrawable(R.drawable.round_navigation_white_48)).getBitmap());
        this.mPersonHotspot = new PointF();
        this.setPersonAnchor(0.5f, 0.8125f);
        this.setDirectionAnchor(0.5f, 0.5f);
        this.mHandler = new Handler(Looper.getMainLooper());
        this.setMyLocationProvider(myLocationProvider);
    }

    @Deprecated
    public void setDirectionArrow(Bitmap personBitmap, Bitmap directionArrowBitmap) {
        this.setPersonIcon(personBitmap);
        this.setDirectionIcon(directionArrowBitmap);
        this.setDirectionAnchor(0.5f, 0.5f);
    }

    public void setDirectionIcon(Bitmap pDirectionArrowBitmap) {
        this.mDirectionArrowBitmap = pDirectionArrowBitmap;
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.wasEnabledOnPause) {
            this.enableFollowLocation();
        }
        this.enableMyLocation();
    }

    @Override
    public void onPause() {
        this.wasEnabledOnPause = this.mIsFollowing;
        this.disableMyLocation();
        super.onPause();
    }

    @Override
    public void onDetach(MapView mapView) {
        this.disableMyLocation();
        this.mMapView = null;
        this.mMapController = null;
        this.mHandler = null;
        this.mCirclePaint = null;
        this.mHandlerToken = null;
        this.mLocation = null;
        this.mMapController = null;
        if (this.mMyLocationProvider != null) {
            this.mMyLocationProvider.destroy();
        }
        this.mMyLocationProvider = null;
        super.onDetach(mapView);
    }

    public void setDrawAccuracyEnabled(boolean drawAccuracyEnabled) {
        this.mDrawAccuracyEnabled = drawAccuracyEnabled;
    }

    public boolean isDrawAccuracyEnabled() {
        return this.mDrawAccuracyEnabled;
    }

    public IMyLocationProvider getMyLocationProvider() {
        return this.mMyLocationProvider;
    }

    protected void setMyLocationProvider(IMyLocationProvider myLocationProvider) {
        if (myLocationProvider == null) {
            throw new RuntimeException("You must pass an IMyLocationProvider to setMyLocationProvider()");
        }
        if (this.isMyLocationEnabled()) {
            this.stopLocationProvider();
        }
        this.mMyLocationProvider = myLocationProvider;
    }

    @Deprecated
    public void setPersonHotspot(float x, float y) {
        this.mPersonHotspot.set(x, y);
    }

    protected void drawMyLocation(Canvas canvas, Projection pj, Location lastFix) {
        pj.toPixels(this.mGeoPoint, this.mDrawPixel);
        if (this.mDrawAccuracyEnabled) {
            float radius = lastFix.getAccuracy() / (float)TileSystem.GroundResolution(lastFix.getLatitude(), pj.getZoomLevel());
            this.mCirclePaint.setAlpha(50);
            this.mCirclePaint.setStyle(Paint.Style.FILL);
            canvas.drawCircle((float)this.mDrawPixel.x, (float)this.mDrawPixel.y, radius, this.mCirclePaint);
            this.mCirclePaint.setAlpha(150);
            this.mCirclePaint.setStyle(Paint.Style.STROKE);
            canvas.drawCircle((float)this.mDrawPixel.x, (float)this.mDrawPixel.y, radius, this.mCirclePaint);
        }
        if (lastFix.hasBearing()) {
            canvas.save();
            float mapRotation = lastFix.getBearing();
            if (mapRotation >= 360.0f) {
                mapRotation -= 360.0f;
            }
            canvas.rotate(mapRotation, (float)this.mDrawPixel.x, (float)this.mDrawPixel.y);
            canvas.drawBitmap(this.mDirectionArrowBitmap, (float)this.mDrawPixel.x - this.mDirectionArrowCenterX, (float)this.mDrawPixel.y - this.mDirectionArrowCenterY, this.mPaint);
            canvas.restore();
        } else {
            canvas.save();
            canvas.rotate(-this.mMapView.getMapOrientation(), (float)this.mDrawPixel.x, (float)this.mDrawPixel.y);
            canvas.drawBitmap(this.mPersonBitmap, (float)this.mDrawPixel.x - this.mPersonHotspot.x, (float)this.mDrawPixel.y - this.mPersonHotspot.y, this.mPaint);
            canvas.restore();
        }
    }

    @Override
    public void draw(Canvas c, Projection pProjection) {
        if (this.mLocation != null && this.isMyLocationEnabled()) {
            this.drawMyLocation(c, pProjection, this.mLocation);
        }
    }

    @Override
    public boolean onSnapToItem(int x, int y, Point snapPoint, IMapView mapView) {
        if (this.mLocation != null) {
            boolean snap;
            Projection pj = this.mMapView.getProjection();
            pj.toPixels(this.mGeoPoint, this.mSnapPixel);
            snapPoint.x = this.mSnapPixel.x;
            snapPoint.y = this.mSnapPixel.y;
            double xDiff = x - this.mSnapPixel.x;
            double yDiff = y - this.mSnapPixel.y;
            boolean bl = snap = xDiff * xDiff + yDiff * yDiff < 64.0;
            if (Configuration.getInstance().isDebugMode()) {
                Log.d((String)"OsmDroid", (String)("snap=" + snap));
            }
            return snap;
        }
        return false;
    }

    public void setEnableAutoStop(boolean value) {
        this.enableAutoStop = value;
    }

    public boolean getEnableAutoStop() {
        return this.enableAutoStop;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        boolean isSingleFingerDrag;
        boolean bl = isSingleFingerDrag = event.getAction() == 2 && event.getPointerCount() == 1;
        if (event.getAction() == 0 && this.enableAutoStop) {
            this.disableFollowLocation();
        } else if (isSingleFingerDrag && this.isFollowLocationEnabled()) {
            return true;
        }
        return super.onTouchEvent(event, mapView);
    }

    @Override
    public void setOptionsMenuEnabled(boolean pOptionsMenuEnabled) {
        this.mOptionsMenuEnabled = pOptionsMenuEnabled;
    }

    @Override
    public boolean isOptionsMenuEnabled() {
        return this.mOptionsMenuEnabled;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.add(0, MENU_MY_LOCATION + pMenuIdOffset, 0, (CharSequence)pMapView.getContext().getResources().getString(R.string.my_location)).setIcon(pMapView.getContext().getResources().getDrawable(R.drawable.ic_menu_mylocation)).setCheckable(true);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.findItem(MENU_MY_LOCATION + pMenuIdOffset).setChecked(this.isMyLocationEnabled());
        return false;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem pItem, int pMenuIdOffset, MapView pMapView) {
        int menuId = pItem.getItemId() - pMenuIdOffset;
        if (menuId == MENU_MY_LOCATION) {
            if (this.isMyLocationEnabled()) {
                this.disableFollowLocation();
                this.disableMyLocation();
            } else {
                this.enableFollowLocation();
                this.enableMyLocation();
            }
            return true;
        }
        return false;
    }

    public GeoPoint getMyLocation() {
        if (this.mLocation == null) {
            return null;
        }
        return new GeoPoint(this.mLocation);
    }

    public Location getLastFix() {
        return this.mLocation;
    }

    public void enableFollowLocation() {
        Location location;
        this.mIsFollowing = true;
        if (this.isMyLocationEnabled() && (location = this.mMyLocationProvider.getLastKnownLocation()) != null) {
            this.setLocation(location);
        }
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
    }

    public void disableFollowLocation() {
        this.mMapController.stopAnimation(false);
        this.mIsFollowing = false;
    }

    public boolean isFollowLocationEnabled() {
        return this.mIsFollowing;
    }

    @Override
    public void onLocationChanged(final Location location, IMyLocationProvider source) {
        if (location != null && this.mHandler != null) {
            this.mHandler.postAtTime(new Runnable(){

                @Override
                public void run() {
                    MyLocationNewOverlay.this.setLocation(location);
                    for (Runnable runnable : MyLocationNewOverlay.this.mRunOnFirstFix) {
                        Thread t = new Thread(runnable);
                        t.setName(this.getClass().getName() + "#onLocationChanged");
                        t.start();
                    }
                    MyLocationNewOverlay.this.mRunOnFirstFix.clear();
                }
            }, this.mHandlerToken, 0L);
        }
    }

    protected void setLocation(Location location) {
        this.mLocation = location;
        this.mGeoPoint.setCoords(this.mLocation.getLatitude(), this.mLocation.getLongitude());
        if (this.mIsFollowing) {
            this.mMapController.animateTo(this.mGeoPoint);
        } else if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
    }

    public boolean enableMyLocation(IMyLocationProvider myLocationProvider) {
        Location location;
        boolean success;
        this.setMyLocationProvider(myLocationProvider);
        this.mIsLocationEnabled = success = this.mMyLocationProvider.startLocationProvider(this);
        if (success && (location = this.mMyLocationProvider.getLastKnownLocation()) != null) {
            this.setLocation(location);
        }
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
        return success;
    }

    public boolean enableMyLocation() {
        return this.enableMyLocation(this.mMyLocationProvider);
    }

    public void disableMyLocation() {
        this.mIsLocationEnabled = false;
        this.stopLocationProvider();
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
    }

    protected void stopLocationProvider() {
        if (this.mMyLocationProvider != null) {
            this.mMyLocationProvider.stopLocationProvider();
        }
        if (this.mHandler != null && this.mHandlerToken != null) {
            this.mHandler.removeCallbacksAndMessages(this.mHandlerToken);
        }
    }

    public boolean isMyLocationEnabled() {
        return this.mIsLocationEnabled;
    }

    public boolean runOnFirstFix(Runnable runnable) {
        if (this.mMyLocationProvider != null && this.mLocation != null) {
            Thread t = new Thread(runnable);
            t.setName(this.getClass().getName() + "#runOnFirstFix");
            t.start();
            return true;
        }
        this.mRunOnFirstFix.addLast(runnable);
        return false;
    }

    public void setPersonIcon(Bitmap icon) {
        this.mPersonBitmap = icon;
    }

    public void setPersonAnchor(float pHorizontal, float pVertical) {
        this.mPersonHotspot.set((float)this.mPersonBitmap.getWidth() * pHorizontal, (float)this.mPersonBitmap.getHeight() * pVertical);
    }

    public void setDirectionAnchor(float pHorizontal, float pVertical) {
        this.mDirectionArrowCenterX = (float)this.mDirectionArrowBitmap.getWidth() * pHorizontal;
        this.mDirectionArrowCenterY = (float)this.mDirectionArrowBitmap.getHeight() * pVertical;
    }
}

