/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.advancedpolyline;

import android.graphics.Color;

public class ColorHelper {
    public static int HSLToColor(float h, float s, float l) {
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float m = l - 0.5f * c;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        int hueSegment = (int)h / 60;
        int r = 0;
        int g = 0;
        int b = 0;
        switch (hueSegment) {
            case 0: {
                r = Math.round(255.0f * (c + m));
                g = Math.round(255.0f * (x + m));
                b = Math.round(255.0f * m);
                break;
            }
            case 1: {
                r = Math.round(255.0f * (x + m));
                g = Math.round(255.0f * (c + m));
                b = Math.round(255.0f * m);
                break;
            }
            case 2: {
                r = Math.round(255.0f * m);
                g = Math.round(255.0f * (c + m));
                b = Math.round(255.0f * (x + m));
                break;
            }
            case 3: {
                r = Math.round(255.0f * m);
                g = Math.round(255.0f * (x + m));
                b = Math.round(255.0f * (c + m));
                break;
            }
            case 4: {
                r = Math.round(255.0f * (x + m));
                g = Math.round(255.0f * m);
                b = Math.round(255.0f * (c + m));
                break;
            }
            case 5: 
            case 6: {
                r = Math.round(255.0f * (c + m));
                g = Math.round(255.0f * m);
                b = Math.round(255.0f * (x + m));
            }
        }
        r = ColorHelper.constrain(r, 0, 255);
        g = ColorHelper.constrain(g, 0, 255);
        b = ColorHelper.constrain(b, 0, 255);
        return Color.rgb((int)r, (int)g, (int)b);
    }

    private static int constrain(int amount, int low, int high) {
        return amount < low ? low : (amount > high ? high : amount);
    }

    public static float constrain(float amount, float low, float high) {
        return amount < low ? low : (amount > high ? high : amount);
    }
}

