/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import org.osmdroid.util.Distance;
import org.osmdroid.util.PointAccepter;
import org.osmdroid.util.PointL;
import org.osmdroid.util.RectL;
import org.osmdroid.util.SegmentIntersection;

public class SegmentClipper
implements PointAccepter {
    private final PointL mOptimIntersection = new PointL();
    private final PointL mOptimIntersection1 = new PointL();
    private final PointL mOptimIntersection2 = new PointL();
    private long mXMin;
    private long mYMin;
    private long mXMax;
    private long mYMax;
    private PointAccepter mPointAccepter;
    private final long[] cornerX = new long[4];
    private final long[] cornerY = new long[4];
    private final PointL mPoint0 = new PointL();
    private final PointL mPoint1 = new PointL();
    private boolean mFirstPoint;
    private boolean mPathMode;

    public void set(long pXMin, long pYMin, long pXMax, long pYMax, PointAccepter pPointAccepter, boolean pPathMode) {
        this.mXMin = pXMin;
        this.mYMin = pYMin;
        this.mXMax = pXMax;
        this.mYMax = pYMax;
        this.cornerX[0] = this.cornerX[1] = this.mXMin;
        this.cornerX[2] = this.cornerX[3] = this.mXMax;
        this.cornerY[0] = this.cornerY[2] = this.mYMin;
        this.cornerY[1] = this.cornerY[3] = this.mYMax;
        this.mPointAccepter = pPointAccepter;
        this.mPathMode = pPathMode;
    }

    @Override
    public void init() {
        this.mFirstPoint = true;
        this.mPointAccepter.init();
    }

    @Override
    public void add(long pX, long pY) {
        this.mPoint1.set(pX, pY);
        if (this.mFirstPoint) {
            this.mFirstPoint = false;
        } else {
            this.clip(this.mPoint0.x, this.mPoint0.y, this.mPoint1.x, this.mPoint1.y);
        }
        this.mPoint0.set(this.mPoint1);
    }

    @Override
    public void end() {
        this.mPointAccepter.end();
    }

    public void clip(long pX0, long pY0, long pX1, long pY1) {
        PointL point;
        if (!this.mPathMode && this.isOnTheSameSideOut(pX0, pY0, pX1, pY1)) {
            return;
        }
        if (this.isInClipArea(pX0, pY0)) {
            if (this.isInClipArea(pX1, pY1)) {
                this.nextVertex(pX0, pY0);
                this.nextVertex(pX1, pY1);
                return;
            }
            if (this.intersection(pX0, pY0, pX1, pY1)) {
                this.nextVertex(pX0, pY0);
                this.nextVertex(this.mOptimIntersection.x, this.mOptimIntersection.y);
                if (this.mPathMode) {
                    this.nextVertex(this.clipX(pX1), this.clipY(pY1));
                }
                return;
            }
            throw new RuntimeException("Cannot find expected mOptimIntersection for " + new RectL(pX0, pY0, pX1, pY1));
        }
        if (this.isInClipArea(pX1, pY1)) {
            if (this.intersection(pX0, pY0, pX1, pY1)) {
                if (this.mPathMode) {
                    this.nextVertex(this.clipX(pX0), this.clipY(pY0));
                }
                this.nextVertex(this.mOptimIntersection.x, this.mOptimIntersection.y);
                this.nextVertex(pX1, pY1);
                return;
            }
            throw new RuntimeException("Cannot find expected mOptimIntersection for " + new RectL(pX0, pY0, pX1, pY1));
        }
        int count = 0;
        if (this.intersection(pX0, pY0, pX1, pY1, this.mXMin, this.mYMin, this.mXMin, this.mYMax)) {
            point = count++ == 0 ? this.mOptimIntersection1 : this.mOptimIntersection2;
            point.set(this.mOptimIntersection);
        }
        if (this.intersection(pX0, pY0, pX1, pY1, this.mXMax, this.mYMin, this.mXMax, this.mYMax)) {
            point = count++ == 0 ? this.mOptimIntersection1 : this.mOptimIntersection2;
            point.set(this.mOptimIntersection);
        }
        if (this.intersection(pX0, pY0, pX1, pY1, this.mXMin, this.mYMin, this.mXMax, this.mYMin)) {
            point = count++ == 0 ? this.mOptimIntersection1 : this.mOptimIntersection2;
            point.set(this.mOptimIntersection);
        }
        if (this.intersection(pX0, pY0, pX1, pY1, this.mXMin, this.mYMax, this.mXMax, this.mYMax)) {
            point = count++ == 0 ? this.mOptimIntersection1 : this.mOptimIntersection2;
            point.set(this.mOptimIntersection);
        }
        if (count == 2) {
            PointL end;
            double distance2;
            double distance1 = Distance.getSquaredDistanceToPoint(this.mOptimIntersection1.x, this.mOptimIntersection1.y, pX0, pY0);
            PointL start = distance1 < (distance2 = Distance.getSquaredDistanceToPoint(this.mOptimIntersection2.x, this.mOptimIntersection2.y, pX0, pY0)) ? this.mOptimIntersection1 : this.mOptimIntersection2;
            PointL pointL = end = distance1 < distance2 ? this.mOptimIntersection2 : this.mOptimIntersection1;
            if (this.mPathMode) {
                this.nextVertex(this.clipX(pX0), this.clipY(pY0));
            }
            this.nextVertex(start.x, start.y);
            this.nextVertex(end.x, end.y);
            if (this.mPathMode) {
                this.nextVertex(this.clipX(pX1), this.clipY(pY1));
            }
            return;
        }
        if (count == 1) {
            if (this.mPathMode) {
                this.nextVertex(this.clipX(pX0), this.clipY(pY0));
                this.nextVertex(this.mOptimIntersection1.x, this.mOptimIntersection1.y);
                this.nextVertex(this.clipX(pX1), this.clipY(pY1));
            }
            return;
        }
        if (count == 0) {
            if (this.mPathMode) {
                this.nextVertex(this.clipX(pX0), this.clipY(pY0));
                int corner = this.getClosestCorner(pX0, pY0, pX1, pY1);
                this.nextVertex(this.cornerX[corner], this.cornerY[corner]);
                this.nextVertex(this.clipX(pX1), this.clipY(pY1));
            }
            return;
        }
        throw new RuntimeException("Impossible mOptimIntersection count (" + count + ")");
    }

    public boolean isInClipArea(long pX, long pY) {
        return pX > this.mXMin && pX < this.mXMax && pY > this.mYMin && pY < this.mYMax;
    }

    private static long clip(long pValue, long pMin, long pMax) {
        return pValue <= pMin ? pMin : (pValue >= pMax ? pMax : pValue);
    }

    private long clipX(long pX) {
        return SegmentClipper.clip(pX, this.mXMin, this.mXMax);
    }

    private long clipY(long pY) {
        return SegmentClipper.clip(pY, this.mYMin, this.mYMax);
    }

    private void nextVertex(long pX, long pY) {
        this.mPointAccepter.add(pX, pY);
    }

    private boolean intersection(long pX0, long pY0, long pX1, long pY1, long pX2, long pY2, long pX3, long pY3) {
        return SegmentIntersection.intersection(pX0, pY0, pX1, pY1, pX2, pY2, pX3, pY3, this.mOptimIntersection);
    }

    private boolean intersection(long pX0, long pY0, long pX1, long pY1) {
        return this.intersection(pX0, pY0, pX1, pY1, this.mXMin, this.mYMin, this.mXMin, this.mYMax) || this.intersection(pX0, pY0, pX1, pY1, this.mXMax, this.mYMin, this.mXMax, this.mYMax) || this.intersection(pX0, pY0, pX1, pY1, this.mXMin, this.mYMin, this.mXMax, this.mYMin) || this.intersection(pX0, pY0, pX1, pY1, this.mXMin, this.mYMax, this.mXMax, this.mYMax);
    }

    private int getClosestCorner(long pX0, long pY0, long pX1, long pY1) {
        double min = Double.MAX_VALUE;
        int corner = 0;
        for (int i = 0; i < this.cornerX.length; ++i) {
            double distance = Distance.getSquaredDistanceToSegment(this.cornerX[i], this.cornerY[i], pX0, pY0, pX1, pY1);
            if (!(min > distance)) continue;
            min = distance;
            corner = i;
        }
        return corner;
    }

    private boolean isOnTheSameSideOut(long pX0, long pY0, long pX1, long pY1) {
        return pX0 < this.mXMin && pX1 < this.mXMin || pX0 > this.mXMax && pX1 > this.mXMax || pY0 < this.mYMin && pY1 < this.mYMin || pY0 > this.mYMax && pY1 > this.mYMax;
    }
}

