/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.library.R;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.PointL;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.LineDrawer;
import org.osmdroid.views.overlay.LinearRing;
import org.osmdroid.views.overlay.OverlayWithIW;
import org.osmdroid.views.overlay.infowindow.BasicInfoWindow;
import org.osmdroid.views.overlay.infowindow.InfoWindow;
import org.osmdroid.views.overlay.milestones.MilestoneManager;

public class Polyline
extends OverlayWithIW {
    private final Paint mPaint = new Paint();
    private final LineDrawer mLineDrawer = new LineDrawer(256);
    private LinearRing mOutline = new LinearRing(this.mLineDrawer);
    private List<MilestoneManager> mMilestoneManagers = new ArrayList<MilestoneManager>();
    protected static InfoWindow mDefaultInfoWindow = null;
    protected OnClickListener mOnClickListener;
    private GeoPoint mInfoWindowLocation;
    private float mDensity = 1.0f;
    private ArrayList<GeoPoint> mOriginalPoints = new ArrayList();

    public Polyline() {
        this((MapView)null);
    }

    public Polyline(MapView mapView) {
        if (mapView != null) {
            if (mDefaultInfoWindow == null || mDefaultInfoWindow.getMapView() != mapView) {
                mDefaultInfoWindow = new BasicInfoWindow(R.layout.bonuspack_bubble, mapView);
            }
            this.mDensity = mapView.getContext().getResources().getDisplayMetrics().density;
        }
        this.setInfoWindow(mDefaultInfoWindow);
        this.mPaint.setColor(-16777216);
        this.mPaint.setStrokeWidth(10.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setAntiAlias(true);
        this.mOutline.clearPath();
        this.mLineDrawer.setPaint(this.mPaint);
    }

    public ArrayList<GeoPoint> getPoints() {
        ArrayList<GeoPoint> result = new ArrayList<GeoPoint>(this.mOriginalPoints.size());
        for (GeoPoint p : this.mOriginalPoints) {
            result.add(p);
        }
        return result;
    }

    public int getColor() {
        return this.mPaint.getColor();
    }

    public float getWidth() {
        return this.mPaint.getStrokeWidth();
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public boolean isVisible() {
        return this.isEnabled();
    }

    public void setGeodesic(boolean geodesic) {
        this.mOutline.setGeodesic(geodesic);
    }

    public boolean isGeodesic() {
        return this.mOutline.isGeodesic();
    }

    public void setColor(int color) {
        this.mPaint.setColor(color);
    }

    public void setWidth(float width) {
        this.mPaint.setStrokeWidth(width);
    }

    public void setVisible(boolean visible) {
        this.setEnabled(visible);
    }

    public void setOnClickListener(OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    public void setPoints(List<GeoPoint> points) {
        this.mOutline.clearPath();
        this.mOriginalPoints = new ArrayList(points.size());
        for (GeoPoint p : points) {
            this.mOriginalPoints.add(p);
        }
        this.mOutline.setPoints(points);
        this.setDefaultInfoWindowLocation();
    }

    public void addPoint(GeoPoint p) {
        this.mOriginalPoints.add(p);
        this.mOutline.addPoint(p);
    }

    @Override
    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        Projection pj = mapView.getProjection();
        this.mLineDrawer.setCanvas(canvas);
        this.mOutline.setClipArea(mapView);
        this.mOutline.buildLinePortion(pj, this.mMilestoneManagers.size() > 0);
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.init();
            milestoneManager.setDistances(this.mOutline.getDistances());
            for (PointL point : this.mOutline.getPointsForMilestones()) {
                milestoneManager.add(point.x, point.y);
            }
            milestoneManager.end();
        }
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.draw(canvas);
        }
        if (this.isInfoWindowOpen() && this.mInfoWindow != null && this.mInfoWindow.getRelatedObject() == this) {
            this.mInfoWindow.draw();
        }
    }

    public boolean isCloseTo(GeoPoint point, double tolerance, MapView mapView) {
        return this.mOutline.isCloseTo(point, tolerance, mapView.getProjection(), false);
    }

    @Override
    public void setInfoWindow(InfoWindow infoWindow) {
        if (this.mInfoWindow != null) {
            if (this.mInfoWindow.getRelatedObject() == this) {
                this.mInfoWindow.setRelatedObject(null);
            }
            if (this.mInfoWindow != mDefaultInfoWindow) {
                this.mInfoWindow.onDetach();
            }
        }
        this.mInfoWindow = infoWindow;
    }

    public void showInfoWindow() {
        if (this.mInfoWindow != null && this.mInfoWindowLocation != null) {
            this.mInfoWindow.open(this, this.mInfoWindowLocation, 0, 0);
        }
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        double tolerance;
        Projection pj = mapView.getProjection();
        GeoPoint eventPos = (GeoPoint)pj.fromPixels((int)event.getX(), (int)event.getY());
        boolean touched = this.isCloseTo(eventPos, tolerance = (double)(this.mPaint.getStrokeWidth() * this.mDensity), mapView);
        if (touched) {
            if (this.mOnClickListener == null) {
                return this.onClickDefault(this, mapView, eventPos);
            }
            return this.mOnClickListener.onClick(this, mapView, eventPos);
        }
        return touched;
    }

    public GeoPoint getInfoWindowLocation() {
        return this.mInfoWindowLocation;
    }

    protected void setDefaultInfoWindowLocation() {
        int s = this.mOriginalPoints.size();
        this.mInfoWindowLocation = s > 0 ? this.mOriginalPoints.get(s / 2) : new GeoPoint(0.0, 0.0);
    }

    public void setInfoWindowLocation(GeoPoint location) {
        this.mInfoWindowLocation = location;
    }

    public boolean onClickDefault(Polyline polyline, MapView mapView, GeoPoint eventPos) {
        polyline.setInfoWindowLocation(eventPos);
        polyline.showInfoWindow();
        return true;
    }

    @Override
    public void onDetach(MapView mapView) {
        this.mOutline = null;
        this.mOnClickListener = null;
        this.mMilestoneManagers.clear();
        this.mOriginalPoints = null;
        this.onDestroy();
    }

    public void setMilestoneManagers(List<MilestoneManager> pMilestoneManagers) {
        if (pMilestoneManagers == null) {
            if (this.mMilestoneManagers.size() > 0) {
                this.mMilestoneManagers.clear();
            }
        } else {
            this.mMilestoneManagers = pMilestoneManagers;
        }
    }

    public static interface OnClickListener {
        public boolean onClick(Polyline var1, MapView var2, GeoPoint var3);
    }
}

