/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.util.Distance;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.LineBuilder;
import org.osmdroid.util.ListPointL;
import org.osmdroid.util.PathBuilder;
import org.osmdroid.util.PointAccepter;
import org.osmdroid.util.PointL;
import org.osmdroid.util.SegmentClipper;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;

class LinearRing {
    private final ArrayList<GeoPoint> mOriginalPoints = new ArrayList();
    private double[] mDistances;
    private long[] mProjectedPoints;
    private final PointL mProjectedCenter = new PointL();
    private final SegmentClipper mSegmentClipper = new SegmentClipper();
    private final Path mPath;
    private boolean mPrecomputed;
    private boolean isHorizontalRepeating = true;
    private boolean isVerticalRepeating = true;
    private final ListPointL mPointsForMilestones = new ListPointL();
    private final PointAccepter mPointAccepter;
    private boolean mGeodesic = false;

    public LinearRing(Path pPath) {
        this.mPath = pPath;
        this.mPointAccepter = new PathBuilder(pPath);
    }

    public LinearRing(LineBuilder pLineBuilder) {
        this.mPath = null;
        this.mPointAccepter = pLineBuilder;
    }

    void clearPath() {
        this.mOriginalPoints.clear();
        this.mProjectedPoints = null;
        this.mDistances = null;
        this.mPrecomputed = false;
        this.mPointAccepter.init();
    }

    protected void addGreatCircle(GeoPoint startPoint, GeoPoint endPoint, int numberOfPoints) {
        double lat1 = startPoint.getLatitude() * (Math.PI / 180);
        double lon1 = startPoint.getLongitude() * (Math.PI / 180);
        double lat2 = endPoint.getLatitude() * (Math.PI / 180);
        double lon2 = endPoint.getLongitude() * (Math.PI / 180);
        double d = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
        for (int i = 1; i <= numberOfPoints; ++i) {
            double f = 1.0 * (double)i / (double)(numberOfPoints + 1);
            double A = Math.sin((1.0 - f) * d) / Math.sin(d);
            double B = Math.sin(f * d) / Math.sin(d);
            double x = A * Math.cos(lat1) * Math.cos(lon1) + B * Math.cos(lat2) * Math.cos(lon2);
            double y = A * Math.cos(lat1) * Math.sin(lon1) + B * Math.cos(lat2) * Math.sin(lon2);
            double z = A * Math.sin(lat1) + B * Math.sin(lat2);
            double latN = Math.atan2(z, Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)));
            double lonN = Math.atan2(y, x);
            GeoPoint p = new GeoPoint(latN * 57.29577951308232, lonN * 57.29577951308232);
            this.mOriginalPoints.add(p);
        }
    }

    public void addPoint(GeoPoint p) {
        if (this.mGeodesic && this.mOriginalPoints.size() > 0) {
            GeoPoint prev = this.mOriginalPoints.get(this.mOriginalPoints.size() - 1);
            int greatCircleLength = (int)prev.distanceToAsDouble(p);
            int numberOfPoints = greatCircleLength / 100000;
            this.addGreatCircle(prev, p, numberOfPoints);
        }
        this.mOriginalPoints.add(p);
        this.mPrecomputed = false;
    }

    public void setPoints(List<GeoPoint> points) {
        this.clearPath();
        for (GeoPoint p : points) {
            this.addPoint(p);
        }
    }

    public ArrayList<GeoPoint> getPoints() {
        return this.mOriginalPoints;
    }

    double[] getDistances() {
        return this.mDistances;
    }

    public void setGeodesic(boolean geodesic) {
        this.mGeodesic = geodesic;
    }

    public boolean isGeodesic() {
        return this.mGeodesic;
    }

    PointL buildPathPortion(Projection pProjection, PointL pOffset, boolean pStorePoints) {
        PointL offset;
        int size = this.mOriginalPoints.size();
        if (size < 2) {
            return pOffset;
        }
        if (!this.mPrecomputed) {
            this.computeProjectedAndDistances(pProjection);
            this.mPrecomputed = true;
        }
        if (pOffset != null) {
            offset = pOffset;
        } else {
            offset = new PointL();
            this.getBestOffset(pProjection, offset);
        }
        this.mSegmentClipper.init();
        this.clipAndStore(pProjection, offset, true, pStorePoints, this.mSegmentClipper);
        this.mSegmentClipper.end();
        this.mPath.close();
        return offset;
    }

    void buildLinePortion(Projection pProjection, boolean pStorePoints) {
        int size = this.mOriginalPoints.size();
        if (size < 2) {
            return;
        }
        if (!this.mPrecomputed) {
            this.computeProjectedAndDistances(pProjection);
            this.mPrecomputed = true;
        }
        PointL offset = new PointL();
        this.getBestOffset(pProjection, offset);
        this.mSegmentClipper.init();
        this.clipAndStore(pProjection, offset, false, pStorePoints, this.mSegmentClipper);
        this.mSegmentClipper.end();
    }

    public ListPointL getPointsForMilestones() {
        return this.mPointsForMilestones;
    }

    private void getBestOffset(Projection pProjection, PointL pOffset) {
        double powerDifference = pProjection.getProjectedPowerDifference();
        PointL center = pProjection.getLongPixelsFromProjected(this.mProjectedCenter, powerDifference, false, null);
        Rect screenRect = pProjection.getIntrinsicScreenRect();
        double screenCenterX = (double)(screenRect.left + screenRect.right) / 2.0;
        double screenCenterY = (double)(screenRect.top + screenRect.bottom) / 2.0;
        double worldSize = TileSystem.MapSize(pProjection.getZoomLevel());
        this.getBestOffset((double)center.x, (double)center.y, screenCenterX, screenCenterY, worldSize, pOffset);
    }

    private void getBestOffset(double pPolyCenterX, double pPolyCenterY, double pScreenCenterX, double pScreenCenterY, double pWorldSize, PointL pOffset) {
        int deltaNegative;
        int deltaPositive;
        long worldSize = Math.round(pWorldSize);
        if (!this.isVerticalRepeating) {
            deltaPositive = 0;
            deltaNegative = 0;
        } else {
            deltaPositive = this.getBestOffset(pPolyCenterX, pPolyCenterY, pScreenCenterX, pScreenCenterY, 0L, worldSize);
            deltaNegative = this.getBestOffset(pPolyCenterX, pPolyCenterY, pScreenCenterX, pScreenCenterY, 0L, -worldSize);
        }
        pOffset.y = worldSize * (long)(deltaPositive > deltaNegative ? deltaPositive : -deltaNegative);
        if (!this.isHorizontalRepeating) {
            deltaPositive = 0;
            deltaNegative = 0;
        } else {
            deltaPositive = this.getBestOffset(pPolyCenterX, pPolyCenterY, pScreenCenterX, pScreenCenterY, worldSize, 0L);
            deltaNegative = this.getBestOffset(pPolyCenterX, pPolyCenterY, pScreenCenterX, pScreenCenterY, -worldSize, 0L);
        }
        pOffset.x = worldSize * (long)(deltaPositive > deltaNegative ? deltaPositive : -deltaNegative);
    }

    private int getBestOffset(double pPolyCenterX, double pPolyCenterY, double pScreenCenterX, double pScreenCenterY, long pDeltaX, long pDeltaY) {
        double squaredDistance = 0.0;
        int i = 0;
        while (true) {
            double tmpSquaredDistance = Distance.getSquaredDistanceToPoint(pPolyCenterX + (double)((long)i * pDeltaX), pPolyCenterY + (double)((long)i * pDeltaY), pScreenCenterX, pScreenCenterY);
            if (i != 0 && !(squaredDistance > tmpSquaredDistance)) break;
            squaredDistance = tmpSquaredDistance;
            ++i;
        }
        return i - 1;
    }

    private void computeProjectedAndDistances(Projection pProjection) {
        if (this.mProjectedPoints == null || this.mProjectedPoints.length != this.mOriginalPoints.size() * 2) {
            this.mProjectedPoints = new long[this.mOriginalPoints.size() * 2];
        }
        if (this.mDistances == null || this.mDistances.length != this.mOriginalPoints.size()) {
            this.mDistances = new double[this.mOriginalPoints.size()];
        }
        long minX = 0L;
        long maxX = 0L;
        long minY = 0L;
        long maxY = 0L;
        int index = 0;
        PointL previous = new PointL();
        PointL current = new PointL();
        GeoPoint previousGeo = new GeoPoint(0.0, 0.0);
        for (GeoPoint currentGeo : this.mOriginalPoints) {
            pProjection.toProjectedPixels(currentGeo.getLatitude(), currentGeo.getLongitude(), false, current);
            if (index == 0) {
                this.mDistances[index] = 0.0;
                minX = maxX = current.x;
                minY = maxY = current.y;
            } else {
                this.mDistances[index] = currentGeo.distanceToAsDouble(previousGeo);
                this.setCloserPoint(previous, current, pProjection.mProjectedMapSize);
                if (minX > current.x) {
                    minX = current.x;
                }
                if (maxX < current.x) {
                    maxX = current.x;
                }
                if (minY > current.y) {
                    minY = current.y;
                }
                if (maxY < current.y) {
                    maxY = current.y;
                }
            }
            this.mProjectedPoints[2 * index] = current.x;
            this.mProjectedPoints[2 * index + 1] = current.y;
            previousGeo.setCoords(currentGeo.getLatitude(), currentGeo.getLongitude());
            previous.set(current.x, current.y);
            ++index;
        }
        this.mProjectedCenter.set((minX + maxX) / 2L, (minY + maxY) / 2L);
    }

    private void clipAndStore(Projection pProjection, PointL pOffset, boolean pClosePath, boolean pStorePoints, SegmentClipper pSegmentClipper) {
        this.mPointsForMilestones.clear();
        double powerDifference = pProjection.getProjectedPowerDifference();
        PointL projected = new PointL();
        PointL point = new PointL();
        PointL first = new PointL();
        for (int i = 0; i < this.mProjectedPoints.length; i += 2) {
            projected.set(this.mProjectedPoints[i], this.mProjectedPoints[i + 1]);
            pProjection.getLongPixelsFromProjected(projected, powerDifference, false, point);
            long x = point.x + pOffset.x;
            long y = point.y + pOffset.y;
            if (pStorePoints) {
                this.mPointsForMilestones.add(x, y);
            }
            if (pSegmentClipper != null) {
                pSegmentClipper.add(x, y);
            }
            if (i != 0) continue;
            first.set(x, y);
        }
        if (pClosePath) {
            if (pSegmentClipper != null) {
                pSegmentClipper.add(first.x, first.y);
            }
            if (pStorePoints) {
                this.mPointsForMilestones.add(first.x, first.y);
            }
        }
    }

    private void setCloserPoint(PointL pPrevious, PointL pNext, double pWorldSize) {
        while (this.isHorizontalRepeating && Math.abs((double)pNext.x - pWorldSize - (double)pPrevious.x) < (double)Math.abs(pNext.x - pPrevious.x)) {
            pNext.x = (long)((double)pNext.x - pWorldSize);
        }
        while (this.isHorizontalRepeating && Math.abs((double)pNext.x + pWorldSize - (double)pPrevious.x) < (double)Math.abs(pNext.x - pPrevious.x)) {
            pNext.x = (long)((double)pNext.x + pWorldSize);
        }
        while (this.isVerticalRepeating && Math.abs((double)pNext.y - pWorldSize - (double)pPrevious.y) < (double)Math.abs(pNext.y - pPrevious.y)) {
            pNext.y = (long)((double)pNext.y - pWorldSize);
        }
        while (this.isVerticalRepeating && Math.abs((double)pNext.y + pWorldSize - (double)pPrevious.y) < (double)Math.abs(pNext.y - pPrevious.y)) {
            pNext.y = (long)((double)pNext.y + pWorldSize);
        }
    }

    boolean isCloseTo(GeoPoint pPoint, double tolerance, Projection pProjection, boolean pClosePath) {
        if (!this.mPrecomputed) {
            this.computeProjectedAndDistances(pProjection);
            this.mPrecomputed = true;
        }
        Point pixel = pProjection.toPixels(pPoint, null);
        PointL offset = new PointL();
        this.getBestOffset(pProjection, offset);
        this.clipAndStore(pProjection, offset, pClosePath, true, null);
        double squaredTolerance = tolerance * tolerance;
        PointL point0 = new PointL();
        PointL point1 = new PointL();
        boolean first = true;
        for (PointL point : this.mPointsForMilestones) {
            point1.set(point);
            if (first) {
                first = false;
            } else if (squaredTolerance > Distance.getSquaredDistanceToSegment(pixel.x, pixel.y, point0.x, point0.y, point1.x, point1.y)) {
                return true;
            }
            point0.set(point1);
        }
        return false;
    }

    public void setClipArea(long pXMin, long pYMin, long pXMax, long pYMax) {
        this.mSegmentClipper.set(pXMin, pYMin, pXMax, pYMax, this.mPointAccepter, this.mPath != null);
    }

    public void setClipArea(MapView pMapView) {
        double border = 0.1;
        int halfWidth = pMapView.getWidth() / 2;
        int halfHeight = pMapView.getHeight() / 2;
        double radius = Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        int scaledRadius = (int)(radius * 1.1);
        this.setClipArea(halfWidth - scaledRadius, halfHeight - scaledRadius, halfWidth + scaledRadius, halfHeight + scaledRadius);
        this.isHorizontalRepeating = pMapView.isHorizontalMapRepetitionEnabled();
        this.isVerticalRepeating = pMapView.isVerticalMapRepetitionEnabled();
    }

    public GeoPoint getCenter(GeoPoint pReuse) {
        long centerY;
        long centerX;
        GeoPoint out = pReuse != null ? pReuse : new GeoPoint(0.0, 0.0);
        long minX = 0L;
        long maxX = 0L;
        long minY = 0L;
        long maxY = 0L;
        boolean first = true;
        PointL previous = new PointL();
        PointL current = new PointL();
        long projectedMapSize = 0x1000000000000000L;
        TileSystem tileSystem = MapView.getTileSystem();
        for (GeoPoint currentGeo : this.mOriginalPoints) {
            tileSystem.getMercatorFromGeo(currentGeo.getLatitude(), currentGeo.getLongitude(), 1.152921504606847E18, current, false);
            if (first) {
                first = false;
                minX = maxX = current.x;
                minY = maxY = current.y;
            } else {
                this.setCloserPoint(previous, current, 1.152921504606847E18);
                if (minX > current.x) {
                    minX = current.x;
                }
                if (maxX < current.x) {
                    maxX = current.x;
                }
                if (minY > current.y) {
                    minY = current.y;
                }
                if (maxY < current.y) {
                    maxY = current.y;
                }
            }
            previous.set(current.x, current.y);
        }
        for (centerX = (minX + maxX) / 2L; centerX < 0L; centerX += 0x1000000000000000L) {
        }
        while (centerX >= 0x1000000000000000L) {
            centerX -= 0x1000000000000000L;
        }
        for (centerY = (minY + maxY) / 2L; centerY < 0L; centerY += 0x1000000000000000L) {
        }
        while (centerY >= 0x1000000000000000L) {
            centerY -= 0x1000000000000000L;
        }
        return tileSystem.getGeoFromMercator(centerX, centerY, 1.152921504606847E18, out, false, false);
    }
}

