/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Canvas;
import android.graphics.Point;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osmdroid.api.IMapView;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.IOverlayMenuProvider;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.OverlayManager;
import org.osmdroid.views.overlay.TilesOverlay;

public class DefaultOverlayManager
extends AbstractList<Overlay>
implements OverlayManager {
    private TilesOverlay mTilesOverlay;
    private final CopyOnWriteArrayList<Overlay> mOverlayList;

    public DefaultOverlayManager(TilesOverlay tilesOverlay) {
        this.setTilesOverlay(tilesOverlay);
        this.mOverlayList = new CopyOnWriteArrayList();
    }

    @Override
    public Overlay get(int pIndex) {
        return this.mOverlayList.get(pIndex);
    }

    @Override
    public int size() {
        return this.mOverlayList.size();
    }

    @Override
    public void add(int pIndex, Overlay pElement) {
        if (pElement == null) {
            Exception ex = new Exception();
            Log.e((String)"OsmDroid", (String)"Attempt to add a null overlay to the collection. This is probably a bug and should be reported!", (Throwable)ex);
        } else {
            this.mOverlayList.add(pIndex, pElement);
        }
    }

    @Override
    public Overlay remove(int pIndex) {
        return this.mOverlayList.remove(pIndex);
    }

    @Override
    public Overlay set(int pIndex, Overlay pElement) {
        if (pElement == null) {
            Exception ex = new Exception();
            Log.e((String)"OsmDroid", (String)"Attempt to set a null overlay to the collection. This is probably a bug and should be reported!", (Throwable)ex);
            return null;
        }
        Overlay overlay = this.mOverlayList.set(pIndex, pElement);
        return overlay;
    }

    @Override
    public TilesOverlay getTilesOverlay() {
        return this.mTilesOverlay;
    }

    @Override
    public void setTilesOverlay(TilesOverlay tilesOverlay) {
        this.mTilesOverlay = tilesOverlay;
    }

    @Override
    public Iterable<Overlay> overlaysReversed() {
        return new Iterable<Overlay>(){

            @Override
            public Iterator<Overlay> iterator() {
                final ListIterator i = DefaultOverlayManager.this.mOverlayList.listIterator(DefaultOverlayManager.this.mOverlayList.size());
                return new Iterator<Overlay>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasPrevious();
                    }

                    @Override
                    public Overlay next() {
                        return (Overlay)i.previous();
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }
        };
    }

    @Override
    public List<Overlay> overlays() {
        return this.mOverlayList;
    }

    @Override
    public void onDraw(Canvas c, MapView pMapView) {
        if (this.mTilesOverlay != null) {
            this.mTilesOverlay.protectDisplayedTilesForCache(c, pMapView);
        }
        for (Overlay overlay : this.mOverlayList) {
            if (overlay == null || !overlay.isEnabled() || !(overlay instanceof TilesOverlay)) continue;
            ((TilesOverlay)overlay).protectDisplayedTilesForCache(c, pMapView);
        }
        if (this.mTilesOverlay != null) {
            this.mTilesOverlay.protectDisplayedTilesForCache(c, pMapView);
        }
        for (Overlay overlay : this.mOverlayList) {
            if (overlay == null || !overlay.isEnabled() || !(overlay instanceof TilesOverlay)) continue;
            ((TilesOverlay)overlay).protectDisplayedTilesForCache(c, pMapView);
        }
        if (this.mTilesOverlay != null && this.mTilesOverlay.isEnabled()) {
            this.mTilesOverlay.draw(c, pMapView, false);
        }
        for (Overlay overlay : this.mOverlayList) {
            if (overlay == null || !overlay.isEnabled()) continue;
            overlay.draw(c, pMapView, false);
        }
    }

    @Override
    public void onDetach(MapView pMapView) {
        if (this.mTilesOverlay != null) {
            this.mTilesOverlay.onDetach(pMapView);
        }
        for (Overlay overlay : this.overlaysReversed()) {
            overlay.onDetach(pMapView);
        }
        this.clear();
    }

    @Override
    public void onPause() {
        if (this.mTilesOverlay != null) {
            this.mTilesOverlay.onPause();
        }
        for (Overlay overlay : this.overlaysReversed()) {
            overlay.onPause();
        }
    }

    @Override
    public void onResume() {
        if (this.mTilesOverlay != null) {
            this.mTilesOverlay.onResume();
        }
        for (Overlay overlay : this.overlaysReversed()) {
            overlay.onResume();
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onKeyDown(keyCode, event, pMapView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onKeyUp(keyCode, event, pMapView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onTouchEvent(event, pMapView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent event, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onTrackballEvent(event, pMapView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onSnapToItem(int x, int y, Point snapPoint, IMapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!(overlay instanceof Overlay.Snappable) || !((Overlay.Snappable)((Object)overlay)).onSnapToItem(x, y, snapPoint, pMapView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onDoubleTap(MotionEvent e, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onDoubleTap(e, pMapView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onDoubleTapEvent(MotionEvent e, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onDoubleTapEvent(e, pMapView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent e, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onSingleTapConfirmed(e, pMapView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onDown(MotionEvent pEvent, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onDown(pEvent, pMapView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onFling(MotionEvent pEvent1, MotionEvent pEvent2, float pVelocityX, float pVelocityY, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onFling(pEvent1, pEvent2, pVelocityX, pVelocityY, pMapView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onLongPress(MotionEvent pEvent, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onLongPress(pEvent, pMapView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onScroll(MotionEvent pEvent1, MotionEvent pEvent2, float pDistanceX, float pDistanceY, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onScroll(pEvent1, pEvent2, pDistanceX, pDistanceY, pMapView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onShowPress(MotionEvent pEvent, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            overlay.onShowPress(pEvent, pMapView);
        }
    }

    @Override
    public boolean onSingleTapUp(MotionEvent pEvent, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onSingleTapUp(pEvent, pMapView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setOptionsMenusEnabled(boolean pEnabled) {
        for (Overlay overlay : this.mOverlayList) {
            if (!(overlay instanceof IOverlayMenuProvider) || !((IOverlayMenuProvider)((Object)overlay)).isOptionsMenuEnabled()) continue;
            ((IOverlayMenuProvider)((Object)overlay)).setOptionsMenuEnabled(pEnabled);
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu pMenu, int menuIdOffset, MapView mapView) {
        boolean result = true;
        for (Overlay overlay : this.overlaysReversed()) {
            IOverlayMenuProvider overlayMenuProvider;
            if (!(overlay instanceof IOverlayMenuProvider) || !(overlayMenuProvider = (IOverlayMenuProvider)((Object)overlay)).isOptionsMenuEnabled()) continue;
            result &= overlayMenuProvider.onCreateOptionsMenu(pMenu, menuIdOffset, mapView);
        }
        if (this.mTilesOverlay != null && this.mTilesOverlay.isOptionsMenuEnabled()) {
            result &= this.mTilesOverlay.onCreateOptionsMenu(pMenu, menuIdOffset, mapView);
        }
        return result;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu pMenu, int menuIdOffset, MapView mapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            IOverlayMenuProvider overlayMenuProvider;
            if (!(overlay instanceof IOverlayMenuProvider) || !(overlayMenuProvider = (IOverlayMenuProvider)((Object)overlay)).isOptionsMenuEnabled()) continue;
            overlayMenuProvider.onPrepareOptionsMenu(pMenu, menuIdOffset, mapView);
        }
        if (this.mTilesOverlay != null && this.mTilesOverlay.isOptionsMenuEnabled()) {
            this.mTilesOverlay.onPrepareOptionsMenu(pMenu, menuIdOffset, mapView);
        }
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item, int menuIdOffset, MapView mapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            IOverlayMenuProvider overlayMenuProvider;
            if (!(overlay instanceof IOverlayMenuProvider) || !(overlayMenuProvider = (IOverlayMenuProvider)((Object)overlay)).isOptionsMenuEnabled() || !overlayMenuProvider.onOptionsItemSelected(item, menuIdOffset, mapView)) continue;
            return true;
        }
        return this.mTilesOverlay != null && this.mTilesOverlay.isOptionsMenuEnabled() && this.mTilesOverlay.onOptionsItemSelected(item, menuIdOffset, mapView);
    }
}

