/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.content.Context;
import android.os.Build;
import org.osmdroid.tileprovider.IMapTileProviderCallback;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTileProviderArray;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.modules.INetworkAvailablityCheck;
import org.osmdroid.tileprovider.modules.MapTileApproximater;
import org.osmdroid.tileprovider.modules.MapTileAssetsProvider;
import org.osmdroid.tileprovider.modules.MapTileDownloader;
import org.osmdroid.tileprovider.modules.MapTileFileArchiveProvider;
import org.osmdroid.tileprovider.modules.MapTileFileStorageProviderBase;
import org.osmdroid.tileprovider.modules.MapTileFilesystemProvider;
import org.osmdroid.tileprovider.modules.MapTileSqlCacheProvider;
import org.osmdroid.tileprovider.modules.NetworkAvailabliltyCheck;
import org.osmdroid.tileprovider.modules.SqlTileWriter;
import org.osmdroid.tileprovider.modules.TileWriter;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.TileSourceFactory;
import org.osmdroid.tileprovider.util.SimpleRegisterReceiver;
import org.osmdroid.util.MapTileListBorderComputer;
import org.osmdroid.util.MapTileListZoomComputer;

public class MapTileProviderBasic
extends MapTileProviderArray
implements IMapTileProviderCallback {
    protected IFilesystemCache tileWriter;
    private final INetworkAvailablityCheck mNetworkAvailabilityCheck;

    public MapTileProviderBasic(Context pContext) {
        this(pContext, TileSourceFactory.DEFAULT_TILE_SOURCE);
    }

    public MapTileProviderBasic(Context pContext, ITileSource pTileSource) {
        this(new SimpleRegisterReceiver(pContext), new NetworkAvailabliltyCheck(pContext), pTileSource, pContext, null);
    }

    public MapTileProviderBasic(Context pContext, ITileSource pTileSource, IFilesystemCache cacheWriter) {
        this(new SimpleRegisterReceiver(pContext), new NetworkAvailabliltyCheck(pContext), pTileSource, pContext, cacheWriter);
    }

    public MapTileProviderBasic(IRegisterReceiver pRegisterReceiver, INetworkAvailablityCheck aNetworkAvailablityCheck, ITileSource pTileSource, Context pContext, IFilesystemCache cacheWriter) {
        super(pTileSource, pRegisterReceiver);
        this.mNetworkAvailabilityCheck = aNetworkAvailablityCheck;
        this.tileWriter = cacheWriter != null ? cacheWriter : (Build.VERSION.SDK_INT < 10 ? new TileWriter() : new SqlTileWriter());
        MapTileAssetsProvider assetsProvider = new MapTileAssetsProvider(pRegisterReceiver, pContext.getAssets(), pTileSource);
        this.mTileProviderList.add(assetsProvider);
        MapTileFileStorageProviderBase cacheProvider = Build.VERSION.SDK_INT < 10 ? new MapTileFilesystemProvider(pRegisterReceiver, pTileSource) : new MapTileSqlCacheProvider(pRegisterReceiver, pTileSource);
        this.mTileProviderList.add(cacheProvider);
        MapTileFileArchiveProvider archiveProvider = new MapTileFileArchiveProvider(pRegisterReceiver, pTileSource);
        this.mTileProviderList.add(archiveProvider);
        MapTileApproximater approximationProvider = new MapTileApproximater();
        this.mTileProviderList.add(approximationProvider);
        approximationProvider.addProvider(assetsProvider);
        approximationProvider.addProvider(cacheProvider);
        approximationProvider.addProvider(archiveProvider);
        MapTileDownloader downloaderProvider = new MapTileDownloader(pTileSource, this.tileWriter, aNetworkAvailablityCheck);
        this.mTileProviderList.add(downloaderProvider);
        this.getTileCache().getProtectedTileComputers().add(new MapTileListZoomComputer(-1));
        this.getTileCache().getProtectedTileComputers().add(new MapTileListZoomComputer(1));
        this.getTileCache().getProtectedTileComputers().add(new MapTileListBorderComputer(1, false));
        this.getTileCache().getPreCache().addProvider(assetsProvider);
        this.getTileCache().getPreCache().addProvider(cacheProvider);
        this.getTileCache().getPreCache().addProvider(archiveProvider);
        this.getTileCache().getProtectedTileContainers().add(this);
    }

    @Override
    public IFilesystemCache getTileWriter() {
        return this.tileWriter;
    }

    @Override
    public void detach() {
        if (this.tileWriter != null) {
            this.tileWriter.onDetach();
        }
        this.tileWriter = null;
        super.detach();
    }

    @Override
    protected boolean isDowngradedMode() {
        return this.mNetworkAvailabilityCheck != null && !this.mNetworkAvailabilityCheck.getNetworkAvailable() || !this.useDataConnection();
    }
}

