/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.KeyEvent;
import android.view.MotionEvent;
import java.util.concurrent.atomic.AtomicInteger;
import org.osmdroid.api.IMapView;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.views.MapView;
import org.osmdroid.views.util.constants.OverlayConstants;

public abstract class Overlay
implements OverlayConstants {
    private static AtomicInteger sOrdinal = new AtomicInteger();
    protected static final float SHADOW_X_SKEW = -0.9f;
    protected static final float SHADOW_Y_SCALE = 0.5f;
    private static final Rect mRect = new Rect();
    private boolean mEnabled = true;
    protected BoundingBox mBounds = new BoundingBox(85.05112877980659, 180.0, -85.05112877980659, -180.0);

    @Deprecated
    public Overlay(Context ctx) {
    }

    public Overlay() {
    }

    public BoundingBox getBounds() {
        return this.mBounds;
    }

    public void setEnabled(boolean pEnabled) {
        this.mEnabled = pEnabled;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    protected static final int getSafeMenuId() {
        return sOrdinal.getAndIncrement();
    }

    protected static final int getSafeMenuIdSequence(int count) {
        return sOrdinal.getAndAdd(count);
    }

    public abstract void draw(Canvas var1, MapView var2, boolean var3);

    public void onDetach(MapView mapView) {
    }

    public boolean onKeyDown(int keyCode, KeyEvent event, MapView mapView) {
        return false;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event, MapView mapView) {
        return false;
    }

    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        return false;
    }

    public boolean onTrackballEvent(MotionEvent event, MapView mapView) {
        return false;
    }

    public boolean onDoubleTap(MotionEvent e, MapView mapView) {
        return false;
    }

    public boolean onDoubleTapEvent(MotionEvent e, MapView mapView) {
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent e, MapView mapView) {
        return false;
    }

    public boolean onDown(MotionEvent e, MapView mapView) {
        return false;
    }

    public boolean onFling(MotionEvent pEvent1, MotionEvent pEvent2, float pVelocityX, float pVelocityY, MapView pMapView) {
        return false;
    }

    public boolean onLongPress(MotionEvent e, MapView mapView) {
        return false;
    }

    public boolean onScroll(MotionEvent pEvent1, MotionEvent pEvent2, float pDistanceX, float pDistanceY, MapView pMapView) {
        return false;
    }

    public void onShowPress(MotionEvent pEvent, MapView pMapView) {
    }

    public boolean onSingleTapUp(MotionEvent e, MapView mapView) {
        return false;
    }

    protected static synchronized void drawAt(Canvas canvas, Drawable drawable2, int x, int y, boolean shadow, float aMapOrientation) {
        canvas.save();
        canvas.rotate(-aMapOrientation, (float)x, (float)y);
        drawable2.copyBounds(mRect);
        drawable2.setBounds(Overlay.mRect.left + x, Overlay.mRect.top + y, Overlay.mRect.right + x, Overlay.mRect.bottom + y);
        drawable2.draw(canvas);
        drawable2.setBounds(mRect);
        canvas.restore();
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public static interface Snappable {
        public boolean onSnapToItem(int var1, int var2, Point var3, IMapView var4);
    }
}

