/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.Counters;
import org.osmdroid.tileprovider.util.StreamUtils;
import org.osmdroid.util.MapTileIndex;

public class TileWriter
implements IFilesystemCache {
    private static long mUsedCacheSpace;
    static boolean hasInited;
    Thread initThread = null;
    private long mMaximumCachedFileAge;

    public TileWriter() {
        if (!hasInited) {
            hasInited = true;
            this.initThread = new Thread(){

                @Override
                public void run() {
                    mUsedCacheSpace = 0L;
                    TileWriter.this.calculateDirectorySize(Configuration.getInstance().getOsmdroidTileCache());
                    if (mUsedCacheSpace > Configuration.getInstance().getTileFileSystemCacheMaxBytes()) {
                        TileWriter.this.cutCurrentCache();
                    }
                    if (Configuration.getInstance().isDebugMode()) {
                        Log.d((String)"OsmDroid", (String)"Finished init thread");
                    }
                }
            };
            this.initThread.setPriority(1);
            this.initThread.start();
        }
    }

    public static long getUsedCacheSpace() {
        return mUsedCacheSpace;
    }

    public void setMaximumCachedFileAge(long mMaximumCachedFileAge) {
        this.mMaximumCachedFileAge = mMaximumCachedFileAge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean saveFile(ITileSource pTileSource, long pMapTileIndex, InputStream pStream, Long pExpirationTime) {
        File parent;
        File file = this.getFile(pTileSource, pMapTileIndex);
        if (Configuration.getInstance().isDebugTileProviders()) {
            Log.d((String)"OsmDroid", (String)("TileWrite " + file.getAbsolutePath()));
        }
        if (!(parent = file.getParentFile()).exists() && !this.createFolderAndCheckIfExists(parent)) {
            return false;
        }
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file.getPath()), 8192);
            long length = StreamUtils.copy(pStream, outputStream);
            if ((mUsedCacheSpace += length) > Configuration.getInstance().getTileFileSystemCacheMaxBytes()) {
                this.cutCurrentCache();
            }
            if (outputStream == null) return true;
        }
        catch (IOException e) {
            boolean bl;
            try {
                ++Counters.fileCacheSaveErrors;
                bl = false;
                if (outputStream == null) return bl;
            }
            catch (Throwable throwable) {
                if (outputStream == null) throw throwable;
                StreamUtils.closeStream(outputStream);
                throw throwable;
            }
            StreamUtils.closeStream(outputStream);
            return bl;
        }
        StreamUtils.closeStream(outputStream);
        return true;
    }

    @Override
    public void onDetach() {
        if (this.initThread != null) {
            try {
                this.initThread.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean remove(ITileSource pTileSource, long pMapTileIndex) {
        File file = this.getFile(pTileSource, pMapTileIndex);
        if (file.exists()) {
            try {
                return file.delete();
            }
            catch (Exception ex) {
                Log.i((String)"OsmDroid", (String)("Unable to delete cached tile from " + pTileSource.name() + " " + MapTileIndex.toString(pMapTileIndex)), (Throwable)ex);
            }
        }
        return false;
    }

    public File getFile(ITileSource pTileSource, long pMapTileIndex) {
        return new File(Configuration.getInstance().getOsmdroidTileCache(), pTileSource.getTileRelativeFilenameString(pMapTileIndex) + ".tile");
    }

    @Override
    public boolean exists(ITileSource pTileSource, long pMapTileIndex) {
        return this.getFile(pTileSource, pMapTileIndex).exists();
    }

    private boolean createFolderAndCheckIfExists(File pFile) {
        if (pFile.mkdirs()) {
            return true;
        }
        if (Configuration.getInstance().isDebugMode()) {
            Log.d((String)"OsmDroid", (String)("Failed to create " + pFile + " - wait and check again"));
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (pFile.exists()) {
            if (Configuration.getInstance().isDebugMode()) {
                Log.d((String)"OsmDroid", (String)("Seems like another thread created " + pFile));
            }
            return true;
        }
        if (Configuration.getInstance().isDebugMode()) {
            Log.d((String)"OsmDroid", (String)("File still doesn't exist: " + pFile));
        }
        return false;
    }

    private void calculateDirectorySize(File pDirectory) {
        File[] z = pDirectory.listFiles();
        if (z != null) {
            for (File file : z) {
                if (file.isFile()) {
                    mUsedCacheSpace += file.length();
                }
                if (!file.isDirectory() || this.isSymbolicDirectoryLink(pDirectory, file)) continue;
                this.calculateDirectorySize(file);
            }
        }
    }

    private boolean isSymbolicDirectoryLink(File pParentDirectory, File pDirectory) {
        try {
            String canonicalParentPath1 = pParentDirectory.getCanonicalPath();
            String canonicalParentPath2 = pDirectory.getCanonicalFile().getParent();
            return !canonicalParentPath1.equals(canonicalParentPath2);
        }
        catch (IOException e) {
            return true;
        }
        catch (NoSuchElementException e) {
            return true;
        }
    }

    private List<File> getDirectoryFileList(File aDirectory) {
        ArrayList<File> files = new ArrayList<File>();
        File[] z = aDirectory.listFiles();
        if (z != null) {
            for (File file : z) {
                if (file.isFile()) {
                    files.add(file);
                }
                if (!file.isDirectory()) continue;
                files.addAll(this.getDirectoryFileList(file));
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cutCurrentCache() {
        File lock;
        File file = lock = Configuration.getInstance().getOsmdroidTileCache();
        synchronized (file) {
            if (mUsedCacheSpace > Configuration.getInstance().getTileFileSystemCacheTrimBytes()) {
                Log.d((String)"OsmDroid", (String)("Trimming tile cache from " + mUsedCacheSpace + " to " + Configuration.getInstance().getTileFileSystemCacheTrimBytes()));
                List<File> z = this.getDirectoryFileList(Configuration.getInstance().getOsmdroidTileCache());
                File[] files = z.toArray(new File[0]);
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                    }
                });
                for (File file2 : files) {
                    if (mUsedCacheSpace <= Configuration.getInstance().getTileFileSystemCacheTrimBytes()) break;
                    long length = file2.length();
                    if (!file2.delete()) continue;
                    if (Configuration.getInstance().isDebugTileProviders()) {
                        Log.d((String)"OsmDroid", (String)("Cache trim deleting " + file2.getAbsolutePath()));
                    }
                    mUsedCacheSpace -= length;
                }
                Log.d((String)"OsmDroid", (String)"Finished trimming tile cache");
            }
        }
    }

    @Override
    public Long getExpirationTimestamp(ITileSource pTileSource, long pMapTileIndex) {
        return null;
    }

    @Override
    public Drawable loadTile(ITileSource pTileSource, long pMapTileIndex) throws Exception {
        boolean fileExpired;
        File file = this.getFile(pTileSource, pMapTileIndex);
        if (!file.exists()) {
            return null;
        }
        Drawable drawable = pTileSource.getDrawable(file.getPath());
        long now = System.currentTimeMillis();
        long lastModified = file.lastModified();
        boolean bl = fileExpired = lastModified < now - this.mMaximumCachedFileAge;
        if (fileExpired && drawable != null) {
            if (Configuration.getInstance().isDebugMode()) {
                Log.d((String)"OsmDroid", (String)("Tile expired: " + MapTileIndex.toString(pMapTileIndex)));
            }
            ExpirableBitmapDrawable.setState(drawable, -2);
        }
        return drawable;
    }

    static {
        hasInited = false;
    }
}

