/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.drawable.Drawable;
import android.util.Log;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.BitmapPool;
import org.osmdroid.util.MapTileIndex;
import org.osmdroid.util.MapTileList;

@Deprecated
public class LRUMapTileCache
extends LinkedHashMap<Long, Drawable> {
    private static final long serialVersionUID = -541142277575493335L;
    private final MapTileList mMapTileList;
    private int mCapacity;
    private TileRemovedListener mTileRemovedListener;

    public LRUMapTileCache(int aCapacity, MapTileList pMapTileList) {
        super(aCapacity + 2, 0.1f, true);
        this.mCapacity = aCapacity;
        this.mMapTileList = pMapTileList;
    }

    public void ensureCapacity(int aCapacity) {
        if (aCapacity > this.mCapacity) {
            Log.i((String)"OsmDroid", (String)("Tile cache increased from " + this.mCapacity + " to " + aCapacity));
            this.mCapacity = aCapacity;
        }
    }

    @Override
    public Drawable remove(Object aKey) {
        Drawable drawable = (Drawable)super.remove(aKey);
        BitmapPool.getInstance().asyncRecycle(drawable);
        if (this.getTileRemovedListener() != null && aKey != null) {
            this.getTileRemovedListener().onTileRemoved((Long)aKey);
        }
        return drawable;
    }

    @Override
    public void clear() {
        while (!this.isEmpty()) {
            try {
                this.remove(this.keySet().iterator().next());
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        super.clear();
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<Long, Drawable> aEldest) {
        long index = aEldest.getKey();
        if (this.mMapTileList.contains(index)) {
            return false;
        }
        if (this.size() <= this.mCapacity) {
            return false;
        }
        if (Configuration.getInstance().isDebugMode()) {
            Log.d((String)"OsmDroid", (String)("LRU Remove old tile: " + MapTileIndex.toString(index)));
        }
        return true;
    }

    public TileRemovedListener getTileRemovedListener() {
        return this.mTileRemovedListener;
    }

    public void setTileRemovedListener(TileRemovedListener tileRemovedListener) {
        this.mTileRemovedListener = tileRemovedListener;
    }

    public static interface TileRemovedListener {
        public void onTileRemoved(long var1);
    }
}

