/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.simplefastpoint;

import android.graphics.Canvas;
import android.graphics.Point;
import android.view.MotionEvent;
import java.util.Arrays;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.simplefastpoint.LabelledGeoPoint;
import org.osmdroid.views.overlay.simplefastpoint.SimpleFastPointOverlayOptions;

public class SimpleFastPointOverlay
extends Overlay {
    private final SimpleFastPointOverlayOptions mStyle;
    private final PointAdapter mPointList;
    private final BoundingBox mBoundingBox;
    private Integer mSelectedPoint;
    private OnClickListener clickListener;
    private LabelledPoint[][] grid;
    private boolean[][] gridBool;
    private int gridWid;
    private int gridHei;
    private int viewWid;
    private int viewHei;
    private float startX;
    private float startY;
    private float curX;
    private float curY;
    private float offsetX;
    private float offsetY;
    private int prevNumPointers;
    private int numLabels;
    private BoundingBox prevBoundingBox = new BoundingBox(0.0, 0.0, 0.0, 0.0);

    public SimpleFastPointOverlay(PointAdapter pointList, SimpleFastPointOverlayOptions style) {
        this.mStyle = style;
        this.mPointList = pointList;
        Double east = null;
        Double west = null;
        Double north = null;
        Double south = null;
        for (IGeoPoint p : this.mPointList) {
            if (p == null) continue;
            if (east == null || p.getLongitude() > east) {
                east = p.getLongitude();
            }
            if (west == null || p.getLongitude() < west) {
                west = p.getLongitude();
            }
            if (north == null || p.getLatitude() > north) {
                north = p.getLatitude();
            }
            if (south != null && !(p.getLatitude() < south)) continue;
            south = p.getLatitude();
        }
        this.mBoundingBox = east != null ? new BoundingBox(north, east, south, west) : null;
    }

    public SimpleFastPointOverlay(PointAdapter pointList) {
        this(pointList, SimpleFastPointOverlayOptions.getDefaultStyle());
    }

    private void updateGrid(MapView mapView) {
        this.viewWid = mapView.getWidth();
        this.viewHei = mapView.getHeight();
        this.gridWid = (int)Math.floor((float)this.viewWid / (float)this.mStyle.mCellSize) + 1;
        this.gridHei = (int)Math.floor((float)this.viewHei / (float)this.mStyle.mCellSize) + 1;
        if (this.mStyle.mAlgorithm == SimpleFastPointOverlayOptions.RenderingAlgorithm.MAXIMUM_OPTIMIZATION) {
            this.grid = new LabelledPoint[this.gridWid][this.gridHei];
        } else {
            this.gridBool = new boolean[this.gridWid][this.gridHei];
        }
    }

    private void computeGrid(MapView pMapView) {
        BoundingBox viewBBox = pMapView.getBoundingBox();
        if (viewBBox.getLatNorth() != this.prevBoundingBox.getLatNorth() || viewBBox.getLatSouth() != this.prevBoundingBox.getLatSouth() || viewBBox.getLonWest() != this.prevBoundingBox.getLonWest() || viewBBox.getLonEast() != this.prevBoundingBox.getLonEast()) {
            this.prevBoundingBox = new BoundingBox(viewBBox.getLatNorth(), viewBBox.getLonEast(), viewBBox.getLatSouth(), viewBBox.getLonWest());
            if (this.grid == null || this.viewHei != pMapView.getHeight() || this.viewWid != pMapView.getWidth()) {
                this.updateGrid(pMapView);
            } else {
                for (LabelledPoint[] row : this.grid) {
                    Arrays.fill((Object[])row, null);
                }
            }
            Point mPositionPixels = new Point();
            Projection pj = pMapView.getProjection();
            this.numLabels = 0;
            for (IGeoPoint pt1 : this.mPointList) {
                if (pt1 == null || !(pt1.getLatitude() > viewBBox.getLatSouth()) || !(pt1.getLatitude() < viewBBox.getLatNorth()) || !(pt1.getLongitude() > viewBBox.getLonWest()) || !(pt1.getLongitude() < viewBBox.getLonEast())) continue;
                pj.toPixels(pt1, mPositionPixels);
                int gridX = (int)Math.floor((float)mPositionPixels.x / (float)this.mStyle.mCellSize);
                int gridY = (int)Math.floor((float)mPositionPixels.y / (float)this.mStyle.mCellSize);
                if (gridX >= this.gridWid || gridY >= this.gridHei || this.grid[gridX][gridY] != null) continue;
                this.grid[gridX][gridY] = new LabelledPoint(mPositionPixels, this.mPointList.isLabelled() ? ((LabelledGeoPoint)pt1).getLabel() : null);
                ++this.numLabels;
            }
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        if (this.mStyle.mAlgorithm != SimpleFastPointOverlayOptions.RenderingAlgorithm.MAXIMUM_OPTIMIZATION) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.prevNumPointers = event.getPointerCount();
                this.startX = event.getX(0);
                this.startY = event.getY(0);
                for (int i = 1; i < this.prevNumPointers; ++i) {
                    this.startX += event.getX(i);
                    this.startY += event.getY(i);
                }
                this.startX /= (float)this.prevNumPointers;
                this.startY /= (float)this.prevNumPointers;
                break;
            }
            case 2: {
                this.curX = event.getX(0);
                this.curY = event.getY(0);
                for (int i = 1; i < event.getPointerCount(); ++i) {
                    this.curX += event.getX(i);
                    this.curY += event.getY(i);
                }
                this.curX /= (float)event.getPointerCount();
                this.curY /= (float)event.getPointerCount();
                if (event.getPointerCount() == this.prevNumPointers) break;
                this.computeGrid(mapView);
                this.prevNumPointers = event.getPointerCount();
                this.offsetX = this.curX - this.startX;
                this.offsetY = this.curY - this.startY;
                break;
            }
            case 1: {
                this.startX = 0.0f;
                this.startY = 0.0f;
                this.curX = 0.0f;
                this.curY = 0.0f;
                this.offsetX = 0.0f;
                this.offsetY = 0.0f;
                mapView.invalidate();
            }
        }
        return false;
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        if (!this.mStyle.mClickable) {
            return false;
        }
        Float minHyp = null;
        int closest = -1;
        Point tmp = new Point();
        Projection pj = mapView.getProjection();
        for (int i = 0; i < this.mPointList.size(); ++i) {
            if (this.mPointList.get(i) == null) continue;
            pj.toPixels(this.mPointList.get(i), tmp);
            if (Math.abs(event.getX() - (float)tmp.x) > 50.0f || Math.abs(event.getY() - (float)tmp.y) > 50.0f) continue;
            float hyp = (event.getX() - (float)tmp.x) * (event.getX() - (float)tmp.x) + (event.getY() - (float)tmp.y) * (event.getY() - (float)tmp.y);
            if (minHyp != null && !(hyp < minHyp.floatValue())) continue;
            minHyp = Float.valueOf(hyp);
            closest = i;
        }
        if (minHyp == null) {
            return false;
        }
        this.setSelectedPoint(closest);
        mapView.invalidate();
        if (this.clickListener != null) {
            this.clickListener.onClick(this.mPointList, closest);
        }
        return true;
    }

    public void setSelectedPoint(Integer toSelect) {
        this.mSelectedPoint = toSelect == null || toSelect < 0 || toSelect >= this.mPointList.size() ? null : toSelect;
    }

    public Integer getSelectedPoint() {
        return this.mSelectedPoint;
    }

    public BoundingBox getBoundingBox() {
        return this.mBoundingBox;
    }

    public void setOnClickListener(OnClickListener listener) {
        this.clickListener = listener;
    }

    @Override
    public void draw(Canvas canvas, MapView mapView, boolean b) {
        if (b) {
            return;
        }
        Point mPositionPixels = new Point();
        Projection pj = mapView.getProjection();
        if (this.mStyle.mPointStyle != null) {
            switch (this.mStyle.mAlgorithm) {
                case MAXIMUM_OPTIMIZATION: {
                    if (this.grid == null || this.curX == 0.0f && this.curY == 0.0f && !mapView.isAnimating()) {
                        this.computeGrid(mapView);
                    }
                    boolean showLabels = this.mStyle.mLabelPolicy == SimpleFastPointOverlayOptions.LabelPolicy.DENSITY_THRESHOLD && this.numLabels <= this.mStyle.mMaxNShownLabels || this.mStyle.mLabelPolicy == SimpleFastPointOverlayOptions.LabelPolicy.ZOOM_THRESHOLD && mapView.getZoomLevel() >= this.mStyle.mMinZoomShowLabels;
                    float offX = this.curX - this.startX;
                    float offY = this.curY - this.startY;
                    for (int x = 0; x < this.gridWid; ++x) {
                        for (int y = 0; y < this.gridHei; ++y) {
                            String tmpLabel;
                            if (this.grid[x][y] == null) continue;
                            if (this.mStyle.mSymbol == SimpleFastPointOverlayOptions.Shape.CIRCLE) {
                                canvas.drawCircle((float)this.grid[x][y].x + offX - this.offsetX, (float)this.grid[x][y].y + offY - this.offsetY, this.mStyle.mCircleRadius, this.mStyle.mPointStyle);
                            } else {
                                canvas.drawRect((float)this.grid[x][y].x + offX - this.offsetX - this.mStyle.mCircleRadius, (float)this.grid[x][y].y + offY - this.offsetY - this.mStyle.mCircleRadius, (float)this.grid[x][y].x + offX - this.offsetX + this.mStyle.mCircleRadius, (float)this.grid[x][y].y + offY - this.offsetY + this.mStyle.mCircleRadius, this.mStyle.mPointStyle);
                            }
                            if (!this.mPointList.isLabelled() || !showLabels || (tmpLabel = this.grid[x][y].mlabel) == null) continue;
                            canvas.drawText(tmpLabel, (float)this.grid[x][y].x + offX - this.offsetX, (float)this.grid[x][y].y + offY - this.offsetY - this.mStyle.mCircleRadius - 5.0f, this.mStyle.mTextStyle);
                        }
                    }
                    break;
                }
                case MEDIUM_OPTIMIZATION: {
                    if (this.grid == null || this.viewHei != mapView.getHeight() || this.viewWid != mapView.getWidth()) {
                        this.updateGrid(mapView);
                    } else {
                        for (boolean[] row : this.gridBool) {
                            Arrays.fill(row, false);
                        }
                    }
                    boolean showLabels = this.mStyle.mLabelPolicy == SimpleFastPointOverlayOptions.LabelPolicy.ZOOM_THRESHOLD && mapView.getZoomLevel() >= this.mStyle.mMinZoomShowLabels;
                    BoundingBox viewBBox = mapView.getBoundingBox();
                    for (IGeoPoint pt1 : this.mPointList) {
                        String tmpLabel;
                        if (pt1 == null || !(pt1.getLatitude() > viewBBox.getLatSouth()) || !(pt1.getLatitude() < viewBBox.getLatNorth()) || !(pt1.getLongitude() > viewBBox.getLonWest()) || !(pt1.getLongitude() < viewBBox.getLonEast())) continue;
                        pj.toPixels(pt1, mPositionPixels);
                        int gridX = (int)Math.floor((float)mPositionPixels.x / (float)this.mStyle.mCellSize);
                        int gridY = (int)Math.floor((float)mPositionPixels.y / (float)this.mStyle.mCellSize);
                        if (gridX >= this.gridWid || gridY >= this.gridHei || this.gridBool[gridX][gridY]) continue;
                        this.gridBool[gridX][gridY] = true;
                        if (this.mStyle.mSymbol == SimpleFastPointOverlayOptions.Shape.CIRCLE) {
                            canvas.drawCircle((float)mPositionPixels.x, (float)mPositionPixels.y, this.mStyle.mCircleRadius, this.mStyle.mPointStyle);
                        } else {
                            canvas.drawRect((float)mPositionPixels.x - this.mStyle.mCircleRadius, (float)mPositionPixels.y - this.mStyle.mCircleRadius, (float)mPositionPixels.x + this.mStyle.mCircleRadius, (float)mPositionPixels.y + this.mStyle.mCircleRadius, this.mStyle.mPointStyle);
                        }
                        if (!this.mPointList.isLabelled() || !showLabels || (tmpLabel = ((LabelledGeoPoint)pt1).getLabel()) == null) continue;
                        canvas.drawText(tmpLabel, (float)mPositionPixels.x, (float)mPositionPixels.y - this.mStyle.mCircleRadius - 5.0f, this.mStyle.mTextStyle);
                    }
                    break;
                }
                case NO_OPTIMIZATION: {
                    boolean showLabels = this.mStyle.mLabelPolicy == SimpleFastPointOverlayOptions.LabelPolicy.ZOOM_THRESHOLD && mapView.getZoomLevel() >= this.mStyle.mMinZoomShowLabels;
                    BoundingBox viewBBox = mapView.getBoundingBox();
                    for (IGeoPoint pt1 : this.mPointList) {
                        String tmpLabel;
                        if (pt1 == null || !(pt1.getLatitude() > viewBBox.getLatSouth()) || !(pt1.getLatitude() < viewBBox.getLatNorth()) || !(pt1.getLongitude() > viewBBox.getLonWest()) || !(pt1.getLongitude() < viewBBox.getLonEast())) continue;
                        pj.toPixels(pt1, mPositionPixels);
                        if (this.mStyle.mSymbol == SimpleFastPointOverlayOptions.Shape.CIRCLE) {
                            canvas.drawCircle((float)mPositionPixels.x, (float)mPositionPixels.y, this.mStyle.mCircleRadius, this.mStyle.mPointStyle);
                        } else {
                            canvas.drawRect((float)mPositionPixels.x - this.mStyle.mCircleRadius, (float)mPositionPixels.y - this.mStyle.mCircleRadius, (float)mPositionPixels.x + this.mStyle.mCircleRadius, (float)mPositionPixels.y + this.mStyle.mCircleRadius, this.mStyle.mPointStyle);
                        }
                        if (!this.mPointList.isLabelled() || !showLabels || (tmpLabel = ((LabelledGeoPoint)pt1).getLabel()) == null) continue;
                        canvas.drawText(tmpLabel, (float)mPositionPixels.x, (float)mPositionPixels.y - this.mStyle.mCircleRadius - 5.0f, this.mStyle.mTextStyle);
                    }
                    break;
                }
            }
        }
        if (this.mSelectedPoint != null && this.mSelectedPoint < this.mPointList.size() && this.mPointList.get(this.mSelectedPoint) != null && this.mStyle.mSelectedPointStyle != null) {
            pj.toPixels(this.mPointList.get(this.mSelectedPoint), mPositionPixels);
            if (this.mStyle.mSymbol == SimpleFastPointOverlayOptions.Shape.CIRCLE) {
                canvas.drawCircle((float)mPositionPixels.x, (float)mPositionPixels.y, this.mStyle.mSelectedCircleRadius, this.mStyle.mSelectedPointStyle);
            } else {
                canvas.drawRect((float)mPositionPixels.x - this.mStyle.mSelectedCircleRadius, (float)mPositionPixels.y - this.mStyle.mSelectedCircleRadius, (float)mPositionPixels.x + this.mStyle.mSelectedCircleRadius, (float)mPositionPixels.y + this.mStyle.mSelectedCircleRadius, this.mStyle.mSelectedPointStyle);
            }
        }
    }

    public static interface OnClickListener {
        public void onClick(PointAdapter var1, Integer var2);
    }

    public static interface PointAdapter
    extends Iterable<IGeoPoint> {
        public int size();

        public IGeoPoint get(int var1);

        public boolean isLabelled();
    }

    public class LabelledPoint
    extends Point {
        private String mlabel;

        public LabelledPoint(Point point, String label) {
            super(point);
            this.mlabel = label;
        }
    }
}

