/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.util.concurrent.atomic.AtomicReference;
import microsoft.mappoint.TileSystem;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.modules.MapTileFileStorageProviderBase;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.modules.SqlTileWriter;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.StreamUtils;

public class MapTileSqlCacheProvider
extends MapTileFileStorageProviderBase {
    private final AtomicReference<ITileSource> mTileSource = new AtomicReference();
    private SqlTileWriter mWriter;
    private final long mMaximumCachedFileAge;
    private static final String[] tile = new String[]{"tile"};
    private static final String[] columns = new String[]{"tile", "expires"};

    public MapTileSqlCacheProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource, long pMaximumCachedFileAge) {
        super(pRegisterReceiver, Configuration.getInstance().getTileFileSystemThreads(), Configuration.getInstance().getTileFileSystemMaxQueueSize());
        this.setTileSource(pTileSource);
        this.mMaximumCachedFileAge = pMaximumCachedFileAge;
        this.mWriter = new SqlTileWriter();
    }

    public MapTileSqlCacheProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource) {
        this(pRegisterReceiver, pTileSource, 604800000L);
    }

    @Override
    public boolean getUsesDataConnection() {
        return false;
    }

    @Override
    protected String getName() {
        return "SQL Cache Archive Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "sqlcache";
    }

    @Override
    protected Runnable getTileLoader() {
        return new TileLoader();
    }

    @Override
    public int getMinimumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMinimumZoomLevel() : 0;
    }

    @Override
    public int getMaximumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMaximumZoomLevel() : TileSystem.getMaximumZoomLevel();
    }

    @Override
    protected void onMediaMounted() {
    }

    @Override
    protected void onMediaUnmounted() {
        if (this.mWriter != null) {
            this.mWriter.onDetach();
        }
        this.mWriter = new SqlTileWriter();
    }

    @Override
    public void setTileSource(ITileSource pTileSource) {
        this.mTileSource.set(pTileSource);
    }

    @Override
    public void detach() {
        if (this.mWriter != null) {
            this.mWriter.onDetach();
        }
        this.mWriter = null;
        super.detach();
    }

    public boolean hasTile(MapTile pTile) {
        ITileSource tileSource = this.mTileSource.get();
        if (tileSource == null) {
            return false;
        }
        long x = pTile.getX();
        long y = pTile.getY();
        long z = pTile.getZoomLevel();
        long index = ((z << (int)z) + x << (int)z) + y;
        Cursor cur = this.mWriter.db.query("tiles", columns, "key = " + index + " and provider = '" + tileSource.name() + "'", null, null, null, null);
        if (cur.getCount() != 0) {
            cur.close();
            return true;
        }
        return false;
    }

    protected class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        protected TileLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Drawable loadTile(MapTileRequestState pState) {
            block19: {
                Drawable drawable;
                block18: {
                    long lastModified;
                    byte[] bits;
                    ByteArrayInputStream inputStream;
                    ITileSource tileSource;
                    block16: {
                        Drawable drawable2;
                        block17: {
                            tileSource = (ITileSource)MapTileSqlCacheProvider.this.mTileSource.get();
                            if (tileSource == null) {
                                return null;
                            }
                            MapTile pTile = pState.getMapTile();
                            if (!MapTileFileStorageProviderBase.isSdCardAvailable()) {
                                if (Configuration.getInstance().isDebugMode()) {
                                    Log.d((String)"OsmDroid", (String)("No sdcard - do nothing for tile: " + pTile));
                                }
                                return null;
                            }
                            if (MapTileSqlCacheProvider.this.mWriter == null || ((MapTileSqlCacheProvider)MapTileSqlCacheProvider.this).mWriter.db == null) {
                                if (Configuration.getInstance().isDebugMode()) {
                                    Log.d((String)"OsmDroid", (String)("Sqlwriter cache is offline - do nothing for tile: " + pTile));
                                }
                                return null;
                            }
                            inputStream = null;
                            if (Configuration.getInstance().isDebugMode()) {
                                Log.d((String)"OsmDroid", (String)("Tile doesn't exist: " + pTile));
                            }
                            long x = pTile.getX();
                            long y = pTile.getY();
                            long z = pTile.getZoomLevel();
                            long index = ((z << (int)z) + x << (int)z) + y;
                            Cursor cur = ((MapTileSqlCacheProvider)MapTileSqlCacheProvider.this).mWriter.db.query("tiles", columns, "key = " + index + " and provider = '" + tileSource.name() + "'", null, null, null, null);
                            bits = null;
                            lastModified = 0L;
                            if (cur.getCount() != 0) {
                                cur.moveToFirst();
                                bits = cur.getBlob(cur.getColumnIndex("tile"));
                                lastModified = cur.getLong(cur.getColumnIndex("expires"));
                            }
                            cur.close();
                            if (bits != null) break block16;
                            drawable2 = null;
                            if (inputStream == null) break block17;
                            StreamUtils.closeStream(inputStream);
                        }
                        return drawable2;
                    }
                    try {
                        boolean fileExpired;
                        inputStream = new ByteArrayInputStream(bits);
                        Drawable drawable3 = tileSource.getDrawable(inputStream);
                        long now = System.currentTimeMillis();
                        boolean bl = fileExpired = lastModified < now - MapTileSqlCacheProvider.this.mMaximumCachedFileAge;
                        if (fileExpired && drawable3 != null) {
                            if (Configuration.getInstance().isDebugMode()) {
                                Log.d((String)"OsmDroid", (String)("Tile expired: " + tile));
                            }
                            ExpirableBitmapDrawable.setDrawableExpired(drawable3);
                        }
                        drawable = drawable3;
                        if (inputStream == null) break block18;
                    }
                    catch (Throwable e) {
                        try {
                            Log.e((String)"OsmDroid", (String)"Error loading tile", (Throwable)e);
                            break block19;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (inputStream != null) {
                                StreamUtils.closeStream(inputStream);
                            }
                        }
                    }
                    StreamUtils.closeStream(inputStream);
                }
                return drawable;
            }
            return null;
        }
    }
}

