/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;
import microsoft.mappoint.TileSystem;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.OverlayWithIW;

public class Polyline
extends OverlayWithIW {
    private double[][] mOriginalPoints;
    protected boolean mGeodesic;
    protected Paint mPaint = new Paint();
    private ArrayList<Point> mPoints;
    private int mPointsPrecomputed;
    public boolean mRepeatPath = false;
    private float[] mPts = null;
    private final Rect mClipRect = new Rect();
    private final Rect mLineBounds = new Rect();
    private final Point mTempPoint1 = new Point();
    private final Point mTempPoint2 = new Point();
    protected OnClickListener mOnClickListener;

    @Deprecated
    public Polyline(Context ctx) {
        this();
    }

    public Polyline() {
        this.mPaint.setColor(-16777216);
        this.mPaint.setStrokeWidth(10.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setAntiAlias(true);
        this.clearPath();
        this.mOriginalPoints = new double[0][2];
        this.mGeodesic = false;
    }

    protected void clearPath() {
        this.mPoints = new ArrayList();
        this.mPointsPrecomputed = 0;
        this.mPts = null;
    }

    protected void addPoint(GeoPoint aPoint) {
        this.addPoint(aPoint.getLatitudeE6(), aPoint.getLongitudeE6());
    }

    protected void addPoint(int aLatitudeE6, int aLongitudeE6) {
        this.mPoints.add(new Point(aLatitudeE6, aLongitudeE6));
    }

    public List<GeoPoint> getPoints() {
        ArrayList<GeoPoint> result = new ArrayList<GeoPoint>(this.mOriginalPoints.length);
        for (int i = 0; i < this.mOriginalPoints.length; ++i) {
            GeoPoint gp = new GeoPoint(this.mOriginalPoints[i][0], this.mOriginalPoints[i][1]);
            result.add(gp);
        }
        return result;
    }

    public int getNumberOfPoints() {
        return this.mOriginalPoints.length;
    }

    public int getColor() {
        return this.mPaint.getColor();
    }

    public float getWidth() {
        return this.mPaint.getStrokeWidth();
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public boolean isVisible() {
        return this.isEnabled();
    }

    public boolean isGeodesic() {
        return this.mGeodesic;
    }

    public void setColor(int color) {
        this.mPaint.setColor(color);
    }

    public void setWidth(float width) {
        this.mPaint.setStrokeWidth(width);
    }

    public void setVisible(boolean visible) {
        this.setEnabled(visible);
    }

    public void setOnClickListener(OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    protected void addGreatCircle(GeoPoint startPoint, GeoPoint endPoint, int numberOfPoints) {
        double lat1 = startPoint.getLatitude() * 0.01745329238474369;
        double lon1 = startPoint.getLongitude() * 0.01745329238474369;
        double lat2 = endPoint.getLatitude() * 0.01745329238474369;
        double lon2 = endPoint.getLongitude() * 0.01745329238474369;
        double d = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
        double bearing = Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2)) / -0.01745329238474369;
        bearing = bearing < 0.0 ? 360.0 + bearing : bearing;
        for (int i = 1; i <= numberOfPoints; ++i) {
            double f = 1.0 * (double)i / (double)(numberOfPoints + 1);
            double A = Math.sin((1.0 - f) * d) / Math.sin(d);
            double B = Math.sin(f * d) / Math.sin(d);
            double x = A * Math.cos(lat1) * Math.cos(lon1) + B * Math.cos(lat2) * Math.cos(lon2);
            double y = A * Math.cos(lat1) * Math.sin(lon1) + B * Math.cos(lat2) * Math.sin(lon2);
            double z = A * Math.sin(lat1) + B * Math.sin(lat2);
            double latN = Math.atan2(z, Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)));
            double lonN = Math.atan2(y, x);
            this.addPoint((int)(latN * (double)57.29578f * 1000000.0), (int)(lonN * (double)57.29578f * 1000000.0));
        }
    }

    public void setPoints(List<GeoPoint> points) {
        this.clearPath();
        int size = points.size();
        this.mOriginalPoints = new double[size][2];
        for (int i = 0; i < size; ++i) {
            GeoPoint p = points.get(i);
            this.mOriginalPoints[i][0] = p.getLatitude();
            this.mOriginalPoints[i][1] = p.getLongitude();
            if (!this.mGeodesic) {
                this.addPoint(p);
                continue;
            }
            if (i > 0) {
                GeoPoint prev = points.get(i - 1);
                int greatCircleLength = prev.distanceTo(p);
                int numberOfPoints = greatCircleLength / 100000;
                this.addGreatCircle(prev, p, numberOfPoints);
            }
            this.addPoint(p);
        }
    }

    public void setGeodesic(boolean geodesic) {
        this.mGeodesic = geodesic;
    }

    protected void precomputePoints(Projection pj) {
        int size = this.mPoints.size();
        while (this.mPointsPrecomputed < size) {
            Point pt = this.mPoints.get(this.mPointsPrecomputed);
            pj.toProjectedPixels(pt.x, pt.y, pt);
            ++this.mPointsPrecomputed;
        }
    }

    @Override
    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        int size = this.mPoints.size();
        if (size < 2) {
            return;
        }
        Projection pj = mapView.getProjection();
        int halfMapSize = TileSystem.MapSize(mapView.getProjection().getZoomLevel()) / 2;
        int southLimit = pj.toPixelsFromMercator((int)0, (int)(halfMapSize * 2), null).y;
        this.precomputePoints(pj);
        if (this.mPts == null || this.mPts.length < size) {
            this.mPts = new float[Math.max(256, 2 * size)];
        }
        int j = 0;
        Point projectedPoint0 = this.mPoints.get(0);
        Point screenPoint0 = pj.toPixelsFromProjected(projectedPoint0, this.mTempPoint1);
        mapView.getScreenRect(this.mClipRect);
        for (int i = 1; i < size; ++i) {
            Point projectedPoint1 = this.mPoints.get(i);
            Point screenPoint1 = pj.toPixelsFromProjected(projectedPoint1, this.mTempPoint2);
            if (Math.abs(screenPoint1.x - screenPoint0.x) + Math.abs(screenPoint1.y - screenPoint0.y) <= 1) continue;
            if (screenPoint0.x < this.mClipRect.left && screenPoint1.x < this.mClipRect.left || screenPoint0.x > this.mClipRect.right && screenPoint1.x > this.mClipRect.right || screenPoint0.y < this.mClipRect.top && screenPoint1.y < this.mClipRect.top || screenPoint0.y > this.mClipRect.bottom && screenPoint1.y > this.mClipRect.bottom) {
                screenPoint0.x = screenPoint1.x;
                screenPoint0.y = screenPoint1.y;
                continue;
            }
            if (Math.abs(screenPoint1.x - screenPoint0.x) > halfMapSize || screenPoint1.y >= southLimit != screenPoint0.y >= southLimit) {
                int x0 = screenPoint0.x;
                int y0 = screenPoint0.y;
                int x1 = screenPoint1.x;
                int y1 = screenPoint1.y;
                if (Math.abs(screenPoint1.x - screenPoint0.x) > halfMapSize) {
                    if (screenPoint1.x < mapView.getWidth() / 2) {
                        x1 += halfMapSize * 2;
                        x0 -= halfMapSize * 2;
                    } else {
                        x1 -= halfMapSize * 2;
                        x0 += halfMapSize * 2;
                    }
                }
                if (screenPoint1.y >= southLimit != screenPoint0.y >= southLimit) {
                    if (screenPoint1.y >= southLimit) {
                        y1 -= halfMapSize * 2;
                        y0 += halfMapSize * 2;
                    } else {
                        y1 += halfMapSize * 2;
                        y0 -= halfMapSize * 2;
                    }
                }
                if (j + 4 > this.mPts.length) {
                    canvas.drawLines(this.mPts, 0, j, this.mPaint);
                    j = 0;
                }
                this.mPts[j++] = screenPoint0.x;
                this.mPts[j++] = screenPoint0.y;
                this.mPts[j++] = x1;
                this.mPts[j++] = y1;
                screenPoint0.x = x0;
                screenPoint0.y = y0;
            }
            if (j + 4 > this.mPts.length) {
                canvas.drawLines(this.mPts, 0, j, this.mPaint);
                j = 0;
            }
            this.mPts[j++] = screenPoint0.x;
            this.mPts[j++] = screenPoint0.y;
            this.mPts[j++] = screenPoint1.x;
            this.mPts[j++] = screenPoint1.y;
            screenPoint0.x = screenPoint1.x;
            screenPoint0.y = screenPoint1.y;
        }
        if (j > 0) {
            canvas.drawLines(this.mPts, 0, j, this.mPaint);
        }
    }

    public boolean isCloseTo(GeoPoint point, double tolerance, MapView mapView) {
        Projection pj = mapView.getProjection();
        this.precomputePoints(pj);
        Point p = pj.toPixels(point, null);
        boolean found = false;
        for (int i = 0; i < this.mPointsPrecomputed - 1 && !found; ++i) {
            Point projectedPoint1 = this.mPoints.get(i);
            if (i == 0) {
                pj.toPixelsFromProjected(projectedPoint1, this.mTempPoint1);
            } else {
                this.mTempPoint1.set(this.mTempPoint2.x, this.mTempPoint2.y);
            }
            Point projectedPoint2 = this.mPoints.get(i + 1);
            pj.toPixelsFromProjected(projectedPoint2, this.mTempPoint2);
            found = this.linePointDist(this.mTempPoint1, this.mTempPoint2, p, true) <= tolerance;
        }
        return found;
    }

    private double dot(Point A, Point B, Point C) {
        double AB_X = B.x - A.x;
        double AB_Y = B.y - A.y;
        double BC_X = C.x - B.x;
        double BC_Y = C.y - B.y;
        double dot = AB_X * BC_X + AB_Y * BC_Y;
        return dot;
    }

    private double cross(Point A, Point B, Point C) {
        double AB_X = B.x - A.x;
        double AB_Y = B.y - A.y;
        double AC_X = C.x - A.x;
        double AC_Y = C.y - A.y;
        double cross = AB_X * AC_Y - AB_Y * AC_X;
        return cross;
    }

    private double distance(Point A, Point B) {
        double dX = A.x - B.x;
        double dY = A.y - B.y;
        return Math.sqrt(dX * dX + dY * dY);
    }

    private double linePointDist(Point A, Point B, Point C, boolean isSegment) {
        double dAB = this.distance(A, B);
        if (dAB == 0.0) {
            return this.distance(A, C);
        }
        double dist = this.cross(A, B, C) / dAB;
        if (isSegment) {
            double dot1 = this.dot(A, B, C);
            if (dot1 > 0.0) {
                return this.distance(B, C);
            }
            double dot2 = this.dot(B, A, C);
            if (dot2 > 0.0) {
                return this.distance(A, C);
            }
        }
        return Math.abs(dist);
    }

    public void showInfoWindow(GeoPoint position) {
        if (this.mInfoWindow == null) {
            return;
        }
        this.mInfoWindow.open(this, position, 0, 0);
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        double tolerance;
        Projection pj = mapView.getProjection();
        GeoPoint eventPos = (GeoPoint)pj.fromPixels((int)event.getX(), (int)event.getY());
        boolean touched = this.isCloseTo(eventPos, tolerance = (double)this.mPaint.getStrokeWidth(), mapView);
        if (touched) {
            if (this.mOnClickListener == null) {
                return this.onClickDefault(this, mapView, eventPos);
            }
            return this.mOnClickListener.onClick(this, mapView, eventPos);
        }
        return touched;
    }

    protected boolean onClickDefault(Polyline polyline, MapView mapView, GeoPoint eventPos) {
        polyline.showInfoWindow(eventPos);
        return true;
    }

    @Override
    public void onDetach(MapView mapView) {
        this.mOnClickListener = null;
        this.onDestroy();
    }

    public static interface OnClickListener {
        public boolean onClick(Polyline var1, MapView var2, GeoPoint var3);
    }
}

