/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.util;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;

public class StorageUtils {
    public static final String SD_CARD = "sdCard";
    public static final String EXTERNAL_SD_CARD = "externalSdCard";
    private static final String TAG = "StorageUtils";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<StorageInfo> getStorageList() {
        ArrayList<StorageInfo> list = new ArrayList<StorageInfo>();
        String def_path = "";
        boolean def_path_internal = false;
        String def_path_state = "";
        boolean def_path_readonly = true;
        boolean def_path_available = false;
        try {
            if (Environment.getExternalStorageDirectory() != null) {
                def_path = Environment.getExternalStorageDirectory().getPath();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            def_path_internal = Build.VERSION.SDK_INT >= 9 && !Environment.isExternalStorageRemovable();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            def_path_state = Environment.getExternalStorageState();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            def_path_available = def_path_state.equals("mounted") || def_path_state.equals("mounted_ro");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            def_path_readonly = Environment.getExternalStorageState().equals("mounted_ro");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        BufferedReader buf_reader = null;
        try {
            String line;
            HashSet<String> paths = new HashSet<String>();
            buf_reader = new BufferedReader(new FileReader("/proc/mounts"));
            int cur_display_number = 1;
            Log.d((String)TAG, (String)"/proc/mounts");
            while ((line = buf_reader.readLine()) != null) {
                Log.d((String)TAG, (String)line);
                if (!line.contains("vfat") && !line.contains("/mnt")) continue;
                StringTokenizer tokens = new StringTokenizer(line, " ");
                String unused = tokens.nextToken();
                String mount_point = tokens.nextToken();
                if (paths.contains(mount_point)) continue;
                unused = tokens.nextToken();
                List<String> flags = Arrays.asList(tokens.nextToken().split(","));
                boolean readonly = flags.contains("ro");
                if (mount_point.equals(def_path)) {
                    paths.add(def_path);
                    list.add(0, new StorageInfo(def_path, def_path_internal, readonly, -1));
                    continue;
                }
                if (!line.contains("/dev/block/vold") || line.contains("/mnt/secure") || line.contains("/mnt/asec") || line.contains("/mnt/obb") || line.contains("/dev/mapper") || line.contains("tmpfs")) continue;
                paths.add(mount_point);
                list.add(new StorageInfo(mount_point, false, readonly, cur_display_number++));
            }
            if (!paths.contains(def_path) && def_path_available && def_path.length() > 0) {
                list.add(0, new StorageInfo(def_path, def_path_internal, def_path_readonly, -1));
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (buf_reader != null) {
                try {
                    buf_reader.close();
                }
                catch (IOException ex) {}
            }
        }
        Set<File> allStorageLocationsRevised = StorageUtils.getAllStorageLocationsRevised();
        for (File next : allStorageLocationsRevised) {
            boolean found = false;
            for (int i = 0; i < list.size(); ++i) {
                if (!((StorageInfo)list.get((int)i)).path.equals(next.getAbsolutePath())) continue;
                found = true;
                break;
            }
            if (found) continue;
            list.add(new StorageInfo(next.getAbsolutePath(), false, false, -1));
        }
        return list;
    }

    public static File getStorage() {
        StorageInfo ptr = null;
        List<StorageInfo> storageList = StorageUtils.getStorageList();
        for (int i = 0; i < storageList.size(); ++i) {
            StorageInfo storageInfo = storageList.get(i);
            if (storageInfo.readonly || !StorageUtils.isWritable(new File(storageInfo.path))) continue;
            if (ptr != null) {
                if (ptr.freeSpace >= storageInfo.freeSpace) continue;
                ptr = storageInfo;
                continue;
            }
            ptr = storageInfo;
        }
        if (ptr != null) {
            return new File(ptr.path);
        }
        try {
            return Environment.getExternalStorageDirectory();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static File getStorage(Context ctx) {
        StorageInfo ptr = null;
        List<StorageInfo> storageList = StorageUtils.getStorageList();
        for (int i = 0; i < storageList.size(); ++i) {
            StorageInfo storageInfo = storageList.get(i);
            if (storageInfo.readonly || !StorageUtils.isWritable(new File(storageInfo.path))) continue;
            if (ptr != null) {
                if (ptr.freeSpace >= storageInfo.freeSpace) continue;
                ptr = storageInfo;
                continue;
            }
            ptr = storageInfo;
        }
        if (ptr != null) {
            return new File(ptr.path);
        }
        return new File(ctx.getDatabasePath("temp.sqlite").getAbsolutePath().replace("temp.sqlite", ""));
    }

    public static boolean isAvailable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state) || "mounted_ro".equals(state);
    }

    public static String getSdCardPath() {
        return Environment.getExternalStorageDirectory().getPath() + "/";
    }

    public static boolean isWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public static boolean isWritable(File path) {
        try {
            File tmp = new File(path.getAbsolutePath() + File.separator + "osm.tmp");
            FileOutputStream fos = new FileOutputStream(tmp);
            fos.write("hi".getBytes());
            fos.close();
            Log.i((String)TAG, (String)(path.getAbsolutePath() + " is writable"));
            tmp.delete();
            return true;
        }
        catch (Throwable ex) {
            Log.i((String)TAG, (String)(path.getAbsolutePath() + " is NOT writable"));
            return false;
        }
    }

    public static Map<String, File> getAllStorageLocations() {
        String secondary_sd;
        File t;
        String primary_sd;
        String[] lineElements;
        String element;
        String line;
        Scanner scanner;
        HashMap<String, File> map = new HashMap<String, File>(10);
        ArrayList<String> mMounts = new ArrayList<String>(10);
        ArrayList<String> mVold = new ArrayList<String>(10);
        mMounts.add("/mnt/sdcard");
        mVold.add("/mnt/sdcard");
        try {
            File mountFile = new File("/proc/mounts");
            if (mountFile.exists()) {
                scanner = new Scanner(mountFile);
                while (scanner.hasNext()) {
                    line = scanner.nextLine();
                    if (!line.startsWith("/dev/block/vold/") || (element = (lineElements = line.split(" "))[1]).equals("/mnt/sdcard")) continue;
                    mMounts.add(element);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            File voldFile = new File("/system/etc/vold.fstab");
            if (voldFile.exists()) {
                scanner = new Scanner(voldFile);
                while (scanner.hasNext()) {
                    line = scanner.nextLine();
                    if (!line.startsWith("dev_mount")) continue;
                    lineElements = line.split(" ");
                    element = lineElements[2];
                    if (element.contains(":")) {
                        element = element.substring(0, element.indexOf(":"));
                    }
                    if (element.equals("/mnt/sdcard")) continue;
                    mVold.add(element);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < mMounts.size(); ++i) {
            String mount = (String)mMounts.get(i);
            if (mVold.contains(mount)) continue;
            mMounts.remove(i--);
        }
        mVold.clear();
        ArrayList<String> mountHash = new ArrayList<String>(10);
        for (String mount : mMounts) {
            File root = new File(mount);
            if (!root.exists() || !root.isDirectory() || !root.canWrite()) continue;
            File[] list = root.listFiles();
            String hash = "[";
            if (list != null) {
                for (File f : list) {
                    hash = hash + f.getName().hashCode() + ":" + f.length() + ", ";
                }
            }
            if (mountHash.contains(hash = hash + "]")) continue;
            String key = "sdCard_" + map.size();
            if (map.size() == 0) {
                key = SD_CARD;
            } else if (map.size() == 1) {
                key = EXTERNAL_SD_CARD;
            }
            mountHash.add(hash);
            map.put(key, root);
        }
        mMounts.clear();
        if (map.isEmpty()) {
            map.put(SD_CARD, Environment.getExternalStorageDirectory());
        }
        if (!map.containsValue(Environment.getExternalStorageDirectory())) {
            map.put(SD_CARD, Environment.getExternalStorageDirectory());
        }
        if ((primary_sd = System.getenv("EXTERNAL_STORAGE")) != null && (t = new File(primary_sd)).exists() && !map.containsValue(t)) {
            map.put(SD_CARD, t);
        }
        if ((secondary_sd = System.getenv("SECONDARY_STORAGE")) != null) {
            String[] split = secondary_sd.split(File.pathSeparator);
            for (int i = 0; i < split.length; ++i) {
                File t2 = new File(split[i]);
                if (!t2.exists() || map.containsValue(t2)) continue;
                map.put(SD_CARD, t2);
            }
        }
        return map;
    }

    private static Set<File> getAllStorageLocationsRevised() {
        String[] lineElements;
        String element;
        String line;
        Scanner scanner;
        File t;
        String secondary_sd;
        File t2;
        HashSet<File> map = new HashSet<File>();
        String primary_sd = System.getenv("EXTERNAL_STORAGE");
        if (primary_sd != null && StorageUtils.isWritable(t2 = new File(primary_sd + File.separator))) {
            map.add(t2);
        }
        if ((secondary_sd = System.getenv("SECONDARY_STORAGE")) != null) {
            String[] split = secondary_sd.split(File.pathSeparator);
            for (int i = 0; i < split.length; ++i) {
                File t3 = new File(split[i] + File.separator);
                if (!StorageUtils.isWritable(t3)) continue;
                map.add(t3);
            }
        }
        if (Environment.getExternalStorageDirectory() != null && StorageUtils.isWritable(t = Environment.getExternalStorageDirectory())) {
            map.add(t);
        }
        ArrayList<String> mMounts = new ArrayList<String>(10);
        ArrayList<String> mVold = new ArrayList<String>(10);
        mMounts.add("/mnt/sdcard");
        mVold.add("/mnt/sdcard");
        try {
            File mountFile = new File("/proc/mounts");
            if (mountFile.exists()) {
                scanner = new Scanner(mountFile);
                while (scanner.hasNext()) {
                    line = scanner.nextLine();
                    if (!line.startsWith("/dev/block/vold/") || (element = (lineElements = line.split(" "))[1]).equals("/mnt/sdcard")) continue;
                    mMounts.add(element);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            File voldFile = new File("/system/etc/vold.fstab");
            if (voldFile.exists()) {
                scanner = new Scanner(voldFile);
                while (scanner.hasNext()) {
                    line = scanner.nextLine();
                    if (!line.startsWith("dev_mount")) continue;
                    lineElements = line.split(" ");
                    element = lineElements[2];
                    if (element.contains(":")) {
                        element = element.substring(0, element.indexOf(":"));
                    }
                    if (element.equals("/mnt/sdcard")) continue;
                    mVold.add(element);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < mMounts.size(); ++i) {
            String mount = (String)mMounts.get(i);
            if (mVold.contains(mount)) continue;
            mMounts.remove(i--);
        }
        mVold.clear();
        ArrayList<String> mountHash = new ArrayList<String>(10);
        for (String mount : mMounts) {
            File root = new File(mount);
            if (!root.exists() || !root.isDirectory() || !root.canWrite()) continue;
            File[] list = root.listFiles();
            String hash = "[";
            if (list != null) {
                for (File f : list) {
                    hash = hash + f.getName().hashCode() + ":" + f.length() + ", ";
                }
            }
            if (mountHash.contains(hash = hash + "]")) continue;
            String key = "sdCard_" + map.size();
            if (map.size() == 0) {
                key = SD_CARD;
            } else if (map.size() == 1) {
                key = EXTERNAL_SD_CARD;
            }
            mountHash.add(hash);
            if (!StorageUtils.isWritable(root)) continue;
            map.add(root);
        }
        mMounts.clear();
        return map;
    }

    public static class StorageInfo {
        public final String path;
        public final boolean internal;
        public boolean readonly;
        public final int display_number;
        public long freeSpace = 0L;
        String displayName = "";

        public StorageInfo(String path, boolean internal, boolean readonly, int display_number) {
            this.path = path;
            this.internal = internal;
            this.display_number = display_number;
            if (Build.VERSION.SDK_INT >= 9) {
                this.freeSpace = new File(path).getFreeSpace();
            }
            if (!readonly) {
                File f = new File(path + File.separator + UUID.randomUUID().toString());
                try {
                    f.createNewFile();
                    f.delete();
                    this.readonly = false;
                }
                catch (Throwable e) {
                    this.readonly = true;
                }
            } else {
                this.readonly = readonly;
            }
            StringBuilder res = new StringBuilder();
            if (internal) {
                res.append("Internal SD card");
            } else if (display_number > 1) {
                res.append("SD card " + display_number);
            } else {
                res.append("SD card");
            }
            if (readonly) {
                res.append(" (Read only)");
            }
            this.displayName = res.toString();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String val) {
            this.displayName = val;
        }
    }
}

