/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.tilesource.ITileSource;

public class ZipFileArchive
implements IArchiveFile {
    protected ZipFile mZipFile;

    public ZipFileArchive() {
    }

    private ZipFileArchive(ZipFile pZipFile) {
        this.mZipFile = pZipFile;
    }

    public static ZipFileArchive getZipFileArchive(File pFile) throws ZipException, IOException {
        return new ZipFileArchive(new ZipFile(pFile));
    }

    @Override
    public void init(File pFile) throws Exception {
        this.mZipFile = new ZipFile(pFile);
    }

    @Override
    public InputStream getInputStream(ITileSource pTileSource, MapTile pTile) {
        String path = pTileSource.getTileRelativeFilenameString(pTile);
        try {
            ZipEntry entry = this.mZipFile.getEntry(path);
            if (entry != null) {
                return this.mZipFile.getInputStream(entry);
            }
        }
        catch (IOException e) {
            Log.w((String)"OsmDroid", (String)("Error getting zip stream: " + pTile), (Throwable)e);
        }
        return null;
    }

    @Override
    public Set<String> getTileSources() {
        HashSet<String> ret = new HashSet<String>();
        try {
            Enumeration<? extends ZipEntry> entries = this.mZipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry nextElement = entries.nextElement();
                String str = nextElement.getName();
                if (!str.contains("/")) continue;
                ret.add(str.split("/")[0]);
            }
        }
        catch (Exception e) {
            Log.w((String)"OsmDroid", (String)"Error getting tile sources: ", (Throwable)e);
        }
        return ret;
    }

    @Override
    public void close() {
        try {
            this.mZipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "ZipFileArchive [mZipFile=" + this.mZipFile.getName() + "]";
    }
}

