/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.content.res.AssetManager;
import android.graphics.drawable.Drawable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import microsoft.mappoint.TileSystem;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.modules.MapTileFileStorageProviderBase;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.BitmapTileSourceBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.TileSourceFactory;

public class MapTileAssetsProvider
extends MapTileFileStorageProviderBase {
    private final AssetManager mAssets;
    private final AtomicReference<ITileSource> mTileSource = new AtomicReference();

    public MapTileAssetsProvider(IRegisterReceiver pRegisterReceiver, AssetManager pAssets) {
        this(pRegisterReceiver, pAssets, TileSourceFactory.DEFAULT_TILE_SOURCE);
    }

    public MapTileAssetsProvider(IRegisterReceiver pRegisterReceiver, AssetManager pAssets, ITileSource pTileSource) {
        this(pRegisterReceiver, pAssets, pTileSource, Configuration.getInstance().getTileDownloadThreads(), Configuration.getInstance().getTileDownloadMaxQueueSize());
    }

    public MapTileAssetsProvider(IRegisterReceiver pRegisterReceiver, AssetManager pAssets, ITileSource pTileSource, int pThreadPoolSize, int pPendingQueueSize) {
        super(pRegisterReceiver, pThreadPoolSize, pPendingQueueSize);
        this.setTileSource(pTileSource);
        this.mAssets = pAssets;
    }

    @Override
    public boolean getUsesDataConnection() {
        return false;
    }

    @Override
    protected String getName() {
        return "Assets Cache Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "assets";
    }

    @Override
    protected Runnable getTileLoader() {
        return new TileLoader(this.mAssets);
    }

    @Override
    public int getMinimumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMinimumZoomLevel() : 0;
    }

    @Override
    public int getMaximumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMaximumZoomLevel() : TileSystem.getMaximumZoomLevel();
    }

    @Override
    public void setTileSource(ITileSource pTileSource) {
        this.mTileSource.set(pTileSource);
    }

    protected class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        private AssetManager mAssets;

        public TileLoader(AssetManager pAssets) {
            super(MapTileAssetsProvider.this);
            this.mAssets = null;
            this.mAssets = pAssets;
        }

        @Override
        public Drawable loadTile(MapTileRequestState pState) throws MapTileModuleProviderBase.CantContinueException {
            ITileSource tileSource = (ITileSource)MapTileAssetsProvider.this.mTileSource.get();
            if (tileSource == null) {
                return null;
            }
            MapTile tile = pState.getMapTile();
            try {
                InputStream is = this.mAssets.open(tileSource.getTileRelativeFilenameString(tile));
                Drawable drawable = tileSource.getDrawable(is);
                if (drawable != null) {
                    // empty if block
                }
                return drawable;
            }
            catch (IOException is) {
            }
            catch (BitmapTileSourceBase.LowMemoryException e) {
                throw new MapTileModuleProviderBase.CantContinueException((MapTileModuleProviderBase)MapTileAssetsProvider.this, (Throwable)e);
            }
            return null;
        }
    }
}

