/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource;

import java.util.ArrayList;
import java.util.List;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.tilesource.CloudmadeTileSource;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.tileprovider.tilesource.XYTileSource;

public class TileSourceFactory {
    public static final OnlineTileSourceBase MAPNIK = new XYTileSource("Mapnik", 0, 19, 256, ".png", new String[]{"http://a.tile.openstreetmap.org/", "http://b.tile.openstreetmap.org/", "http://c.tile.openstreetmap.org/"});
    public static final OnlineTileSourceBase CYCLEMAP = new XYTileSource("CycleMap", 0, 17, 256, ".png", new String[]{"http://a.tile.opencyclemap.org/cycle/", "http://b.tile.opencyclemap.org/cycle/", "http://c.tile.opencyclemap.org/cycle/"});
    public static final OnlineTileSourceBase PUBLIC_TRANSPORT = new XYTileSource("OSMPublicTransport", 0, 17, 256, ".png", new String[]{"http://openptmap.org/tiles/"});
    public static final OnlineTileSourceBase DEFAULT_TILE_SOURCE = MAPNIK;
    public static final OnlineTileSourceBase CLOUDMADESTANDARDTILES = new CloudmadeTileSource("CloudMadeStandardTiles", 0, 18, 256, ".png", new String[]{"http://a.tile.cloudmade.com/%s/%d/%d/%d/%d/%d%s?token=%s", "http://b.tile.cloudmade.com/%s/%d/%d/%d/%d/%d%s?token=%s", "http://c.tile.cloudmade.com/%s/%d/%d/%d/%d/%d%s?token=%s"});
    public static final OnlineTileSourceBase CLOUDMADESMALLTILES = new CloudmadeTileSource("CloudMadeSmallTiles", 0, 21, 64, ".png", new String[]{"http://a.tile.cloudmade.com/%s/%d/%d/%d/%d/%d%s?token=%s", "http://b.tile.cloudmade.com/%s/%d/%d/%d/%d/%d%s?token=%s", "http://c.tile.cloudmade.com/%s/%d/%d/%d/%d/%d%s?token=%s"});
    public static final OnlineTileSourceBase FIETS_OVERLAY_NL = new XYTileSource("Fiets", 3, 18, 256, ".png", new String[]{"http://overlay.openstreetmap.nl/openfietskaart-overlay/"});
    public static final OnlineTileSourceBase BASE_OVERLAY_NL = new XYTileSource("BaseNL", 0, 18, 256, ".png", new String[]{"http://overlay.openstreetmap.nl/basemap/"});
    public static final OnlineTileSourceBase ROADS_OVERLAY_NL = new XYTileSource("RoadsNL", 0, 18, 256, ".png", new String[]{"http://overlay.openstreetmap.nl/roads/"});
    public static final OnlineTileSourceBase HIKEBIKEMAP = new XYTileSource("HikeBikeMap", 0, 18, 256, ".png", new String[]{"http://a.tiles.wmflabs.org/hikebike/", "http://b.tiles.wmflabs.org/hikebike/", "http://c.tiles.wmflabs.org/hikebike/"});
    public static final OnlineTileSourceBase USGS_TOPO = new OnlineTileSourceBase("USGS National Map Topo", 0, 18, 256, "", new String[]{"http://basemap.nationalmap.gov/arcgis/rest/services/USGSTopo/MapServer/tile/"}){

        @Override
        public String getTileURLString(MapTile aTile) {
            return this.getBaseUrl() + aTile.getZoomLevel() + "/" + aTile.getY() + "/" + aTile.getX();
        }
    };
    public static final OnlineTileSourceBase USGS_SAT = new OnlineTileSourceBase("USGS National Map Sat", 0, 18, 256, "", new String[]{"http://basemap.nationalmap.gov/arcgis/rest/services/USGSImageryTopo/MapServer/tile/"}){

        @Override
        public String getTileURLString(MapTile aTile) {
            return this.getBaseUrl() + aTile.getZoomLevel() + "/" + aTile.getY() + "/" + aTile.getX();
        }
    };
    private static List<ITileSource> mTileSources = new ArrayList<ITileSource>();

    public static ITileSource getTileSource(String aName) throws IllegalArgumentException {
        for (ITileSource tileSource : mTileSources) {
            if (!tileSource.name().equals(aName)) continue;
            return tileSource;
        }
        throw new IllegalArgumentException("No such tile source: " + aName);
    }

    public static boolean containsTileSource(String aName) {
        for (ITileSource tileSource : mTileSources) {
            if (!tileSource.name().equals(aName)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static ITileSource getTileSource(int aOrdinal) throws IllegalArgumentException {
        for (ITileSource tileSource : mTileSources) {
            if (tileSource.ordinal() != aOrdinal) continue;
            return tileSource;
        }
        throw new IllegalArgumentException("No tile source at position: " + aOrdinal);
    }

    public static List<ITileSource> getTileSources() {
        return mTileSources;
    }

    public static void addTileSource(ITileSource mTileSource) {
        mTileSources.add(mTileSource);
    }

    static {
        mTileSources.add(MAPNIK);
        mTileSources.add(CYCLEMAP);
        mTileSources.add(PUBLIC_TRANSPORT);
        mTileSources.add(HIKEBIKEMAP);
        mTileSources.add(USGS_TOPO);
        mTileSources.add(USGS_SAT);
    }
}

