/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import org.osmdroid.library.R;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.OverlayWithIW;
import org.osmdroid.views.overlay.infowindow.MarkerInfoWindow;

public class Marker
extends OverlayWithIW {
    public static boolean ENABLE_TEXT_LABELS_WHEN_NO_IMAGE = false;
    protected int mTextLabelBackgroundColor = -1;
    protected int mTextLabelForegroundColor = -16777216;
    protected int mTextLabelFontSize = 24;
    protected Drawable mIcon;
    protected GeoPoint mPosition;
    protected float mBearing;
    protected float mAnchorU;
    protected float mAnchorV;
    protected float mIWAnchorU;
    protected float mIWAnchorV;
    protected float mAlpha;
    protected boolean mDraggable;
    protected boolean mIsDragged;
    protected boolean mFlat;
    protected OnMarkerClickListener mOnMarkerClickListener;
    protected OnMarkerDragListener mOnMarkerDragListener;
    protected Drawable mImage;
    protected boolean mPanToView;
    protected Point mPositionPixels;
    protected static MarkerInfoWindow mDefaultInfoWindow = null;
    protected static Drawable mDefaultIcon = null;
    final Resources resource;
    public static final float ANCHOR_CENTER = 0.5f;
    public static final float ANCHOR_LEFT = 0.0f;
    public static final float ANCHOR_TOP = 0.0f;
    public static final float ANCHOR_RIGHT = 1.0f;
    public static final float ANCHOR_BOTTOM = 1.0f;

    public Marker(MapView mapView) {
        this(mapView, mapView.getContext());
    }

    public Marker(MapView mapView, Context resourceProxy) {
        super(resourceProxy);
        this.resource = mapView.getContext().getResources();
        this.mBearing = 0.0f;
        this.mAlpha = 1.0f;
        this.mPosition = new GeoPoint(0.0, 0.0);
        this.mAnchorU = 0.5f;
        this.mAnchorV = 0.5f;
        this.mIWAnchorU = 0.5f;
        this.mIWAnchorV = 0.0f;
        this.mDraggable = false;
        this.mIsDragged = false;
        this.mPositionPixels = new Point();
        this.mPanToView = true;
        this.mFlat = false;
        this.mOnMarkerClickListener = null;
        this.mOnMarkerDragListener = null;
        if (mDefaultIcon == null) {
            mDefaultIcon = resourceProxy.getResources().getDrawable(R.drawable.marker_default);
        }
        this.mIcon = mDefaultIcon;
        if (mDefaultInfoWindow == null || mDefaultInfoWindow.getMapView() != mapView) {
            mDefaultInfoWindow = new MarkerInfoWindow(R.layout.bonuspack_bubble, mapView);
        }
        this.setInfoWindow(mDefaultInfoWindow);
    }

    public void setIcon(Drawable icon) {
        if (ENABLE_TEXT_LABELS_WHEN_NO_IMAGE && icon == null && this.mTitle != null && this.mTitle.length() > 0) {
            Paint background = new Paint();
            background.setColor(this.mTextLabelBackgroundColor);
            Paint p = new Paint();
            p.setTextSize((float)this.mTextLabelFontSize);
            p.setColor(this.mTextLabelForegroundColor);
            p.setAntiAlias(true);
            p.setTypeface(Typeface.DEFAULT_BOLD);
            p.setTextAlign(Paint.Align.LEFT);
            int width = (int)(p.measureText(this.getTitle()) + 0.5f);
            float baseline = (int)(-p.ascent() + 0.5f);
            int height = (int)(baseline + p.descent() + 0.5f);
            Bitmap image = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(image);
            c.drawPaint(background);
            c.drawText(this.getTitle(), 0.0f, baseline, p);
            this.mIcon = new BitmapDrawable(this.resource, image);
        }
        if (!ENABLE_TEXT_LABELS_WHEN_NO_IMAGE && icon != null) {
            this.mIcon = icon;
        }
        if (this.mIcon == null) {
            this.mIcon = mDefaultIcon;
        }
    }

    public GeoPoint getPosition() {
        return this.mPosition;
    }

    public void setPosition(GeoPoint position) {
        this.mPosition = position.clone();
    }

    public float getRotation() {
        return this.mBearing;
    }

    public void setRotation(float rotation) {
        this.mBearing = rotation;
    }

    public void setAnchor(float anchorU, float anchorV) {
        this.mAnchorU = anchorU;
        this.mAnchorV = anchorV;
    }

    public void setInfoWindowAnchor(float anchorU, float anchorV) {
        this.mIWAnchorU = anchorU;
        this.mIWAnchorV = anchorV;
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void setDraggable(boolean draggable) {
        this.mDraggable = draggable;
    }

    public boolean isDraggable() {
        return this.mDraggable;
    }

    public void setFlat(boolean flat) {
        this.mFlat = flat;
    }

    public boolean isFlat() {
        return this.mFlat;
    }

    public void remove(MapView mapView) {
        mapView.getOverlays().remove(this);
    }

    public void setOnMarkerClickListener(OnMarkerClickListener listener) {
        this.mOnMarkerClickListener = listener;
    }

    public void setOnMarkerDragListener(OnMarkerDragListener listener) {
        this.mOnMarkerDragListener = listener;
    }

    public void setImage(Drawable image) {
        this.mImage = image;
    }

    public Drawable getImage() {
        return this.mImage;
    }

    public void setInfoWindow(MarkerInfoWindow infoWindow) {
        this.mInfoWindow = infoWindow;
    }

    public void setPanToView(boolean panToView) {
        this.mPanToView = panToView;
    }

    public void showInfoWindow() {
        if (this.mInfoWindow == null) {
            return;
        }
        int markerWidth = 0;
        int markerHeight = 0;
        markerWidth = this.mIcon.getIntrinsicWidth();
        markerHeight = this.mIcon.getIntrinsicHeight();
        int offsetX = (int)(this.mIWAnchorU * (float)markerWidth) - (int)(this.mAnchorU * (float)markerWidth);
        int offsetY = (int)(this.mIWAnchorV * (float)markerHeight) - (int)(this.mAnchorV * (float)markerHeight);
        this.mInfoWindow.open(this, this.mPosition, offsetX, offsetY);
    }

    public boolean isInfoWindowShown() {
        if (this.mInfoWindow instanceof MarkerInfoWindow) {
            MarkerInfoWindow iw = (MarkerInfoWindow)this.mInfoWindow;
            return iw != null && iw.isOpen() && iw.getMarkerReference() == this;
        }
        return super.isInfoWindowOpen();
    }

    @Override
    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (this.mIcon == null) {
            return;
        }
        Projection pj = mapView.getProjection();
        pj.toPixels(this.mPosition, this.mPositionPixels);
        int width = this.mIcon.getIntrinsicWidth();
        int height = this.mIcon.getIntrinsicHeight();
        Rect rect = new Rect(0, 0, width, height);
        rect.offset(-((int)(this.mAnchorU * (float)width)), -((int)(this.mAnchorV * (float)height)));
        this.mIcon.setBounds(rect);
        this.mIcon.setAlpha((int)(this.mAlpha * 255.0f));
        float rotationOnScreen = this.mFlat ? -this.mBearing : mapView.getMapOrientation() - this.mBearing;
        Marker.drawAt(canvas, this.mIcon, this.mPositionPixels.x, this.mPositionPixels.y, false, rotationOnScreen);
    }

    @Override
    public void onDetach(MapView mapView) {
        mDefaultIcon = null;
        mDefaultInfoWindow = null;
        super.onDetach(mapView);
    }

    public boolean hitTest(MotionEvent event, MapView mapView) {
        Projection pj = mapView.getProjection();
        pj.toPixels(this.mPosition, this.mPositionPixels);
        Rect screenRect = pj.getIntrinsicScreenRect();
        int x = -this.mPositionPixels.x + screenRect.left + (int)event.getX();
        int y = -this.mPositionPixels.y + screenRect.top + (int)event.getY();
        boolean hit = this.mIcon.getBounds().contains(x, y);
        return hit;
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        boolean touched = this.hitTest(event, mapView);
        if (touched) {
            if (this.mOnMarkerClickListener == null) {
                return this.onMarkerClickDefault(this, mapView);
            }
            return this.mOnMarkerClickListener.onMarkerClick(this, mapView);
        }
        return touched;
    }

    public void moveToEventPosition(MotionEvent event, MapView mapView) {
        Projection pj = mapView.getProjection();
        this.mPosition = (GeoPoint)pj.fromPixels((int)event.getX(), (int)event.getY());
        mapView.invalidate();
    }

    @Override
    public boolean onLongPress(MotionEvent event, MapView mapView) {
        boolean touched = this.hitTest(event, mapView);
        if (touched && this.mDraggable) {
            this.mIsDragged = true;
            this.closeInfoWindow();
            if (this.mOnMarkerDragListener != null) {
                this.mOnMarkerDragListener.onMarkerDragStart(this);
            }
            this.moveToEventPosition(event, mapView);
        }
        return touched;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        if (this.mDraggable && this.mIsDragged) {
            if (event.getAction() == 1) {
                this.mIsDragged = false;
                if (this.mOnMarkerDragListener != null) {
                    this.mOnMarkerDragListener.onMarkerDragEnd(this);
                }
                return true;
            }
            if (event.getAction() == 2) {
                this.moveToEventPosition(event, mapView);
                if (this.mOnMarkerDragListener != null) {
                    this.mOnMarkerDragListener.onMarkerDrag(this);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean onMarkerClickDefault(Marker marker, MapView mapView) {
        marker.showInfoWindow();
        if (marker.mPanToView) {
            mapView.getController().animateTo(marker.getPosition());
        }
        return true;
    }

    public int getTextLabelBackgroundColor() {
        return this.mTextLabelBackgroundColor;
    }

    public void setTextLabelBackgroundColor(int mTextLabelBackgroundColor) {
        this.mTextLabelBackgroundColor = mTextLabelBackgroundColor;
    }

    public int getTextLabelForegroundColor() {
        return this.mTextLabelForegroundColor;
    }

    public void setTextLabelForegroundColor(int mTextLabelForegroundColor) {
        this.mTextLabelForegroundColor = mTextLabelForegroundColor;
    }

    public int getTextLabelFontSize() {
        return this.mTextLabelFontSize;
    }

    public void setTextLabelFontSize(int mTextLabelFontSize) {
        this.mTextLabelFontSize = mTextLabelFontSize;
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);

        public void onMarkerDragStart(Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1, MapView var2);
    }
}

