/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osmdroid.tileprovider.BitmapPool;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.ReusableBitmapDrawable;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;

public class LRUMapTileCache
extends LinkedHashMap<MapTile, Drawable> {
    private static final long serialVersionUID = -541142277575493335L;
    private int mCapacity;
    private TileRemovedListener mTileRemovedListener;

    public LRUMapTileCache(int aCapacity) {
        super(aCapacity + 2, 0.1f, true);
        this.mCapacity = aCapacity;
    }

    public void ensureCapacity(int aCapacity) {
        if (aCapacity > this.mCapacity) {
            Log.i((String)"OsmDroid", (String)("Tile cache increased from " + this.mCapacity + " to " + aCapacity));
            this.mCapacity = aCapacity;
        }
    }

    @Override
    public Drawable remove(Object aKey) {
        Bitmap bitmap;
        Drawable drawable = (Drawable)super.remove(aKey);
        if (Build.VERSION.SDK_INT < 9 && drawable instanceof BitmapDrawable && (bitmap = ((BitmapDrawable)drawable).getBitmap()) != null) {
            bitmap.recycle();
        }
        if (this.getTileRemovedListener() != null && aKey instanceof MapTile) {
            this.getTileRemovedListener().onTileRemoved((MapTile)aKey);
        }
        if (drawable instanceof ReusableBitmapDrawable) {
            BitmapPool.getInstance().returnDrawableToPool((ReusableBitmapDrawable)drawable);
        }
        return drawable;
    }

    @Override
    public void clear() {
        while (!this.isEmpty()) {
            this.remove(this.keySet().iterator().next());
        }
        super.clear();
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<MapTile, Drawable> aEldest) {
        if (this.size() > this.mCapacity) {
            MapTile eldest = aEldest.getKey();
            if (OpenStreetMapTileProviderConstants.DEBUGMODE) {
                Log.d((String)"OsmDroid", (String)("Remove old tile: " + eldest));
            }
            this.remove(eldest);
        }
        return false;
    }

    public TileRemovedListener getTileRemovedListener() {
        return this.mTileRemovedListener;
    }

    public void setTileRemovedListener(TileRemovedListener tileRemovedListener) {
        this.mTileRemovedListener = tileRemovedListener;
    }

    public static interface TileRemovedListener {
        public void onTileRemoved(MapTile var1);
    }
}

