/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.osmdroid.tileprovider.util.ManifestUtil;

public class CloudmadeUtil {
    public static boolean DEBUGMODE = false;
    private static final String CLOUDMADE_KEY = "CLOUDMADE_KEY";
    private static final String CLOUDMADE_ID = "CLOUDMADE_ID";
    private static final String CLOUDMADE_TOKEN = "CLOUDMADE_TOKEN";
    private static String mAndroidId = "android_id";
    private static String mKey = "";
    private static String mToken = "";
    private static SharedPreferences.Editor mPreferenceEditor;

    public static void retrieveCloudmadeKey(Context aContext) {
        mAndroidId = Settings.Secure.getString((ContentResolver)aContext.getContentResolver(), (String)"android_id");
        mKey = ManifestUtil.retrieveKey(aContext, CLOUDMADE_KEY);
        SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)aContext);
        mPreferenceEditor = pref.edit();
        String id = pref.getString(CLOUDMADE_ID, "");
        if (id.equals(mAndroidId)) {
            mToken = pref.getString(CLOUDMADE_TOKEN, "");
            if (mToken.length() > 0) {
                mPreferenceEditor = null;
            }
        } else {
            mPreferenceEditor.putString(CLOUDMADE_ID, mAndroidId);
            mPreferenceEditor.commit();
        }
    }

    public static String getCloudmadeKey() {
        return mKey;
    }

    public static void setCloudmadeKey(String key) {
        mKey = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCloudmadeToken() {
        if (mToken.length() == 0) {
            String string2 = mToken;
            synchronized (string2) {
                if (mToken.length() == 0) {
                    String url = "http://auth.cloudmade.com/token/" + mKey + "?userid=" + mAndroidId;
                    HttpURLConnection urlConnection = null;
                    try {
                        URL urlToRequest = new URL(url);
                        urlConnection = (HttpURLConnection)urlToRequest.openConnection();
                        urlConnection.setDoOutput(true);
                        urlConnection.setRequestMethod("POST");
                        urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        urlConnection.setRequestProperty(OpenStreetMapTileProviderConstants.USER_AGENT, OpenStreetMapTileProviderConstants.getUserAgentValue());
                        urlConnection.connect();
                        if (DEBUGMODE) {
                            Log.d((String)"OsmDroid", (String)("Response from Cloudmade auth: " + urlConnection.getResponseMessage()));
                        }
                        if (urlConnection.getResponseCode() == 200) {
                            BufferedReader br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()), 8192);
                            String line = br.readLine();
                            if (DEBUGMODE) {
                                Log.d((String)"OsmDroid", (String)("First line from Cloudmade auth: " + line));
                            }
                            if ((mToken = line.trim()).length() > 0) {
                                mPreferenceEditor.putString(CLOUDMADE_TOKEN, mToken);
                                mPreferenceEditor.commit();
                                mPreferenceEditor = null;
                            } else {
                                Log.e((String)"OsmDroid", (String)"No authorization token received from Cloudmade");
                            }
                        }
                    }
                    catch (IOException e) {
                        Log.e((String)"OsmDroid", (String)("No authorization token received from Cloudmade: " + e));
                    }
                    finally {
                        if (urlConnection != null) {
                            try {
                                urlConnection.disconnect();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
        }
        return mToken;
    }
}

