/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicReference;
import microsoft.mappoint.TileSystem;
import org.osmdroid.tileprovider.BitmapPool;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.ReusableBitmapDrawable;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.modules.INetworkAvailablityCheck;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.BitmapTileSourceBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.tileprovider.util.StreamUtils;

public class MapTileDownloader
extends MapTileModuleProviderBase {
    private final IFilesystemCache mFilesystemCache;
    private final AtomicReference<OnlineTileSourceBase> mTileSource = new AtomicReference();
    private final INetworkAvailablityCheck mNetworkAvailablityCheck;

    public MapTileDownloader(ITileSource pTileSource) {
        this(pTileSource, null, null);
    }

    public MapTileDownloader(ITileSource pTileSource, IFilesystemCache pFilesystemCache) {
        this(pTileSource, pFilesystemCache, null);
    }

    public MapTileDownloader(ITileSource pTileSource, IFilesystemCache pFilesystemCache, INetworkAvailablityCheck pNetworkAvailablityCheck) {
        this(pTileSource, pFilesystemCache, pNetworkAvailablityCheck, 2, 40);
    }

    public MapTileDownloader(ITileSource pTileSource, IFilesystemCache pFilesystemCache, INetworkAvailablityCheck pNetworkAvailablityCheck, int pThreadPoolSize, int pPendingQueueSize) {
        super(pThreadPoolSize, pPendingQueueSize);
        this.mFilesystemCache = pFilesystemCache;
        this.mNetworkAvailablityCheck = pNetworkAvailablityCheck;
        this.setTileSource(pTileSource);
    }

    public ITileSource getTileSource() {
        return this.mTileSource.get();
    }

    @Override
    public boolean getUsesDataConnection() {
        return true;
    }

    @Override
    protected String getName() {
        return "Online Tile Download Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "downloader";
    }

    @Override
    protected Runnable getTileLoader() {
        return new TileLoader();
    }

    @Override
    public int getMinimumZoomLevel() {
        OnlineTileSourceBase tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMinimumZoomLevel() : 0;
    }

    @Override
    public int getMaximumZoomLevel() {
        OnlineTileSourceBase tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMaximumZoomLevel() : TileSystem.getMaximumZoomLevel();
    }

    @Override
    public void setTileSource(ITileSource tileSource) {
        if (tileSource instanceof OnlineTileSourceBase) {
            this.mTileSource.set((OnlineTileSourceBase)tileSource);
        } else {
            this.mTileSource.set(null);
        }
    }

    protected class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        protected TileLoader() {
            super(MapTileDownloader.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Drawable loadTile(MapTileRequestState aState) throws MapTileModuleProviderBase.CantContinueException {
            Drawable drawable;
            HttpURLConnection c;
            BufferedOutputStream out;
            InputStream in;
            block38: {
                Drawable ex2;
                block37: {
                    OnlineTileSourceBase tileSource = (OnlineTileSourceBase)MapTileDownloader.this.mTileSource.get();
                    if (tileSource == null) {
                        return null;
                    }
                    in = null;
                    out = null;
                    c = null;
                    MapTile tile = aState.getMapTile();
                    try {
                        Drawable result;
                        if (MapTileDownloader.this.mNetworkAvailablityCheck != null && !MapTileDownloader.this.mNetworkAvailablityCheck.getNetworkAvailable()) {
                            if (OpenStreetMapTileProviderConstants.DEBUGMODE) {
                                Log.d((String)"OsmDroid", (String)("Skipping " + MapTileDownloader.this.getName() + " due to NetworkAvailabliltyCheck."));
                            }
                            Drawable drawable2 = null;
                            return drawable2;
                        }
                        String tileURLString = tileSource.getTileURLString(tile);
                        if (OpenStreetMapTileProviderConstants.DEBUGMODE) {
                            Log.d((String)"OsmDroid", (String)("Downloading Maptile from url: " + tileURLString));
                        }
                        if (TextUtils.isEmpty((CharSequence)tileURLString)) {
                            Drawable ex2 = null;
                            return ex2;
                        }
                        c = (HttpURLConnection)new URL(tileURLString).openConnection();
                        c.setUseCaches(true);
                        c.setRequestProperty(OpenStreetMapTileProviderConstants.USER_AGENT, OpenStreetMapTileProviderConstants.getUserAgentValue());
                        c.connect();
                        if (c.getResponseCode() != 200) {
                            Log.w((String)"OsmDroid", (String)("Problem downloading MapTile: " + tile + " HTTP response: " + c.getResponseMessage()));
                            ex2 = null;
                            StreamUtils.closeStream(in);
                            break block37;
                        }
                        in = c.getInputStream();
                        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
                        out = new BufferedOutputStream(dataStream, 8192);
                        StreamUtils.copy(in, out);
                        ((OutputStream)out).flush();
                        byte[] data = dataStream.toByteArray();
                        ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
                        if (MapTileDownloader.this.mFilesystemCache != null) {
                            MapTileDownloader.this.mFilesystemCache.saveFile(tileSource, tile, byteStream);
                            byteStream.reset();
                        }
                        drawable = result = tileSource.getDrawable(byteStream);
                        StreamUtils.closeStream(in);
                        break block38;
                    }
                    catch (UnknownHostException e) {
                        Log.w((String)"OsmDroid", (String)("UnknownHostException downloading MapTile: " + tile + " : " + e));
                        throw new MapTileModuleProviderBase.CantContinueException((MapTileModuleProviderBase)MapTileDownloader.this, (Throwable)e);
                    }
                    catch (BitmapTileSourceBase.LowMemoryException e) {
                        Log.w((String)"OsmDroid", (String)("LowMemoryException downloading MapTile: " + tile + " : " + e));
                        throw new MapTileModuleProviderBase.CantContinueException((MapTileModuleProviderBase)MapTileDownloader.this, (Throwable)e);
                    }
                    catch (FileNotFoundException e) {
                        Log.w((String)"OsmDroid", (String)("Tile not found: " + tile + " : " + e));
                        return null;
                    }
                    catch (IOException e) {
                        Log.w((String)"OsmDroid", (String)("IOException downloading MapTile: " + tile + " : " + e));
                        return null;
                    }
                    catch (Throwable e) {
                        Log.e((String)"OsmDroid", (String)("Error downloading MapTile: " + tile), (Throwable)e);
                        return null;
                    }
                }
                StreamUtils.closeStream(out);
                try {
                    c.disconnect();
                    return ex2;
                }
                catch (Exception ex3) {
                    // empty catch block
                }
                return ex2;
            }
            StreamUtils.closeStream(out);
            try {
                c.disconnect();
                return drawable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            return drawable;
            finally {
                StreamUtils.closeStream(in);
                StreamUtils.closeStream(out);
                try {
                    c.disconnect();
                }
                catch (Exception ex) {}
            }
        }

        @Override
        protected void tileLoaded(MapTileRequestState pState, Drawable pDrawable) {
            MapTileDownloader.this.removeTileFromQueues(pState.getMapTile());
            pState.getCallback().mapTileRequestCompleted(pState, null);
            if (pDrawable instanceof ReusableBitmapDrawable) {
                BitmapPool.getInstance().returnDrawableToPool((ReusableBitmapDrawable)pDrawable);
            }
        }
    }
}

