/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource;

import org.osmdroid.ResourceProxy;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.tilesource.IStyledTileSource;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.tileprovider.util.CloudmadeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudmadeTileSource
extends OnlineTileSourceBase
implements IStyledTileSource<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(CloudmadeTileSource.class);
    private Integer mStyle = 1;

    public CloudmadeTileSource(String pName, ResourceProxy.string pResourceId, int pZoomMinLevel, int pZoomMaxLevel, int pTileSizePixels, String pImageFilenameEnding, String[] pBaseUrl) {
        super(pName, pResourceId, pZoomMinLevel, pZoomMaxLevel, pTileSizePixels, pImageFilenameEnding, pBaseUrl);
    }

    @Override
    public String pathBase() {
        if (this.mStyle == null || this.mStyle <= 1) {
            return this.mName;
        }
        return this.mName + this.mStyle;
    }

    @Override
    public String getTileURLString(MapTile pTile) {
        String key = CloudmadeUtil.getCloudmadeKey();
        if (key.length() == 0) {
            logger.error("CloudMade key is not set. You should enter it in the manifest and call CloudmadeUtil.retrieveCloudmadeKey()");
        }
        String token = CloudmadeUtil.getCloudmadeToken();
        return String.format(this.getBaseUrl(), key, this.mStyle, this.getTileSizePixels(), pTile.getZoomLevel(), pTile.getX(), pTile.getY(), this.mImageFilenameEnding, token);
    }

    @Override
    public void setStyle(Integer pStyle) {
        this.mStyle = pStyle;
    }

    @Override
    public void setStyle(String pStyle) {
        try {
            this.mStyle = Integer.parseInt(pStyle);
        }
        catch (NumberFormatException e) {
            logger.warn("Error setting integer style: " + pStyle);
        }
    }

    @Override
    public Integer getStyle() {
        return this.mStyle;
    }
}

