/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import org.osmdroid.tileprovider.modules.INetworkAvailablityCheck;

public class NetworkAvailabliltyCheck
implements INetworkAvailablityCheck {
    private final ConnectivityManager mConnectionManager;

    public NetworkAvailabliltyCheck(Context aContext) {
        this.mConnectionManager = (ConnectivityManager)aContext.getSystemService("connectivity");
    }

    @Override
    public boolean getNetworkAvailable() {
        NetworkInfo networkInfo = this.mConnectionManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isAvailable();
    }

    @Override
    public boolean getWiFiNetworkAvailable() {
        NetworkInfo wifi = this.mConnectionManager.getNetworkInfo(1);
        return wifi != null && wifi.isAvailable();
    }

    @Override
    public boolean getCellularDataNetworkAvailable() {
        NetworkInfo mobile = this.mConnectionManager.getNetworkInfo(0);
        return mobile != null && mobile.isAvailable();
    }

    @Override
    public boolean getRouteToPathExists(int hostAddress) {
        return this.mConnectionManager.requestRouteToHost(1, hostAddress) || this.mConnectionManager.requestRouteToHost(0, hostAddress);
    }
}

