/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.Point;
import android.graphics.PointF;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.WindowManager;
import java.util.LinkedList;
import microsoft.mappoint.TileSystem;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.LocationListenerProxy;
import org.osmdroid.ResourceProxy;
import org.osmdroid.SensorEventListenerProxy;
import org.osmdroid.api.IMapView;
import org.osmdroid.api.IMyLocationOverlay;
import org.osmdroid.api.IProjection;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.LocationUtils;
import org.osmdroid.util.NetworkLocationIgnorer;
import org.osmdroid.views.MapController;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.IOverlayMenuProvider;
import org.osmdroid.views.overlay.Overlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyLocationOverlay
extends Overlay
implements IMyLocationOverlay,
IOverlayMenuProvider,
SensorEventListener,
LocationListener,
Overlay.Snappable {
    private static final Logger logger = LoggerFactory.getLogger(MyLocationOverlay.class);
    protected final Paint mPaint = new Paint();
    protected final Paint mCirclePaint = new Paint();
    protected final Bitmap PERSON_ICON;
    protected final Bitmap DIRECTION_ARROW;
    protected final MapView mMapView;
    private final MapController mMapController;
    private final LocationManager mLocationManager;
    private final SensorManager mSensorManager;
    private final Display mDisplay;
    public LocationListenerProxy mLocationListener = null;
    public SensorEventListenerProxy mSensorListener = null;
    private final LinkedList<Runnable> mRunOnFirstFix = new LinkedList();
    private final Point mMapCoords = new Point();
    private Location mLocation;
    private long mLocationUpdateMinTime = 0L;
    private float mLocationUpdateMinDistance = 0.0f;
    protected boolean mFollow = false;
    protected boolean mDrawAccuracyEnabled = true;
    private final NetworkLocationIgnorer mIgnorer = new NetworkLocationIgnorer();
    private final Matrix directionRotater = new Matrix();
    protected final PointF PERSON_HOTSPOT;
    protected final float DIRECTION_ARROW_CENTER_X;
    protected final float DIRECTION_ARROW_CENTER_Y;
    protected final Picture mCompassFrame = new Picture();
    protected final Picture mCompassRose = new Picture();
    private final Matrix mCompassMatrix = new Matrix();
    private float mAzimuth = Float.NaN;
    private float mCompassCenterX = 35.0f;
    private float mCompassCenterY = 35.0f;
    private final float mCompassRadius = 20.0f;
    protected final float COMPASS_FRAME_CENTER_X;
    protected final float COMPASS_FRAME_CENTER_Y;
    protected final float COMPASS_ROSE_CENTER_X;
    protected final float COMPASS_ROSE_CENTER_Y;
    public static final int MENU_MY_LOCATION = MyLocationOverlay.getSafeMenuId();
    public static final int MENU_COMPASS = MyLocationOverlay.getSafeMenuId();
    private boolean mOptionsMenuEnabled = true;
    private final float[] mMatrixValues = new float[9];
    private final GeoPoint mMyLocation = new GeoPoint(0, 0);
    private final Matrix mMatrix = new Matrix();

    public MyLocationOverlay(Context ctx, MapView mapView) {
        this(ctx, mapView, new DefaultResourceProxyImpl(ctx));
    }

    public MyLocationOverlay(Context ctx, MapView mapView, ResourceProxy pResourceProxy) {
        super(pResourceProxy);
        this.mMapView = mapView;
        this.mLocationManager = (LocationManager)ctx.getSystemService("location");
        this.mSensorManager = (SensorManager)ctx.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)ctx.getSystemService("window");
        this.mDisplay = windowManager.getDefaultDisplay();
        this.mMapController = mapView.getController();
        this.mCirclePaint.setARGB(0, 100, 100, 255);
        this.mCirclePaint.setAntiAlias(true);
        this.PERSON_ICON = this.mResourceProxy.getBitmap(ResourceProxy.bitmap.person);
        this.DIRECTION_ARROW = this.mResourceProxy.getBitmap(ResourceProxy.bitmap.direction_arrow);
        this.DIRECTION_ARROW_CENTER_X = (float)(this.DIRECTION_ARROW.getWidth() / 2) - 0.5f;
        this.DIRECTION_ARROW_CENTER_Y = (float)(this.DIRECTION_ARROW.getHeight() / 2) - 0.5f;
        this.PERSON_HOTSPOT = new PointF(24.0f * this.mScale + 0.5f, 39.0f * this.mScale + 0.5f);
        this.createCompassFramePicture();
        this.createCompassRosePicture();
        this.COMPASS_FRAME_CENTER_X = (float)(this.mCompassFrame.getWidth() / 2) - 0.5f;
        this.COMPASS_FRAME_CENTER_Y = (float)(this.mCompassFrame.getHeight() / 2) - 0.5f;
        this.COMPASS_ROSE_CENTER_X = (float)(this.mCompassRose.getWidth() / 2) - 0.5f;
        this.COMPASS_ROSE_CENTER_Y = (float)(this.mCompassRose.getHeight() / 2) - 0.5f;
    }

    public long getLocationUpdateMinTime() {
        return this.mLocationUpdateMinTime;
    }

    public void setLocationUpdateMinTime(long milliSeconds) {
        this.mLocationUpdateMinTime = milliSeconds;
    }

    public float getLocationUpdateMinDistance() {
        return this.mLocationUpdateMinDistance;
    }

    public void setLocationUpdateMinDistance(float meters) {
        this.mLocationUpdateMinDistance = meters;
    }

    public void setCompassCenter(float x, float y) {
        this.mCompassCenterX = x;
        this.mCompassCenterY = y;
    }

    public void setDrawAccuracyEnabled(boolean drawAccuracyEnabled) {
        this.mDrawAccuracyEnabled = drawAccuracyEnabled;
    }

    public boolean isDrawAccuracyEnabled() {
        return this.mDrawAccuracyEnabled;
    }

    protected void drawMyLocation(Canvas canvas, MapView mapView, Location lastFix, GeoPoint myLocation) {
        MapView.Projection pj = mapView.getProjection();
        pj.toMapPixels(this.mMyLocation, this.mMapCoords);
        if (this.mDrawAccuracyEnabled) {
            float radius = lastFix.getAccuracy() / (float)TileSystem.GroundResolution(lastFix.getLatitude(), mapView.getZoomLevel());
            this.mCirclePaint.setAlpha(50);
            this.mCirclePaint.setStyle(Paint.Style.FILL);
            canvas.drawCircle((float)this.mMapCoords.x, (float)this.mMapCoords.y, radius, this.mCirclePaint);
            this.mCirclePaint.setAlpha(150);
            this.mCirclePaint.setStyle(Paint.Style.STROKE);
            canvas.drawCircle((float)this.mMapCoords.x, (float)this.mMapCoords.y, radius, this.mCirclePaint);
        }
        canvas.getMatrix(this.mMatrix);
        this.mMatrix.getValues(this.mMatrixValues);
        if (lastFix.hasBearing()) {
            this.directionRotater.setRotate(lastFix.getBearing(), this.DIRECTION_ARROW_CENTER_X, this.DIRECTION_ARROW_CENTER_Y);
            this.directionRotater.postTranslate(-this.DIRECTION_ARROW_CENTER_X, -this.DIRECTION_ARROW_CENTER_Y);
            this.directionRotater.postScale(1.0f / this.mMatrixValues[0], 1.0f / this.mMatrixValues[4]);
            this.directionRotater.postTranslate((float)this.mMapCoords.x, (float)this.mMapCoords.y);
            canvas.drawBitmap(this.DIRECTION_ARROW, this.directionRotater, this.mPaint);
        } else {
            this.directionRotater.setTranslate(-this.PERSON_HOTSPOT.x, -this.PERSON_HOTSPOT.y);
            this.directionRotater.postScale(1.0f / this.mMatrixValues[0], 1.0f / this.mMatrixValues[4]);
            this.directionRotater.postTranslate((float)this.mMapCoords.x, (float)this.mMapCoords.y);
            canvas.drawBitmap(this.PERSON_ICON, this.directionRotater, this.mPaint);
        }
    }

    protected void drawCompass(Canvas canvas, float bearing) {
        float centerX = this.mCompassCenterX * this.mScale;
        float centerY = this.mCompassCenterY * this.mScale + (float)(canvas.getHeight() - this.mMapView.getHeight());
        this.mCompassMatrix.setTranslate(-this.COMPASS_FRAME_CENTER_X, -this.COMPASS_FRAME_CENTER_Y);
        this.mCompassMatrix.postTranslate(centerX, centerY);
        canvas.save();
        canvas.setMatrix(this.mCompassMatrix);
        canvas.drawPicture(this.mCompassFrame);
        this.mCompassMatrix.setRotate(-bearing, this.COMPASS_ROSE_CENTER_X, this.COMPASS_ROSE_CENTER_Y);
        this.mCompassMatrix.postTranslate(-this.COMPASS_ROSE_CENTER_X, -this.COMPASS_ROSE_CENTER_Y);
        this.mCompassMatrix.postTranslate(centerX, centerY);
        canvas.setMatrix(this.mCompassMatrix);
        canvas.drawPicture(this.mCompassRose);
        canvas.restore();
    }

    @Override
    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (this.mLocation != null) {
            this.mMyLocation.setCoordsE6((int)(this.mLocation.getLatitude() * 1000000.0), (int)(this.mLocation.getLongitude() * 1000000.0));
            this.drawMyLocation(canvas, mapView, this.mLocation, this.mMyLocation);
        }
        if (this.isCompassEnabled() && !Float.isNaN(this.mAzimuth)) {
            this.drawCompass(canvas, this.mAzimuth + (float)this.getDisplayOrientation());
        }
    }

    public void onLocationChanged(Location location) {
        if (this.mIgnorer.shouldIgnore(location.getProvider(), System.currentTimeMillis())) {
            logger.debug("Ignore temporary non-gps location");
            return;
        }
        this.mLocation = location;
        if (this.mFollow) {
            this.mMapController.animateTo(location.getLatitude(), location.getLongitude());
        } else {
            this.mMapView.postInvalidate();
        }
        for (Runnable runnable : this.mRunOnFirstFix) {
            new Thread(runnable).start();
        }
        this.mRunOnFirstFix.clear();
    }

    public void onProviderDisabled(String provider) {
    }

    public void onProviderEnabled(String provider) {
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    public boolean onSnapToItem(int x, int y, Point snapPoint, IMapView mapView) {
        if (this.mLocation != null) {
            IProjection pj = mapView.getProjection();
            pj.toPixels(new GeoPoint(this.mLocation), this.mMapCoords);
            snapPoint.x = this.mMapCoords.x;
            snapPoint.y = this.mMapCoords.y;
            double xDiff = x - this.mMapCoords.x;
            double yDiff = y - this.mMapCoords.y;
            boolean snap = xDiff * xDiff + yDiff * yDiff < 64.0;
            return snap;
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        if (event.getAction() == 2) {
            this.disableFollowLocation();
        }
        return super.onTouchEvent(event, mapView);
    }

    public void onAccuracyChanged(Sensor arg0, int arg1) {
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 3 && event.values != null) {
            this.mAzimuth = event.values[0];
            this.mMapView.postInvalidate();
        }
    }

    @Override
    public void setOptionsMenuEnabled(boolean pOptionsMenuEnabled) {
        this.mOptionsMenuEnabled = pOptionsMenuEnabled;
    }

    @Override
    public boolean isOptionsMenuEnabled() {
        return this.mOptionsMenuEnabled;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.add(0, MENU_MY_LOCATION + pMenuIdOffset, 0, (CharSequence)this.mResourceProxy.getString(ResourceProxy.string.my_location)).setIcon(this.mResourceProxy.getDrawable(ResourceProxy.bitmap.ic_menu_mylocation));
        pMenu.add(0, MENU_COMPASS + pMenuIdOffset, 0, (CharSequence)this.mResourceProxy.getString(ResourceProxy.string.compass)).setIcon(this.mResourceProxy.getDrawable(ResourceProxy.bitmap.ic_menu_compass));
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        return false;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem pItem, int pMenuIdOffset, MapView pMapView) {
        int menuId = pItem.getItemId() - pMenuIdOffset;
        if (menuId == MENU_MY_LOCATION) {
            if (this.isMyLocationEnabled()) {
                this.disableFollowLocation();
                this.disableMyLocation();
            } else {
                this.enableFollowLocation();
                this.enableMyLocation();
            }
            return true;
        }
        if (menuId == MENU_COMPASS) {
            if (this.isCompassEnabled()) {
                this.disableCompass();
            } else {
                this.enableCompass();
            }
            return true;
        }
        return false;
    }

    public GeoPoint getMyLocation() {
        if (this.mLocation == null) {
            return null;
        }
        return new GeoPoint(this.mLocation);
    }

    @Override
    public Location getLastFix() {
        return this.mLocation;
    }

    @Deprecated
    public void followLocation(boolean follow) {
        if (follow) {
            this.enableFollowLocation();
        } else {
            this.disableFollowLocation();
        }
    }

    public void enableFollowLocation() {
        this.mFollow = true;
        if (this.isMyLocationEnabled()) {
            this.mLocation = LocationUtils.getLastKnownLocation(this.mLocationManager);
            if (this.mLocation != null) {
                this.mMapController.animateTo(new GeoPoint(this.mLocation));
            }
        }
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
    }

    public void disableFollowLocation() {
        this.mFollow = false;
    }

    public boolean isFollowLocationEnabled() {
        return this.mFollow;
    }

    @Override
    public boolean enableMyLocation() {
        boolean result = true;
        if (this.mLocationListener == null) {
            this.mLocationListener = new LocationListenerProxy(this.mLocationManager);
            result = this.mLocationListener.startListening(this, this.mLocationUpdateMinTime, this.mLocationUpdateMinDistance);
        }
        if (this.isFollowLocationEnabled()) {
            this.mLocation = LocationUtils.getLastKnownLocation(this.mLocationManager);
            if (this.mLocation != null) {
                this.mMapController.animateTo(new GeoPoint(this.mLocation));
            }
        }
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
        return result;
    }

    @Override
    public void disableMyLocation() {
        if (this.mLocationListener != null) {
            this.mLocationListener.stopListening();
        }
        this.mLocationListener = null;
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
    }

    @Override
    public boolean isMyLocationEnabled() {
        return this.mLocationListener != null;
    }

    @Override
    public boolean enableCompass() {
        boolean result = true;
        if (this.mSensorListener == null) {
            this.mSensorListener = new SensorEventListenerProxy(this.mSensorManager);
            result = this.mSensorListener.startListening(this, 3, 2);
        }
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
        return result;
    }

    @Override
    public void disableCompass() {
        if (this.mSensorListener != null) {
            this.mSensorListener.stopListening();
        }
        this.mSensorListener = null;
        this.mAzimuth = Float.NaN;
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
    }

    @Override
    public boolean isCompassEnabled() {
        return this.mSensorListener != null;
    }

    @Override
    public float getOrientation() {
        return this.mAzimuth;
    }

    @Override
    public boolean runOnFirstFix(Runnable runnable) {
        if (this.mLocationListener != null && this.mLocation != null) {
            new Thread(runnable).start();
            return true;
        }
        this.mRunOnFirstFix.addLast(runnable);
        return false;
    }

    private Point calculatePointOnCircle(float centerX, float centerY, float radius, float degrees) {
        double dblRadians = Math.toRadians(-degrees + 90.0f);
        int intX = (int)((double)radius * Math.cos(dblRadians));
        int intY = (int)((double)radius * Math.sin(dblRadians));
        return new Point((int)centerX + intX, (int)centerY - intY);
    }

    private void drawTriangle(Canvas canvas, float x, float y, float radius, float degrees, Paint paint) {
        canvas.save();
        Point point = this.calculatePointOnCircle(x, y, radius, degrees);
        canvas.rotate(degrees, (float)point.x, (float)point.y);
        Path p = new Path();
        p.moveTo((float)point.x - 2.0f * this.mScale, (float)point.y);
        p.lineTo((float)point.x + 2.0f * this.mScale, (float)point.y);
        p.lineTo((float)point.x, (float)point.y - 5.0f * this.mScale);
        p.close();
        canvas.drawPath(p, paint);
        canvas.restore();
    }

    private int getDisplayOrientation() {
        switch (this.mDisplay.getOrientation()) {
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    private void createCompassFramePicture() {
        Paint innerPaint = new Paint();
        innerPaint.setColor(-1);
        innerPaint.setAntiAlias(true);
        innerPaint.setStyle(Paint.Style.FILL);
        innerPaint.setAlpha(200);
        Paint outerPaint = new Paint();
        outerPaint.setColor(-7829368);
        outerPaint.setAntiAlias(true);
        outerPaint.setStyle(Paint.Style.STROKE);
        outerPaint.setStrokeWidth(2.0f);
        outerPaint.setAlpha(200);
        int picBorderWidthAndHeight = 50;
        int center = 25;
        Canvas canvas = this.mCompassFrame.beginRecording(50, 50);
        canvas.drawCircle(25.0f, 25.0f, 20.0f * this.mScale, innerPaint);
        canvas.drawCircle(25.0f, 25.0f, 20.0f * this.mScale, outerPaint);
        this.drawTriangle(canvas, 25.0f, 25.0f, 20.0f * this.mScale, 0.0f, outerPaint);
        this.drawTriangle(canvas, 25.0f, 25.0f, 20.0f * this.mScale, 90.0f, outerPaint);
        this.drawTriangle(canvas, 25.0f, 25.0f, 20.0f * this.mScale, 180.0f, outerPaint);
        this.drawTriangle(canvas, 25.0f, 25.0f, 20.0f * this.mScale, 270.0f, outerPaint);
        this.mCompassFrame.endRecording();
    }

    private void createCompassRosePicture() {
        Paint northPaint = new Paint();
        northPaint.setColor(-6291456);
        northPaint.setAntiAlias(true);
        northPaint.setStyle(Paint.Style.FILL);
        northPaint.setAlpha(220);
        Paint southPaint = new Paint();
        southPaint.setColor(-16777216);
        southPaint.setAntiAlias(true);
        southPaint.setStyle(Paint.Style.FILL);
        southPaint.setAlpha(220);
        Paint centerPaint = new Paint();
        centerPaint.setColor(-1);
        centerPaint.setAntiAlias(true);
        centerPaint.setStyle(Paint.Style.FILL);
        centerPaint.setAlpha(220);
        int picBorderWidthAndHeight = 50;
        int center = 25;
        Canvas canvas = this.mCompassRose.beginRecording(50, 50);
        Path pathNorth = new Path();
        pathNorth.moveTo(25.0f, 25.0f - 17.0f * this.mScale);
        pathNorth.lineTo(25.0f + 4.0f * this.mScale, 25.0f);
        pathNorth.lineTo(25.0f - 4.0f * this.mScale, 25.0f);
        pathNorth.lineTo(25.0f, 25.0f - 17.0f * this.mScale);
        pathNorth.close();
        canvas.drawPath(pathNorth, northPaint);
        Path pathSouth = new Path();
        pathSouth.moveTo(25.0f, 25.0f + 17.0f * this.mScale);
        pathSouth.lineTo(25.0f + 4.0f * this.mScale, 25.0f);
        pathSouth.lineTo(25.0f - 4.0f * this.mScale, 25.0f);
        pathSouth.lineTo(25.0f, 25.0f + 17.0f * this.mScale);
        pathSouth.close();
        canvas.drawPath(pathSouth, southPaint);
        canvas.drawCircle(25.0f, 25.0f, 2.0f, centerPaint);
        this.mCompassRose.endRecording();
    }
}

