/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import java.util.ArrayList;
import org.osmdroid.ResourceProxy;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.OverlayItem;

public abstract class ItemizedOverlay<Item extends OverlayItem>
extends Overlay
implements Overlay.Snappable {
    protected final Drawable mDefaultMarker;
    private final ArrayList<Item> mInternalItemList;
    private final Rect mRect = new Rect();
    private final Point mCurScreenCoords = new Point();
    protected boolean mDrawFocusedItem = true;
    private Item mFocusedItem;

    protected abstract Item createItem(int var1);

    public abstract int size();

    public ItemizedOverlay(Drawable pDefaultMarker, ResourceProxy pResourceProxy) {
        super(pResourceProxy);
        if (pDefaultMarker == null) {
            throw new IllegalArgumentException("You must pass a default marker to ItemizedOverlay.");
        }
        this.mDefaultMarker = pDefaultMarker;
        this.mInternalItemList = new ArrayList();
    }

    @Override
    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        int size;
        if (shadow) {
            return;
        }
        MapView.Projection pj = mapView.getProjection();
        for (int i = size = this.mInternalItemList.size() - 1; i >= 0; --i) {
            Item item = this.getItem(i);
            pj.toMapPixels(((OverlayItem)item).mGeoPoint, this.mCurScreenCoords);
            this.onDrawItem(canvas, item, this.mCurScreenCoords);
        }
    }

    protected final void populate() {
        int size = this.size();
        this.mInternalItemList.clear();
        this.mInternalItemList.ensureCapacity(size);
        for (int a = 0; a < size; ++a) {
            this.mInternalItemList.add(this.createItem(a));
        }
    }

    public final Item getItem(int position) {
        return (Item)((OverlayItem)this.mInternalItemList.get(position));
    }

    protected void onDrawItem(Canvas canvas, Item item, Point curScreenCoords) {
        int state = this.mDrawFocusedItem && this.mFocusedItem == item ? 4 : 0;
        Drawable marker = ((OverlayItem)item).getMarker(state) == null ? this.getDefaultMarker(state) : ((OverlayItem)item).getMarker(state);
        OverlayItem.HotspotPlace hotspot = ((OverlayItem)item).getMarkerHotspot();
        this.boundToHotspot(marker, hotspot);
        Overlay.drawAt(canvas, marker, curScreenCoords.x, curScreenCoords.y, false);
    }

    private Drawable getDefaultMarker(int state) {
        OverlayItem.setState(this.mDefaultMarker, state);
        return this.mDefaultMarker;
    }

    protected boolean hitTest(Item item, Drawable marker, int hitX, int hitY) {
        return marker.getBounds().contains(hitX, hitY);
    }

    public void setDrawFocusedItem(boolean drawFocusedItem) {
        this.mDrawFocusedItem = drawFocusedItem;
    }

    public void setFocus(Item item) {
        this.mFocusedItem = item;
    }

    public Item getFocus() {
        return this.mFocusedItem;
    }

    protected synchronized Drawable boundToHotspot(Drawable marker, OverlayItem.HotspotPlace hotspot) {
        int markerWidth = (int)((float)marker.getIntrinsicWidth() * this.mScale);
        int markerHeight = (int)((float)marker.getIntrinsicHeight() * this.mScale);
        this.mRect.set(0, 0, 0 + markerWidth, 0 + markerHeight);
        if (hotspot == null) {
            hotspot = OverlayItem.HotspotPlace.BOTTOM_CENTER;
        }
        switch (hotspot) {
            default: {
                break;
            }
            case CENTER: {
                this.mRect.offset(-markerWidth / 2, -markerHeight / 2);
                break;
            }
            case BOTTOM_CENTER: {
                this.mRect.offset(-markerWidth / 2, -markerHeight);
                break;
            }
            case TOP_CENTER: {
                this.mRect.offset(-markerWidth / 2, 0);
                break;
            }
            case RIGHT_CENTER: {
                this.mRect.offset(-markerWidth, -markerHeight / 2);
                break;
            }
            case LEFT_CENTER: {
                this.mRect.offset(0, -markerHeight / 2);
                break;
            }
            case UPPER_RIGHT_CORNER: {
                this.mRect.offset(-markerWidth, 0);
                break;
            }
            case LOWER_RIGHT_CORNER: {
                this.mRect.offset(-markerWidth, -markerHeight);
                break;
            }
            case UPPER_LEFT_CORNER: {
                this.mRect.offset(0, 0);
                break;
            }
            case LOWER_LEFT_CORNER: {
                this.mRect.offset(0, -markerHeight);
            }
        }
        marker.setBounds(this.mRect);
        return marker;
    }
}

