/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.drawable.Drawable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTileProviderArray
extends MapTileProviderBase {
    private final ConcurrentHashMap<MapTileRequestState, MapTile> mWorking = new ConcurrentHashMap();
    private static final Logger logger = LoggerFactory.getLogger(MapTileProviderArray.class);
    protected final List<MapTileModuleProviderBase> mTileProviderList = new ArrayList<MapTileModuleProviderBase>();

    protected MapTileProviderArray(ITileSource pTileSource, IRegisterReceiver pRegisterReceiver) {
        this(pTileSource, pRegisterReceiver, new MapTileModuleProviderBase[0]);
    }

    public MapTileProviderArray(ITileSource pTileSource, IRegisterReceiver aRegisterReceiver, MapTileModuleProviderBase[] pTileProviderArray) {
        super(pTileSource);
        Collections.addAll(this.mTileProviderList, pTileProviderArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() {
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                tileProvider.detach();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Drawable getMapTile(MapTile pTile) {
        Drawable tile = this.mTileCache.getMapTile(pTile);
        if (tile != null && !ExpirableBitmapDrawable.isDrawableExpired(tile)) {
            return tile;
        }
        boolean alreadyInProgress = false;
        ConcurrentHashMap<MapTileRequestState, MapTile> concurrentHashMap = this.mWorking;
        synchronized (concurrentHashMap) {
            alreadyInProgress = this.mWorking.containsValue(pTile);
        }
        if (!alreadyInProgress) {
            MapTileRequestState state;
            Object object = this.mTileProviderList;
            synchronized (object) {
                MapTileModuleProviderBase[] providerArray = new MapTileModuleProviderBase[this.mTileProviderList.size()];
                state = new MapTileRequestState(pTile, this.mTileProviderList.toArray(providerArray), this);
            }
            object = this.mWorking;
            synchronized (object) {
                alreadyInProgress = this.mWorking.containsValue(pTile);
                if (alreadyInProgress) {
                    return null;
                }
                this.mWorking.put(state, pTile);
            }
            MapTileModuleProviderBase provider = this.findNextAppropriateProvider(state);
            if (provider != null) {
                provider.loadMapTileAsync(state);
            } else {
                this.mapTileRequestFailed(state);
            }
        }
        return tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapTileRequestCompleted(MapTileRequestState aState, Drawable aDrawable) {
        ConcurrentHashMap<MapTileRequestState, MapTile> concurrentHashMap = this.mWorking;
        synchronized (concurrentHashMap) {
            this.mWorking.remove(aState);
        }
        super.mapTileRequestCompleted(aState, aDrawable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapTileRequestFailed(MapTileRequestState aState) {
        MapTileModuleProviderBase nextProvider = this.findNextAppropriateProvider(aState);
        if (nextProvider != null) {
            nextProvider.loadMapTileAsync(aState);
        } else {
            ConcurrentHashMap<MapTileRequestState, MapTile> concurrentHashMap = this.mWorking;
            synchronized (concurrentHashMap) {
                this.mWorking.remove(aState);
            }
            super.mapTileRequestFailed(aState);
        }
    }

    protected MapTileModuleProviderBase findNextAppropriateProvider(MapTileRequestState aState) {
        MapTileModuleProviderBase provider = null;
        while ((provider = aState.getNextProvider()) != null && (!this.getProviderExists(provider) || !this.useDataConnection() && provider.getUsesDataConnection())) {
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getProviderExists(MapTileModuleProviderBase provider) {
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            return this.mTileProviderList.contains(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMinimumZoomLevel() {
        int result = 22;
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                if (tileProvider.getMinimumZoomLevel() >= result) continue;
                result = tileProvider.getMinimumZoomLevel();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaximumZoomLevel() {
        int result = 0;
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                if (tileProvider.getMaximumZoomLevel() <= result) continue;
                result = tileProvider.getMaximumZoomLevel();
            }
        }
        return result;
    }

    @Override
    public void setTileSource(ITileSource aTileSource) {
        super.setTileSource(aTileSource);
        for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
            tileProvider.setTileSource(aTileSource);
            this.clearTileCache();
        }
    }
}

