/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.drawable.Drawable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTileProviderArray
extends MapTileProviderBase {
    protected final HashMap<MapTile, MapTileRequestState> mWorking = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(MapTileProviderArray.class);
    protected final List<MapTileModuleProviderBase> mTileProviderList = new ArrayList<MapTileModuleProviderBase>();

    protected MapTileProviderArray(ITileSource pTileSource, IRegisterReceiver pRegisterReceiver) {
        this(pTileSource, pRegisterReceiver, new MapTileModuleProviderBase[0]);
    }

    public MapTileProviderArray(ITileSource pTileSource, IRegisterReceiver aRegisterReceiver, MapTileModuleProviderBase[] pTileProviderArray) {
        super(pTileSource);
        Collections.addAll(this.mTileProviderList, pTileProviderArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() {
        Object object = this.mTileProviderList;
        synchronized (object) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                tileProvider.detach();
            }
        }
        object = this.mWorking;
        synchronized (object) {
            this.mWorking.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Drawable getMapTile(MapTile pTile) {
        Drawable tile = this.mTileCache.getMapTile(pTile);
        if (tile != null && !ExpirableBitmapDrawable.isDrawableExpired(tile)) {
            return tile;
        }
        boolean alreadyInProgress = false;
        HashMap<MapTile, MapTileRequestState> hashMap = this.mWorking;
        synchronized (hashMap) {
            alreadyInProgress = this.mWorking.containsKey(pTile);
        }
        if (!alreadyInProgress) {
            MapTileRequestState state;
            Object object = this.mTileProviderList;
            synchronized (object) {
                MapTileModuleProviderBase[] providerArray = new MapTileModuleProviderBase[this.mTileProviderList.size()];
                state = new MapTileRequestState(pTile, this.mTileProviderList.toArray(providerArray), this);
            }
            object = this.mWorking;
            synchronized (object) {
                alreadyInProgress = this.mWorking.containsKey(pTile);
                if (alreadyInProgress) {
                    return null;
                }
                this.mWorking.put(pTile, state);
            }
            MapTileModuleProviderBase provider = this.findNextAppropriateProvider(state);
            if (provider != null) {
                provider.loadMapTileAsync(state);
            } else {
                this.mapTileRequestFailed(state);
            }
        }
        return tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapTileRequestCompleted(MapTileRequestState aState, Drawable aDrawable) {
        HashMap<MapTile, MapTileRequestState> hashMap = this.mWorking;
        synchronized (hashMap) {
            this.mWorking.remove(aState.getMapTile());
        }
        super.mapTileRequestCompleted(aState, aDrawable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapTileRequestFailed(MapTileRequestState aState) {
        MapTileModuleProviderBase nextProvider = this.findNextAppropriateProvider(aState);
        if (nextProvider != null) {
            nextProvider.loadMapTileAsync(aState);
        } else {
            HashMap<MapTile, MapTileRequestState> hashMap = this.mWorking;
            synchronized (hashMap) {
                this.mWorking.remove(aState.getMapTile());
            }
            super.mapTileRequestFailed(aState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapTileRequestExpiredTile(MapTileRequestState aState, Drawable aDrawable) {
        super.mapTileRequestExpiredTile(aState, aDrawable);
        MapTileModuleProviderBase nextProvider = this.findNextAppropriateProvider(aState);
        if (nextProvider != null) {
            nextProvider.loadMapTileAsync(aState);
        } else {
            HashMap<MapTile, MapTileRequestState> hashMap = this.mWorking;
            synchronized (hashMap) {
                this.mWorking.remove(aState.getMapTile());
            }
        }
    }

    protected MapTileModuleProviderBase findNextAppropriateProvider(MapTileRequestState aState) {
        MapTileModuleProviderBase provider = null;
        boolean providerDoesntExist = false;
        boolean providerCantGetDataConnection = false;
        boolean providerCantServiceZoomlevel = false;
        do {
            if ((provider = aState.getNextProvider()) == null) continue;
            providerDoesntExist = !this.getProviderExists(provider);
            providerCantGetDataConnection = !this.useDataConnection() && provider.getUsesDataConnection();
            int zoomLevel = aState.getMapTile().getZoomLevel();
            boolean bl = providerCantServiceZoomlevel = zoomLevel > provider.getMaximumZoomLevel() || zoomLevel < provider.getMinimumZoomLevel();
        } while (provider != null && (providerDoesntExist || providerCantGetDataConnection || providerCantServiceZoomlevel));
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getProviderExists(MapTileModuleProviderBase provider) {
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            return this.mTileProviderList.contains(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMinimumZoomLevel() {
        int result = 22;
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                if (tileProvider.getMinimumZoomLevel() >= result) continue;
                result = tileProvider.getMinimumZoomLevel();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaximumZoomLevel() {
        int result = 0;
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                if (tileProvider.getMaximumZoomLevel() <= result) continue;
                result = tileProvider.getMaximumZoomLevel();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTileSource(ITileSource aTileSource) {
        super.setTileSource(aTileSource);
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                tileProvider.setTileSource(aTileSource);
                this.clearTileCache();
            }
        }
    }
}

