/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.http;

import java.util.Locale;
import org.osgl.$;
import org.osgl.cache.CacheService;
import org.osgl.http.CurrentStateStore;
import org.osgl.http.H;
import org.osgl.http.HttpClient;
import org.osgl.util.E;
import org.osgl.util.S;

public class HttpConfig {
    private static CacheService sessionCache;
    private static Locale defLocale;
    private static String domain;
    private static int nonSecurePort;
    public static int securePort;
    public static boolean secure;
    public static String ctx;
    private static String acceptOverrideParamName;
    private static String xForwardedAllowed;
    private static boolean extensiveRemoteAddrResolving;
    private static boolean cookieSecure;
    private static boolean cookieHttpOnly;
    private static HttpClient httpClient;

    public static void setSessionCache(CacheService cache) {
        sessionCache = (CacheService)$.requireNotNull((Object)cache);
    }

    public static CacheService sessionCache() {
        return sessionCache;
    }

    public static void defaultLocale(Locale locale) {
        E.NPE((Object)locale);
        defLocale = locale;
    }

    public static Locale defaultLocale() {
        return defLocale;
    }

    public static void setCurrentStateStore(CurrentStateStore currentStateStore) {
        H.setCurrentStateStore(currentStateStore);
    }

    public static void domain(String domain) {
        E.npeIf((boolean)S.blank((String)domain));
        HttpConfig.domain = domain;
    }

    public static String domain() {
        E.illegalStateIf((boolean)S.blank((String)domain), (String)"domain has not been configured");
        return domain;
    }

    public static void nonSecurePort(int port) {
        E.illegalArgumentIf((port < 1 || port > 65535 ? 1 : 0) != 0, (String)"port specified is out of range: %s", (Object[])new Object[]{port});
        nonSecurePort = port;
    }

    public static int nonSecurePort() {
        return 0 < nonSecurePort ? nonSecurePort : 80;
    }

    public static int port() {
        return secure ? securePort : nonSecurePort;
    }

    public static void securePort(int port) {
        E.illegalArgumentIf((port < 1 || port > 65535 ? 1 : 0) != 0, (String)"port specified is out of range: %s", (Object[])new Object[]{port});
        securePort = port;
    }

    public static int securePort() {
        return securePort;
    }

    public static void secure(boolean setting) {
        secure = setting;
    }

    public static boolean secure() {
        return secure;
    }

    public static void contextPath(String context) {
        if (S.blank((String)context)) {
            ctx = "";
        } else {
            E.illegalArgumentIf((!context.startsWith("/") ? 1 : 0) != 0, (String)"context path should start with \"/\"");
            if (context.endsWith("/")) {
                ctx = S.str((Object)context).beforeLast("/").toString();
            }
        }
    }

    public static String contextPath() {
        return ctx;
    }

    public static String acceptOverrideParamName() {
        return acceptOverrideParamName;
    }

    public static void acceptOverrideParamName(String paramName) {
        acceptOverrideParamName = paramName;
    }

    public static void setXForwardedAllowed(String allowed) {
        xForwardedAllowed = allowed;
    }

    public static boolean isXForwardedAllowed() {
        return S.notBlank((String)xForwardedAllowed);
    }

    public static boolean isXForwardedAllowed(String remoteAddr) {
        return HttpConfig.isXForwardedAllowed() && (S.eq((String)"all", (String)xForwardedAllowed) || xForwardedAllowed.contains(remoteAddr));
    }

    public static void setExtensiveRemoteAddrResolving(boolean setting) {
        extensiveRemoteAddrResolving = setting;
    }

    public static boolean allowExtensiveRemoteAddrResolving() {
        return extensiveRemoteAddrResolving;
    }

    public static boolean isCookieSecure() {
        return cookieSecure;
    }

    public static void setCookieSecure(boolean secure) {
        cookieSecure = secure;
    }

    public static boolean isCookieHttpOnly() {
        return cookieHttpOnly;
    }

    public static void setCookieHttpOnly(boolean httpOnly) {
        cookieHttpOnly = httpOnly;
    }

    public static void setHttpClient(HttpClient client) {
        httpClient = (HttpClient)$.requireNotNull((Object)client);
    }

    static {
        defLocale = Locale.getDefault();
        acceptOverrideParamName = "_accept";
        xForwardedAllowed = "all";
        extensiveRemoteAddrResolving = false;
    }
}

