/*
 * Copyright (c) OSGi Alliance (2018). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.osgi.service.cdi.annotations;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.CLASS;
import static org.osgi.namespace.implementation.ImplementationNamespace.IMPLEMENTATION_NAMESPACE;
import static org.osgi.service.cdi.CDIConstants.*;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.osgi.annotation.bundle.Requirement;

/**
 * This annotation can be used to require the CDI Component Runtime
 * implementation. It can be used directly, or as a meta-annotation.
 *
 * @author $Id: 1f486c85237b8fb8fc2024acf3ca123d7078b22f $
 */
@Documented
@Retention(CLASS)
@Target({
		TYPE, PACKAGE
})
@Requirement(
		namespace = IMPLEMENTATION_NAMESPACE,
		name = CDI_CAPABILITY_NAME,
		version = CDI_SPECIFICATION_VERSION)
public @interface RequireCDIImplementation {
	// A marker annotation.
}
