/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit4.context;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectInstallBundle;
import org.osgi.test.common.context.CloseableBundleContext;
import org.osgi.test.common.inject.FieldInjector;
import org.osgi.test.common.install.InstallBundle;

public class BundleContextRule
implements AutoCloseable,
MethodRule {
    private volatile BundleContext bundleContext;
    private volatile InstallBundle installBundle;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public BundleContextRule init(Object testInstance) {
        if (this.bundleContext != null) {
            return this;
        }
        BundleContext bundleContext = CloseableBundleContext.proxy(testInstance.getClass(), (BundleContext)FrameworkUtil.getBundle(testInstance.getClass()).getBundleContext());
        this.installBundle = new InstallBundle(bundleContext);
        List fields = FieldInjector.findAnnotatedNonStaticFields(testInstance.getClass(), InjectBundleContext.class);
        fields.forEach(field -> {
            this.assertFieldIsBundleContext((Field)field);
            FieldInjector.setField((Field)field, (Object)testInstance, (Object)bundleContext);
        });
        fields = FieldInjector.findAnnotatedNonStaticFields(testInstance.getClass(), InjectInstallBundle.class);
        fields.forEach(field -> {
            this.assertFieldIsInstallBundle((Field)field);
            FieldInjector.setField((Field)field, (Object)testInstance, (Object)this.installBundle);
        });
        this.bundleContext = bundleContext;
        return this;
    }

    @Override
    public void close() throws Exception {
        if (this.bundleContext != null) {
            ((AutoCloseable)this.bundleContext).close();
            this.bundleContext = null;
            this.installBundle = null;
        }
    }

    public Statement apply(final Statement statement, FrameworkMethod method, Object testInstance) {
        this.init(testInstance);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    statement.evaluate();
                }
                finally {
                    BundleContextRule.this.close();
                }
            }
        };
    }

    private void assertIsBundleContext(Class<?> type) {
        if (type != BundleContext.class) {
            throw new RuntimeException("Can only resolve @" + InjectBundleContext.class.getSimpleName() + " field of type " + BundleContext.class.getName() + " but was: " + type.getName());
        }
    }

    private void assertIsInstallBundle(Class<?> type) {
        if (type != InstallBundle.class) {
            throw new RuntimeException("Can only resolve @" + InjectInstallBundle.class.getSimpleName() + " field of type " + InstallBundle.class.getName() + " but was: " + type.getName());
        }
    }

    private void assertFieldIsBundleContext(Field field) {
        this.assertIsBundleContext(field.getType());
        if (Modifier.isFinal(field.getModifiers()) || Modifier.isPrivate(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            throw new RuntimeException(InjectBundleContext.class.getName() + " field [" + field + "] must not be final, private or static.");
        }
    }

    private void assertFieldIsInstallBundle(Field field) {
        this.assertIsInstallBundle(field.getType());
        if (Modifier.isFinal(field.getModifiers()) || Modifier.isPrivate(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            throw new RuntimeException(InjectInstallBundle.class.getName() + " field [" + field + "] must not be final, private or static.");
        }
    }
}

