/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.install;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.test.common.exceptions.Exceptions;

public class BundleInstaller {
    private final BundleContext bundleContext;

    public BundleInstaller(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Bundle installBundle(EmbeddedLocation location, boolean startBundle) {
        Bundle bundle;
        block9: {
            InputStream is = location.openStream(this.bundleContext);
            try {
                Bundle bundle2 = this.bundleContext.installBundle(location.toString(), is);
                if (startBundle) {
                    bundle2.start();
                }
                bundle = bundle2;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
            }
            is.close();
        }
        return bundle;
    }

    public Bundle installBundle(String pathToEmbeddedJar) {
        return this.installBundle(pathToEmbeddedJar, true);
    }

    public Bundle installBundle(String pathToEmbeddedJar, boolean startBundle) {
        String[] stringArray;
        int lastIndexOf = pathToEmbeddedJar.lastIndexOf(47);
        if (lastIndexOf == -1) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "/";
            stringArray = stringArray2;
            stringArray2[1] = pathToEmbeddedJar;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = pathToEmbeddedJar.substring(0, lastIndexOf);
            stringArray = stringArray3;
            stringArray3[1] = pathToEmbeddedJar.substring(lastIndexOf + 1);
        }
        String[] parts = stringArray;
        return this.installBundle(EmbeddedLocation.of(this.bundleContext, pathToEmbeddedJar), startBundle);
    }

    public Bundle installBundle(URL url, boolean startBundle) {
        Bundle bundle;
        block9: {
            InputStream is = url.openStream();
            try {
                Bundle bundle2 = this.bundleContext.installBundle(url.toString(), is);
                if (startBundle) {
                    bundle2.start();
                }
                bundle = bundle2;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
            }
            is.close();
        }
        return bundle;
    }

    public static class EmbeddedLocation {
        private final String bundleSymbolicName;
        private final Version bundleVersion;
        private final String file;
        private final String path;

        private static Optional<Bundle> findBundle(BundleContext bc, String bundleSymbolicName, Version bundleVersion) {
            return Stream.of(bc.getBundles()).filter(b -> b.getSymbolicName().equals(bundleSymbolicName)).filter(b -> b.getVersion().equals((Object)bundleVersion)).findAny();
        }

        public static EmbeddedLocation of(BundleContext bundleContext, Optional<String> oBundleSymbolicName, Optional<String> oBundleVersion, Optional<String> oPath, String file) {
            Version bundleVersion;
            String bundleSymbolicName;
            if (oBundleSymbolicName.isPresent()) {
                bundleSymbolicName = oBundleSymbolicName.get();
                bundleVersion = oBundleVersion.map(v -> Version.parseVersion((String)v)).orElseGet(() -> Stream.of(bundleContext.getBundles()).filter(b -> b.getSymbolicName().equals(bundleSymbolicName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown Bundle with SymbolicName: %s", bundleSymbolicName))).getVersion());
            } else {
                Bundle bundle = bundleContext.getBundle();
                bundleSymbolicName = bundle.getSymbolicName();
                bundleVersion = oBundleVersion.map(v -> Version.parseVersion((String)v)).orElse(bundle.getVersion());
            }
            EmbeddedLocation.findBundle(bundleContext, bundleSymbolicName, bundleVersion).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown Bundle with SymbolicName '%s' and Version: '%s'", bundleSymbolicName, bundleVersion)));
            return new EmbeddedLocation(bundleSymbolicName, bundleVersion, oPath.orElse("/"), file);
        }

        public static EmbeddedLocation of(BundleContext bundleContext, String spec) throws IllegalArgumentException {
            String fullPath;
            Optional<String> oBundleVersion;
            Optional<String> oBundleSymbolicName;
            String[] parts = spec.split(":");
            if (parts.length == 1) {
                oBundleSymbolicName = Optional.empty();
                oBundleVersion = Optional.empty();
                fullPath = parts[0];
            } else if (parts.length == 2) {
                oBundleSymbolicName = Optional.of(parts[0]);
                oBundleVersion = Optional.empty();
                fullPath = parts[1];
            } else if (parts.length == 3) {
                oBundleSymbolicName = Optional.of(parts[0]);
                oBundleVersion = Optional.of(parts[1]);
                fullPath = parts[2];
            } else {
                throw new IllegalArgumentException("Wrong pattern :" + spec);
            }
            int indexOfFileBegin = fullPath.lastIndexOf(47) + 1;
            String file = fullPath.substring(indexOfFileBegin);
            if (file.isEmpty()) {
                throw new IllegalArgumentException(String.format("could not find a filename : ", spec));
            }
            Optional<String> oPath = Optional.of(fullPath.substring(0, indexOfFileBegin));
            return EmbeddedLocation.of(bundleContext, oBundleSymbolicName, oBundleVersion, oPath, file);
        }

        public static EmbeddedLocation of(String bundleSymbolicName, Version bundleVersion, String path, String file) {
            return new EmbeddedLocation(bundleSymbolicName, bundleVersion, path, file);
        }

        private EmbeddedLocation(String bundleSymbolicName, Version bundleVersion, String path, String file) {
            Objects.requireNonNull(bundleSymbolicName, "bundleSymbolicName must not be null");
            Objects.requireNonNull(bundleVersion, "bundleVersion must not be null");
            Objects.requireNonNull(path, "path must not be null");
            Objects.requireNonNull(file, "file must not be null");
            this.bundleSymbolicName = bundleSymbolicName;
            this.bundleVersion = bundleVersion;
            path = path.startsWith("/") ? path.substring(1) : path;
            this.path = path = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            if (file.startsWith("/")) {
                file = file.substring(1);
            }
            this.file = file;
        }

        public boolean equals(Object obj) {
            if (obj instanceof EmbeddedLocation) {
                EmbeddedLocation other = (EmbeddedLocation)obj;
                return Objects.equals(this.bundleSymbolicName, other.bundleSymbolicName) && Objects.equals(this.bundleVersion, other.bundleVersion) && Objects.equals(this.file, other.file) && Objects.equals(this.path, other.path);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.bundleSymbolicName, this.bundleVersion, this.file, this.path);
        }

        public InputStream openStream(BundleContext bc) throws IOException {
            Bundle bundle = Stream.of(bc.getBundles()).filter(b -> b.getSymbolicName().equals(this.bundleSymbolicName)).filter(b -> b.getVersion().equals((Object)this.bundleVersion)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Bundle %s:%s does not exist in framework", this.bundleSymbolicName, this.bundleVersion)));
            Enumeration entries = bundle.findEntries(this.path, this.file, false);
            Stream entryStream = entries == null ? Stream.empty() : Collections.list(entries).stream();
            URL jarEmbeddedFileUrl = (URL)entryStream.findFirst().orElseThrow(() -> new FileNotFoundException(String.format("File [%s/%s] not found in Bundle [%s:%s]", this.path, this.file, bundle.getSymbolicName(), bundle.getVersion())));
            return jarEmbeddedFileUrl.openStream();
        }

        public String toString() {
            return String.format("bundle:" + this.bundleSymbolicName + ":" + this.bundleVersion + ":" + this.path + "/" + this.file, new Object[0]);
        }
    }
}

