/*
 * Coordinate Transformations Suite (abridged CTS)  is a library developped to 
 * perform Coordinate Transformations using well known geodetic algorithms 
 * and parameter sets. 
 * Its main focus are simplicity, flexibility, interoperability, in this order.
 *
 * This library has been originally developed by Michaël Michaud under the JGeod
 * name. It has been renamed CTS in 2009 and shared to the community from 
 * the OrbisGIS code repository.
 *
 * CTS is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License.
 *
 * CTS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * CTS. If not, see <http://www.gnu.org/licenses/>.
 *
 * For more information, please consult: <https://github.com/orbisgis/cts/>
 */

package org.cts.parser.proj;

/**
 *
 * @author Erwan Bocher
 */
public class ProjValueParameters {

    //+proj value parameters
    public static String LONGLAT = "longlat";
    public static String GEOCENT = "geocent";
    public static String TMERC = "tmerc";
    public static String MILL = "mill";
    public static String STERE = "stere";
    public static String STEREA = "sterea";
    public static String LCC = "lcc";
    public static String GSTMERC = "gstmerc";
    public static String LAEA = "laea";
    public static String EQC = "eqc";
    public static String KROVAK = "krovak";
    public static String CEA = "cea";
    public static String CASS = "cass";
    public static String AEA = "aea";
    public static String SOMERC = "somerc";
    public static String OMERC = "omerc";
    public static String POLY = "poly";
    public static String MERC = "merc";
    public static String NZMG = "nzmg";
    public static String UTM = "utm";
    public static String LEAC = "leac";
    //Unit values
    public static String M = "m";
    public static String RAD = "rad";
}
