/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.models.datamodel.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;

public final class TemplateUtils {
    private TemplateUtils() {
    }

    public static Collection<InterpolationVariable> extractInterpolationVariables(String text) {
        int end;
        if (text == null || text.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<InterpolationVariable> interpolationVariableList = new ArrayList<InterpolationVariable>();
        int pos = 0;
        while ((pos = text.indexOf("@{", pos)) != -1 && (end = text.indexOf(125, pos + 2)) != -1) {
            String varName = text.substring(pos + 2, end);
            pos = end + 1;
            InterpolationVariable var = new InterpolationVariable(varName, "Object");
            interpolationVariableList.add(var);
        }
        return interpolationVariableList;
    }

    public static String substituteTemplateVariable(String text, Function<String, String> keyToValueFunction) {
        int end;
        int pos;
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder resultBuilder = new StringBuilder(text);
        while ((pos = resultBuilder.indexOf("@{")) != -1 && (end = resultBuilder.indexOf("}", pos + 2)) != -1) {
            String varName = resultBuilder.substring(pos + 2, end);
            String value = keyToValueFunction.apply(varName);
            if (value == null) {
                return text;
            }
            resultBuilder.replace(pos, end + 1, value);
        }
        return resultBuilder.toString();
    }
}

