/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.test.impl.score.stream.DefaultMultiConstraintVerification;
import org.optaplanner.test.impl.score.stream.DefaultSingleConstraintVerification;
import org.optaplanner.test.impl.score.stream.ScoreDirectorFactoryCache;

final class ConfiguredConstraintVerifier<ConstraintProvider_ extends ConstraintProvider, Solution_, Score_ extends Score<Score_>> {
    private final String defaultScoreDirectorFactoryMapKey = UUID.randomUUID().toString();
    private final ConstraintProvider_ constraintProvider;
    private final ThreadLocal<ScoreDirectorFactoryCache<ConstraintProvider_, Solution_, Score_>> scoreDirectorFactoryContainerThreadLocal;
    private final ConstraintStreamImplType constraintStreamImplType;
    private final boolean droolsAlphaNetworkCompilationEnabled;

    public ConfiguredConstraintVerifier(ConstraintProvider_ constraintProvider, SolutionDescriptor<Solution_> solutionDescriptor, ConstraintStreamImplType constraintStreamImplType, boolean droolsAlphaNetworkCompilationEnabled) {
        this.constraintProvider = constraintProvider;
        this.scoreDirectorFactoryContainerThreadLocal = ThreadLocal.withInitial(() -> new ScoreDirectorFactoryCache(this, solutionDescriptor));
        this.constraintStreamImplType = constraintStreamImplType;
        this.droolsAlphaNetworkCompilationEnabled = droolsAlphaNetworkCompilationEnabled;
    }

    public ConstraintStreamImplType getConstraintStreamImplType() {
        return this.constraintStreamImplType;
    }

    public boolean getDroolsAlphaNetworkCompilationEnabled() {
        return this.droolsAlphaNetworkCompilationEnabled;
    }

    public DefaultSingleConstraintVerification<Solution_, Score_> verifyThat(BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction) {
        Objects.requireNonNull(constraintFunction);
        AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory = this.scoreDirectorFactoryContainerThreadLocal.get().getScoreDirectorFactory(constraintFunction, this.constraintProvider, EnvironmentMode.FULL_ASSERT);
        return new DefaultSingleConstraintVerification<Solution_, Score_>(scoreDirectorFactory);
    }

    public DefaultMultiConstraintVerification<Solution_, Score_> verifyThat() {
        AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory = this.scoreDirectorFactoryContainerThreadLocal.get().getScoreDirectorFactory(this.defaultScoreDirectorFactoryMapKey, (ConstraintProvider)this.constraintProvider, EnvironmentMode.FULL_ASSERT);
        return new DefaultMultiConstraintVerification<Solution_, Score_>(scoreDirectorFactory, (ConstraintProvider)this.constraintProvider);
    }
}

