/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.penta;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.penta.AbstractPentaJoiner;
import org.optaplanner.core.impl.score.stream.penta.SinglePentaJoiner;

public final class CompositePentaJoiner<A, B, C, D, E>
extends AbstractPentaJoiner<A, B, C, D, E> {
    private final List<SinglePentaJoiner<A, B, C, D, E>> joinerList;
    private final JoinerType[] joinerTypes;
    private final QuadFunction<A, B, C, D, ?>[] leftMappings;
    private final Function<E, ?>[] rightMappings;

    CompositePentaJoiner(List<SinglePentaJoiner<A, B, C, D, E>> joinerList) {
        if (joinerList.isEmpty()) {
            throw new IllegalArgumentException("The joinerList (" + joinerList + ") must not be empty.");
        }
        this.joinerList = joinerList;
        this.joinerTypes = (JoinerType[])joinerList.stream().map(SinglePentaJoiner::getJoinerType).toArray(JoinerType[]::new);
        this.leftMappings = (QuadFunction[])joinerList.stream().map(SinglePentaJoiner::getLeftMapping).toArray(QuadFunction[]::new);
        this.rightMappings = (Function[])joinerList.stream().map(SinglePentaJoiner::getRightMapping).toArray(Function[]::new);
    }

    public List<SinglePentaJoiner<A, B, C, D, E>> getJoinerList() {
        return this.joinerList;
    }

    @Override
    public QuadFunction<A, B, C, D, Object> getLeftMapping(int index) {
        return this.leftMappings[index];
    }

    @Override
    public QuadFunction<A, B, C, D, Object[]> getLeftCombinedMapping() {
        return (a, b, c, d) -> Arrays.stream(this.leftMappings).map(f -> f.apply(a, b, c, d)).toArray();
    }

    @Override
    public JoinerType[] getJoinerTypes() {
        return this.joinerTypes;
    }

    @Override
    public Function<E, Object> getRightMapping(int index) {
        return this.rightMappings[index];
    }

    @Override
    public Function<E, Object[]> getRightCombinedMapping() {
        return e -> Arrays.stream(this.rightMappings).map(f -> f.apply(e)).toArray();
    }
}

