/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.penta;

import java.util.ArrayList;
import java.util.function.Function;
import org.optaplanner.core.api.function.PentaPredicate;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.score.stream.penta.PentaJoiner;
import org.optaplanner.core.impl.score.stream.common.AbstractJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.penta.CompositePentaJoiner;
import org.optaplanner.core.impl.score.stream.penta.NonePentaJoiner;
import org.optaplanner.core.impl.score.stream.penta.SinglePentaJoiner;

public abstract class AbstractPentaJoiner<A, B, C, D, E>
extends AbstractJoiner
implements PentaJoiner<A, B, C, D, E> {
    private final PentaPredicate<A, B, C, D, E> filter;

    protected AbstractPentaJoiner() {
        this.filter = null;
    }

    protected AbstractPentaJoiner(PentaPredicate<A, B, C, D, E> filter) {
        this.filter = filter;
    }

    @SafeVarargs
    public static <A, B, C, D, E> AbstractPentaJoiner<A, B, C, D, E> merge(PentaJoiner<A, B, C, D, E> ... joiners) {
        ArrayList joinerList = new ArrayList();
        for (PentaJoiner<A, B, C, D, E> joiner : joiners) {
            if (joiner instanceof NonePentaJoiner) continue;
            if (joiner instanceof SinglePentaJoiner) {
                joinerList.add((SinglePentaJoiner)joiner);
                continue;
            }
            if (joiner instanceof CompositePentaJoiner) {
                joinerList.addAll(((CompositePentaJoiner)joiner).getJoinerList());
                continue;
            }
            throw new IllegalArgumentException("The joiner class (" + joiner.getClass() + ") is not supported.");
        }
        if (joinerList.isEmpty()) {
            return new NonePentaJoiner();
        }
        if (joinerList.size() == 1) {
            return (AbstractPentaJoiner)joinerList.get(0);
        }
        return new CompositePentaJoiner(joinerList);
    }

    public boolean matches(A a, B b, C c, D d, E e) {
        JoinerType[] joinerTypes = this.getJoinerTypes();
        for (int i = 0; i < joinerTypes.length; ++i) {
            Object rightMapping;
            JoinerType joinerType = joinerTypes[i];
            Object leftMapping = this.getLeftMapping(i).apply(a, b, c, d);
            if (joinerType.matches(leftMapping, rightMapping = this.getRightMapping(i).apply(e))) continue;
            return false;
        }
        return true;
    }

    public abstract QuadFunction<A, B, C, D, Object> getLeftMapping(int var1);

    public abstract QuadFunction<A, B, C, D, Object[]> getLeftCombinedMapping();

    public abstract Function<E, Object> getRightMapping(int var1);

    public abstract Function<E, Object[]> getRightCombinedMapping();

    public PentaPredicate<A, B, C, D, E> getFilter() {
        return this.filter;
    }
}

