/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.stream.common.AbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.common.ScoreImpactType;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.common.RuleBuilder;

public abstract class DroolsAbstractConstraintStream<Solution_>
extends AbstractConstraintStream<Solution_> {
    protected final DroolsConstraintFactory<Solution_> constraintFactory;
    private final List<DroolsAbstractConstraintStream<Solution_>> childStreamList = new ArrayList<DroolsAbstractConstraintStream<Solution_>>(2);

    public DroolsAbstractConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory) {
        this.constraintFactory = Objects.requireNonNull(constraintFactory);
    }

    protected DroolsConstraint<Solution_> buildConstraint(String constraintPackage, String constraintName, Score<?> constraintWeight, ScoreImpactType impactType, RuleBuilder<Solution_> ruleBuilder) {
        Function constraintWeightExtractor = this.buildConstraintWeightExtractor(constraintPackage, constraintName, constraintWeight);
        return new DroolsConstraint<Solution_>(this.constraintFactory, constraintPackage, constraintName, constraintWeightExtractor, impactType, false, ruleBuilder);
    }

    protected DroolsConstraint<Solution_> buildConstraintConfigurable(String constraintPackage, String constraintName, ScoreImpactType impactType, RuleBuilder<Solution_> ruleBuilder) {
        Function constraintWeightExtractor = this.buildConstraintWeightExtractor(constraintPackage, constraintName);
        return new DroolsConstraint<Solution_>(this.constraintFactory, constraintPackage, constraintName, constraintWeightExtractor, impactType, true, ruleBuilder);
    }

    public void addChildStream(DroolsAbstractConstraintStream<Solution_> childStream) {
        this.childStreamList.add(childStream);
    }

    public Collection<DroolsAbstractConstraintStream<Solution_>> getChildStreams() {
        return Collections.unmodifiableList(this.childStreamList);
    }

    @Override
    public DroolsConstraintFactory<Solution_> getConstraintFactory() {
        return this.constraintFactory;
    }
}

