/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.uni;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetGroupBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetGroupBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniTuple;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetGroupBridgeUniTuple;

public final class BavetGroupBridgeUniNode<A, NewA, ResultContainer_, NewB>
extends BavetAbstractUniNode<A> {
    private final BavetAbstractUniNode<A> parentNode;
    private final Function<A, NewA> groupKeyMapping;
    private final UniConstraintCollector<A, ResultContainer_, NewB> collector;
    private final Map<NewA, BavetGroupBiTuple<NewA, ResultContainer_, NewB>> tupleMap;
    private BavetGroupBiNode<NewA, ResultContainer_, NewB> groupNode;

    public BavetGroupBridgeUniNode(BavetConstraintSession session, int nodeIndex, BavetAbstractUniNode<A> parentNode, Function<A, NewA> groupKeyMapping, UniConstraintCollector<A, ResultContainer_, NewB> collector) {
        super(session, nodeIndex);
        this.parentNode = parentNode;
        this.groupKeyMapping = groupKeyMapping;
        this.collector = collector;
        this.tupleMap = new HashMap<NewA, BavetGroupBiTuple<NewA, ResultContainer_, NewB>>();
    }

    @Override
    public List<BavetAbstractUniNode<A>> getChildNodeList() {
        return Collections.emptyList();
    }

    public BavetGroupBridgeUniTuple<A, NewA, ResultContainer_, NewB> createTuple(BavetAbstractUniTuple<A> parentTuple) {
        return new BavetGroupBridgeUniTuple(this, parentTuple);
    }

    public void setGroupNode(BavetGroupBiNode<NewA, ResultContainer_, NewB> groupNode) {
        this.groupNode = groupNode;
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        if (this.groupNode == null) {
            throw new IllegalStateException("Impossible state: GroupBridgeNode (" + this + ") has no child GroupNode (" + this.groupNode + ").");
        }
        BavetGroupBridgeUniTuple tuple = (BavetGroupBridgeUniTuple)uncastTuple;
        if (tuple.getChildTuple() != null) {
            BavetGroupBiTuple childTuple = tuple.getChildTuple();
            Object oldGroupKey = childTuple.getGroupKey();
            int parentCount = childTuple.decreaseParentCount();
            tuple.getUndoAccumulator().run();
            childTuple.clearResult();
            tuple.setChildTuple(null);
            tuple.setUndoAccumulator(null);
            if (parentCount == 0) {
                this.tupleMap.remove(oldGroupKey);
                this.session.transitionTuple(childTuple, BavetTupleState.DYING);
            } else {
                this.session.transitionTuple(childTuple, BavetTupleState.UPDATING);
            }
        }
        if (tuple.isActive()) {
            Object a = tuple.getFactA();
            NewA groupKey = this.groupKeyMapping.apply(a);
            BavetGroupBiTuple childTuple = this.tupleMap.computeIfAbsent(groupKey, k -> this.groupNode.createTuple(groupKey, this.collector.supplier().get()));
            int parentCount = childTuple.increaseParentCount();
            Runnable undoAccumulator = this.collector.accumulator().apply(childTuple.getResultContainer(), a);
            tuple.setUndoAccumulator(undoAccumulator);
            childTuple.clearResult();
            tuple.setChildTuple(childTuple);
            if (parentCount == 1) {
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            } else if (childTuple.getState() != BavetTupleState.CREATING) {
                this.session.transitionTuple(childTuple, BavetTupleState.UPDATING);
            }
        }
    }

    public String toString() {
        return "GroupBridge()";
    }
}

