/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.bi;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetJoinBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;
import org.optaplanner.core.impl.score.stream.bavet.common.index.BavetIndex;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetJoinBridgeUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetJoinBridgeUniTuple;

public final class BavetJoinBiNode<A, B>
extends BavetAbstractBiNode<A, B>
implements BavetJoinNode {
    private final BavetJoinBridgeUniNode<A> leftParentNode;
    private final BavetJoinBridgeUniNode<B> rightParentNode;
    private final List<BavetAbstractBiNode<A, B>> childNodeList = new ArrayList<BavetAbstractBiNode<A, B>>();

    public BavetJoinBiNode(BavetConstraintSession session, int nodeIndex, BavetJoinBridgeUniNode<A> leftParentNode, BavetJoinBridgeUniNode<B> rightParentNode) {
        super(session, nodeIndex);
        this.leftParentNode = leftParentNode;
        this.rightParentNode = rightParentNode;
    }

    @Override
    public void addChildNode(BavetAbstractBiNode<A, B> childNode) {
        this.childNodeList.add(childNode);
    }

    @Override
    public List<BavetAbstractBiNode<A, B>> getChildNodeList() {
        return this.childNodeList;
    }

    @Override
    public BavetJoinBiTuple<A, B> createTuple(BavetAbstractBiTuple<A, B> parentTuple) {
        throw new IllegalStateException("The join node (" + this.getClass().getSimpleName() + ") can't have a parentTuple (" + parentTuple + ");");
    }

    public BavetJoinBiTuple<A, B> createTuple(BavetJoinBridgeUniTuple<A> aTuple, BavetJoinBridgeUniTuple<B> bTuple) {
        return new BavetJoinBiTuple<A, B>(this, aTuple, bTuple);
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        BavetJoinBiTuple tuple = (BavetJoinBiTuple)uncastTuple;
        List<BavetAbstractTuple> childTupleList = tuple.getChildTupleList();
        for (BavetAbstractTuple bavetAbstractTuple : childTupleList) {
            this.session.transitionTuple(bavetAbstractTuple, BavetTupleState.DYING);
        }
        childTupleList.clear();
        if (tuple.isActive()) {
            for (BavetAbstractBiNode bavetAbstractBiNode : this.childNodeList) {
                BavetAbstractBiTuple childTuple = bavetAbstractBiNode.createTuple(tuple);
                childTupleList.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
    }

    public void refreshChildTuplesLeft(BavetJoinBridgeUniTuple<A> leftParentTuple) {
        List<BavetAbstractTuple> leftTupleSet = leftParentTuple.getChildTupleList();
        for (BavetAbstractTuple tuple_ : leftTupleSet) {
            BavetJoinBiTuple tuple = (BavetJoinBiTuple)tuple_;
            boolean removed = tuple.getBTuple().getChildTupleList().remove(tuple);
            if (!removed) {
                throw new IllegalStateException("Impossible state: the fact (" + tuple.getFactA() + ")'s tuple cannot be removed from the other fact (" + tuple.getFactB() + ")'s join bridge.");
            }
            this.session.transitionTuple(tuple, BavetTupleState.DYING);
        }
        leftTupleSet.clear();
        if (leftParentTuple.isActive()) {
            Set<BavetJoinBridgeUniTuple<B>> rightParentTupleList = this.getRightIndex().get(leftParentTuple.getIndexProperties());
            for (BavetJoinBridgeUniTuple<B> rightParentTuple : rightParentTupleList) {
                if (rightParentTuple.isDirty()) continue;
                BavetJoinBiTuple<A, B> childTuple = this.createTuple(leftParentTuple, rightParentTuple);
                leftTupleSet.add(childTuple);
                rightParentTuple.getChildTupleList().add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
    }

    public void refreshChildTuplesRight(BavetJoinBridgeUniTuple<B> rightParentTuple) {
        List<BavetAbstractTuple> rightTupleSet = rightParentTuple.getChildTupleList();
        for (BavetAbstractTuple uncastTuple : rightTupleSet) {
            BavetJoinBiTuple tuple = (BavetJoinBiTuple)uncastTuple;
            boolean removed = tuple.getATuple().getChildTupleList().remove(tuple);
            if (!removed) {
                throw new IllegalStateException("Impossible state: the fact (" + tuple.getFactB() + ")'s tuple cannot be removed from the other fact (" + tuple.getFactA() + ")'s join bridge.");
            }
            this.session.transitionTuple(tuple, BavetTupleState.DYING);
        }
        rightTupleSet.clear();
        if (rightParentTuple.isActive()) {
            Set<BavetJoinBridgeUniTuple<A>> leftParentTupleList = this.getLeftIndex().get(rightParentTuple.getIndexProperties());
            for (BavetJoinBridgeUniTuple<A> leftParentTuple : leftParentTupleList) {
                if (leftParentTuple.isDirty()) continue;
                BavetJoinBiTuple<A, B> childTuple = this.createTuple(leftParentTuple, rightParentTuple);
                leftParentTuple.getChildTupleList().add(childTuple);
                rightTupleSet.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
    }

    public BavetIndex<BavetJoinBridgeUniTuple<A>> getLeftIndex() {
        return this.leftParentNode.getIndex();
    }

    public BavetIndex<BavetJoinBridgeUniTuple<B>> getRightIndex() {
        return this.rightParentNode.getIndex();
    }

    public String toString() {
        return "Join() with " + this.childNodeList.size() + " children";
    }
}

